/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class SingleStringInputDeferredEvaluationExpressionDimensionVectorSelector
implements SingleValueDimensionVectorSelector {
    private final SingleValueDimensionVectorSelector selector;
    private final ExprVectorProcessor<Object[]> stringProcessor;
    private final StringLookupVectorInputBindings inputBinding;

    public SingleStringInputDeferredEvaluationExpressionDimensionVectorSelector(SingleValueDimensionVectorSelector selector, Expr expression) {
        if (selector.getValueCardinality() == -1 || !selector.nameLookupPossibleInAdvance()) {
            throw new ISE("Selector of class[%s] does not have a dictionary, cannot use it.", selector.getClass().getName());
        }
        this.selector = selector;
        this.inputBinding = new StringLookupVectorInputBindings();
        this.stringProcessor = expression.asVectorProcessor(this.inputBinding);
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        ((StringLookupVectorInputBindings)this.inputBinding).currentValue[0] = this.selector.lookupName(id);
        return Evals.asString(this.stringProcessor.evalVector(this.inputBinding).values()[0]);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    public int[] getRowVector() {
        return this.selector.getRowVector();
    }

    @Override
    public int getMaxVectorSize() {
        return this.selector.getMaxVectorSize();
    }

    @Override
    public int getCurrentVectorSize() {
        return this.selector.getCurrentVectorSize();
    }

    private static final class StringLookupVectorInputBindings
    implements Expr.VectorInputBinding {
        private final Object[] currentValue = new Object[1];

        private StringLookupVectorInputBindings() {
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            return ExpressionType.STRING;
        }

        @Override
        public int getMaxVectorSize() {
            return 1;
        }

        @Override
        public int getCurrentVectorSize() {
            return 1;
        }

        @Override
        public int getCurrentVectorId() {
            return -1;
        }

        @Override
        public <T> T[] getObjectVector(String name) {
            return this.currentValue;
        }

        @Override
        public long[] getLongVector(String name) {
            throw new UnsupportedOperationException("attempt to get long[] from string[] only scalar binding");
        }

        @Override
        public double[] getDoubleVector(String name) {
            throw new UnsupportedOperationException("attempt to get double[] from string[] only scalar binding");
        }

        @Override
        @Nullable
        public boolean[] getNullVector(String name) {
            throw new UnsupportedOperationException("attempt to get boolean[] null vector from string[] only scalar binding");
        }
    }
}

