/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.timeline.DataSegment;

public class CompactionState {
    private final PartitionsSpec partitionsSpec;
    private final DimensionsSpec dimensionsSpec;
    private final Map<String, Object> transformSpec;
    private final Map<String, Object> indexSpec;
    private final Map<String, Object> granularitySpec;
    private final List<Object> metricsSpec;

    @JsonCreator
    public CompactionState(@JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") List<Object> metricsSpec, @JsonProperty(value="transformSpec") Map<String, Object> transformSpec, @JsonProperty(value="indexSpec") Map<String, Object> indexSpec, @JsonProperty(value="granularitySpec") Map<String, Object> granularitySpec) {
        this.partitionsSpec = partitionsSpec;
        this.dimensionsSpec = dimensionsSpec;
        this.metricsSpec = metricsSpec;
        this.transformSpec = transformSpec;
        this.indexSpec = indexSpec;
        this.granularitySpec = granularitySpec;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    public List<Object> getMetricsSpec() {
        return this.metricsSpec;
    }

    @JsonProperty
    public Map<String, Object> getTransformSpec() {
        return this.transformSpec;
    }

    @JsonProperty
    public Map<String, Object> getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public Map<String, Object> getGranularitySpec() {
        return this.granularitySpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionState that = (CompactionState)o;
        return Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.dimensionsSpec, that.dimensionsSpec) && Objects.equals(this.transformSpec, that.transformSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.granularitySpec, that.granularitySpec) && Objects.equals(this.metricsSpec, that.metricsSpec);
    }

    public int hashCode() {
        return Objects.hash(this.partitionsSpec, this.dimensionsSpec, this.transformSpec, this.indexSpec, this.granularitySpec, this.metricsSpec);
    }

    public String toString() {
        return "CompactionState{partitionsSpec=" + this.partitionsSpec + ", dimensionsSpec=" + this.dimensionsSpec + ", transformSpec=" + this.transformSpec + ", indexSpec=" + this.indexSpec + ", granularitySpec=" + this.granularitySpec + ", metricsSpec=" + this.metricsSpec + '}';
    }

    public static Function<Set<DataSegment>, Set<DataSegment>> addCompactionStateToSegments(PartitionsSpec partitionsSpec, DimensionsSpec dimensionsSpec, List<Object> metricsSpec, Map<String, Object> transformSpec, Map<String, Object> indexSpec, Map<String, Object> granularitySpec) {
        CompactionState compactionState = new CompactionState(partitionsSpec, dimensionsSpec, metricsSpec, transformSpec, indexSpec, granularitySpec);
        return segments -> segments.stream().map(s -> s.withLastCompactionState(compactionState)).collect(Collectors.toSet());
    }
}

