/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.timeline.partition.NumberedOverwritingPartitionChunk;
import org.apache.druid.timeline.partition.OverwriteShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class NumberedOverwriteShardSpec
implements OverwriteShardSpec {
    private final int partitionId;
    private final short startRootPartitionId;
    private final short endRootPartitionId;
    private final short minorVersion;
    private final short atomicUpdateGroupSize;

    @JsonCreator
    public NumberedOverwriteShardSpec(@JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="startRootPartitionId") int startRootPartitionId, @JsonProperty(value="endRootPartitionId") int endRootPartitionId, @JsonProperty(value="minorVersion") short minorVersion, @JsonProperty(value="atomicUpdateGroupSize") short atomicUpdateGroupSize) {
        Preconditions.checkArgument((partitionId >= 32768 && partitionId < 65536 ? 1 : 0) != 0, (String)"partitionNum[%s] >= %s && partitionNum[%s] < %s", (Object)partitionId, (Object)32768, (Object)partitionId, (Object)65536);
        Preconditions.checkArgument((startRootPartitionId >= 0 && startRootPartitionId < 32768 ? 1 : 0) != 0, (String)"startRootPartitionId[%s] >= %s && startRootPartitionId[%s] < %s", (Object)startRootPartitionId, (Object)0, (Object)startRootPartitionId, (Object)32768);
        Preconditions.checkArgument((endRootPartitionId >= 0 && endRootPartitionId < 32768 ? 1 : 0) != 0, (String)"endRootPartitionId[%s] >= %s && endRootPartitionId[%s] < %s", (Object)endRootPartitionId, (Object)0, (Object)endRootPartitionId, (Object)32768);
        Preconditions.checkArgument((minorVersion > 0 ? 1 : 0) != 0, (String)"minorVersion[%s] > 0", (int)minorVersion);
        Preconditions.checkArgument((atomicUpdateGroupSize > 0 || atomicUpdateGroupSize == -1 ? 1 : 0) != 0, (String)"atomicUpdateGroupSize[%s] > 0 or == %s", (int)atomicUpdateGroupSize, (int)-1);
        this.partitionId = partitionId;
        this.startRootPartitionId = (short)startRootPartitionId;
        this.endRootPartitionId = (short)endRootPartitionId;
        this.minorVersion = minorVersion;
        this.atomicUpdateGroupSize = atomicUpdateGroupSize;
    }

    public NumberedOverwriteShardSpec(int partitionId, int startRootPartitionId, int endRootPartitionId, short minorVersion) {
        this(partitionId, startRootPartitionId, endRootPartitionId, minorVersion, -1);
    }

    @Override
    public OverwriteShardSpec withAtomicUpdateGroupSize(short atomicUpdateGroupSize) {
        return new NumberedOverwriteShardSpec(this.partitionId, this.startRootPartitionId, this.endRootPartitionId, this.minorVersion, atomicUpdateGroupSize);
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new NumberedOverwritingPartitionChunk<T>(this.partitionId, obj);
    }

    @Override
    @JsonProperty(value="partitionId")
    public int getPartitionNum() {
        return this.partitionId;
    }

    @Override
    @JsonProperty
    public int getStartRootPartitionId() {
        return Short.toUnsignedInt(this.startRootPartitionId);
    }

    @Override
    @JsonProperty
    public int getEndRootPartitionId() {
        return Short.toUnsignedInt(this.endRootPartitionId);
    }

    @Override
    @JsonProperty
    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    @JsonProperty
    public short getAtomicUpdateGroupSize() {
        return this.atomicUpdateGroupSize;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return (timestamp, row) -> (ShardSpec)shardSpecs.get(0);
    }

    @Override
    public List<String> getDomainDimensions() {
        return Collections.emptyList();
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        return true;
    }

    @Override
    public String getType() {
        return "numbered_overwrite";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberedOverwriteShardSpec that = (NumberedOverwriteShardSpec)o;
        return this.partitionId == that.partitionId && this.startRootPartitionId == that.startRootPartitionId && this.endRootPartitionId == that.endRootPartitionId && this.minorVersion == that.minorVersion && this.atomicUpdateGroupSize == that.atomicUpdateGroupSize;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.startRootPartitionId, this.endRootPartitionId, this.minorVersion, this.atomicUpdateGroupSize);
    }

    public String toString() {
        return "NumberedOverwriteShardSpec{partitionId=" + this.partitionId + ", startRootPartitionId=" + this.startRootPartitionId + ", endRootPartitionId=" + this.endRootPartitionId + ", minorVersion=" + this.minorVersion + ", atomicUpdateGroupSize=" + this.atomicUpdateGroupSize + '}';
    }
}

