/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.allocation;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.java.util.common.ISE;

public class ArenaMemoryAllocator
implements MemoryAllocator {
    private final WritableMemory arena;
    private long allocations = 0L;
    private long position = 0L;
    private WritableMemory lastAllocation;

    private ArenaMemoryAllocator(WritableMemory arena) {
        this.arena = (WritableMemory)Preconditions.checkNotNull((Object)arena, (Object)"arena");
    }

    public static ArenaMemoryAllocator create(ByteBuffer buffer) {
        return new ArenaMemoryAllocator(WritableMemory.writableWrap((ByteBuffer)buffer.slice()));
    }

    public static ArenaMemoryAllocator createOnHeap(int capacity) {
        return ArenaMemoryAllocator.create(ByteBuffer.allocate(capacity));
    }

    @Override
    public Optional<ResourceHolder<WritableMemory>> allocate(long size) {
        if (this.position + size <= this.arena.getCapacity()) {
            WritableMemory memory;
            long start = this.position;
            ++this.allocations;
            this.position += size;
            this.lastAllocation = memory = this.arena.writableRegion(start, size, ByteOrder.LITTLE_ENDIAN);
            return Optional.of(new ResourceHolder<WritableMemory>(){
                boolean closed;

                @Override
                public WritableMemory get() {
                    if (this.closed) {
                        throw new ISE("Already closed", new Object[0]);
                    }
                    return memory;
                }

                @Override
                public void close() {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    if (memory == ArenaMemoryAllocator.this.lastAllocation) {
                        ArenaMemoryAllocator.this.position = ArenaMemoryAllocator.this.position - memory.getCapacity();
                        ArenaMemoryAllocator.this.lastAllocation = null;
                    }
                    if (--ArenaMemoryAllocator.this.allocations == 0L) {
                        ArenaMemoryAllocator.this.position = 0L;
                    }
                }
            });
        }
        return Optional.empty();
    }

    @Override
    public long available() {
        return this.arena.getCapacity() - this.position;
    }

    @Override
    public long capacity() {
        return this.arena.getCapacity();
    }
}

