/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Memory;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupMemoryMonitor
extends FeedDefiningMonitor {
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;

    public CgroupMemoryMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
    }

    public CgroupMemoryMonitor(Map<String, String[]> dimensions, String feed) {
        this(new ProcSelfCgroupDiscoverer(), dimensions, feed);
    }

    public CgroupMemoryMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CgroupMemoryMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        Memory memory = new Memory(this.cgroupDiscoverer);
        Memory.MemoryStat stat = memory.snapshot();
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        emitter.emit(builder.setMetric("cgroup/memory/usage/bytes", stat.getUsage()));
        emitter.emit(builder.setMetric("cgroup/memory/limit/bytes", stat.getLimit()));
        stat.getMemoryStats().forEach((key, value) -> emitter.emit(builder.setMetric(StringUtils.format("cgroup/memory/%s", key), (Number)value)));
        stat.getNumaMemoryStats().forEach((key, value) -> {
            this.builder().setDimension("numaZone", Long.toString(key));
            value.forEach((k, v) -> emitter.emit(builder.setMetric(StringUtils.format("cgroup/memory_numa/%s/pages", k), (Number)v)));
        });
        return true;
    }
}

