/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.CgroupUtil;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class Memory {
    private static final Logger LOG = new Logger(Memory.class);
    private static final String CGROUP = "memory";
    private static final String CGROUP_MEMORY_FILE = "memory.stat";
    private static final String MEMORY_USAGE_FILE = "memory.usage_in_bytes";
    private static final String MEMORY_LIMIT_FILE = "memory.limit_in_bytes";
    private static final String CGROUP_MEMORY_NUMA_FILE = "memory.numa_stat";
    private final CgroupDiscoverer cgroupDiscoverer;

    public Memory(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public MemoryStat snapshot() {
        String[] parts;
        String line2;
        Throwable throwable;
        BufferedReader reader;
        MemoryStat memoryStat = new MemoryStat();
        memoryStat.usage = CgroupUtil.readLongValue(this.cgroupDiscoverer, CGROUP, MEMORY_USAGE_FILE, -1L);
        memoryStat.limit = CgroupUtil.readLongValue(this.cgroupDiscoverer, CGROUP, MEMORY_LIMIT_FILE, -1L);
        try {
            reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), CGROUP_MEMORY_FILE));
            throwable = null;
            try {
                line2 = reader.readLine();
                while (line2 != null) {
                    parts = line2.split(Pattern.quote(" "));
                    if (parts.length != 2) {
                        break;
                    }
                    Long val = Longs.tryParse((String)parts[1]);
                    if (val == null) {
                        break;
                    }
                    memoryStat.memoryStats.put(parts[0], val);
                    line2 = reader.readLine();
                }
            }
            catch (Throwable line2) {
                throwable = line2;
                throw line2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable line2) {
                            throwable.addSuppressed(line2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.error(ex, "Unable to fetch memory snapshot", new Object[0]);
        }
        try {
            reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), CGROUP_MEMORY_NUMA_FILE));
            throwable = null;
            try {
                line2 = reader.readLine();
                while (line2 != null) {
                    parts = line2.split(Pattern.quote(" "));
                    String[] macro = parts[0].split(Pattern.quote("="));
                    String label = macro[0];
                    for (int i = 1; i < macro.length; ++i) {
                        String[] numaParts = parts[i].split(Pattern.quote("="));
                        long nodeNum = Long.parseLong(numaParts[0].substring(1));
                        long val = Long.parseLong(numaParts[1]);
                        Map nodeMetrics = memoryStat.numaMemoryStats.computeIfAbsent(nodeNum, l -> new HashMap());
                        nodeMetrics.put(label, val);
                    }
                    line2 = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error(e, "Unable to fetch memory_numa snapshot", new Object[0]);
        }
        return memoryStat;
    }

    public static class MemoryStat {
        private final Map<String, Long> memoryStats = new HashMap<String, Long>();
        private final Map<Long, Map<String, Long>> numaMemoryStats = new HashMap<Long, Map<String, Long>>();
        private long usage;
        private long limit;

        public Map<String, Long> getMemoryStats() {
            return ImmutableMap.copyOf(this.memoryStats);
        }

        public Map<Long, Map<String, Long>> getNumaMemoryStats() {
            return ImmutableMap.copyOf(this.numaMemoryStats);
        }

        public long getUsage() {
            return this.usage;
        }

        public long getLimit() {
            return this.limit;
        }
    }
}

