/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.BuiltInExprMacros;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.NamedFunction;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.FallbackVectorProcessor;
import org.apache.druid.query.expression.TimestampFloorExprMacro;

public class ExprMacroTable {
    private static final BuiltInExprMacros.ComplexDecodeBase64ExprMacro COMPLEX_DECODE_BASE_64_EXPR_MACRO = new BuiltInExprMacros.ComplexDecodeBase64ExprMacro();
    private static final List<ExprMacro> BUILT_IN = ImmutableList.of((Object)COMPLEX_DECODE_BASE_64_EXPR_MACRO, (Object)new AliasExprMacro(COMPLEX_DECODE_BASE_64_EXPR_MACRO, "decode_base64_complex"), (Object)new BuiltInExprMacros.StringDecodeBase64UTFExprMacro());
    private static final ExprMacroTable NIL = new ExprMacroTable(Collections.emptyList());
    private static final ExprMacroTable TIME_FLOOR_MACRO_TABLE = new ExprMacroTable(Collections.singletonList(new TimestampFloorExprMacro()));
    private final Map<String, ExprMacro> macroMap;

    public ExprMacroTable(List<ExprMacro> macros) {
        this.macroMap = Maps.newHashMapWithExpectedSize((int)(BUILT_IN.size() + macros.size()));
        this.macroMap.putAll(BUILT_IN.stream().collect(Collectors.toMap(m -> StringUtils.toLowerCase(m.name()), m -> m)));
        this.macroMap.putAll(macros.stream().collect(Collectors.toMap(m -> StringUtils.toLowerCase(m.name()), m -> m)));
    }

    public static ExprMacroTable nil() {
        return NIL;
    }

    public static ExprMacroTable granularity() {
        return TIME_FLOOR_MACRO_TABLE;
    }

    public List<ExprMacro> getMacros() {
        return ImmutableList.copyOf(this.macroMap.values());
    }

    @Nullable
    public Expr get(String functionName, List<Expr> args) {
        ExprMacro exprMacro = this.macroMap.get(StringUtils.toLowerCase(functionName));
        if (exprMacro == null) {
            return null;
        }
        return exprMacro.apply(args);
    }

    static class AliasExprMacro
    implements ExprMacro {
        private final ExprMacro exprMacro;
        private final String alias;

        public AliasExprMacro(ExprMacro baseExprMacro, String alias) {
            this.exprMacro = baseExprMacro;
            this.alias = alias;
        }

        @Override
        public Expr apply(List<Expr> args) {
            return this.exprMacro.apply(args);
        }

        @Override
        public String name() {
            return this.alias;
        }
    }

    public static abstract class BaseScalarMacroFunctionExpr
    extends BaseMacroFunctionExpr {
        public BaseScalarMacroFunctionExpr(ExprMacro macro, List<Expr> macroArgs) {
            super(macro, macroArgs);
        }

        @Override
        protected Expr.BindingAnalysis supplyAnalyzeInputs() {
            return Exprs.analyzeBindings(this.args).withScalarArguments((Set<Expr>)ImmutableSet.copyOf((Collection)this.args));
        }
    }

    public static abstract class BaseMacroFunctionExpr
    implements ExprMacroFunctionExpr {
        protected final ExprMacro macro;
        protected final List<Expr> args;
        private final Supplier<Expr.BindingAnalysis> analyzeInputsSupplier;

        protected BaseMacroFunctionExpr(ExprMacro macro, List<Expr> macroArgs) {
            this.macro = macro;
            this.args = macroArgs;
            this.analyzeInputsSupplier = Suppliers.memoize(this::supplyAnalyzeInputs);
        }

        @Override
        public List<Expr> getArgs() {
            return this.args;
        }

        @Override
        public String stringify() {
            return StringUtils.format("%s(%s)", this.macro.name(), this.args.size() == 1 ? this.args.get(0).stringify() : Expr.ARG_JOINER.join(this.args.stream().map(Expr::stringify).iterator()));
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            return shuttle.visit(this.macro.apply(shuttle.visitAll(this.args)));
        }

        @Override
        public Expr.BindingAnalysis analyzeInputs() {
            return (Expr.BindingAnalysis)this.analyzeInputsSupplier.get();
        }

        @Override
        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return this.canFallbackVectorize(inspector, this.args);
        }

        @Override
        public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
            return FallbackVectorProcessor.create(this.macro, this.args, inspector);
        }

        protected abstract Expr.BindingAnalysis supplyAnalyzeInputs();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseMacroFunctionExpr that = (BaseMacroFunctionExpr)o;
            return Objects.equals(this.macro, that.macro) && Objects.equals(this.args, that.args);
        }

        public int hashCode() {
            return Objects.hash(this.macro, this.args);
        }

        public String toString() {
            return StringUtils.format("(%s %s)", this.macro.name(), this.getArgs());
        }
    }

    public static interface ExprMacroFunctionExpr
    extends Expr {
        public List<Expr> getArgs();
    }

    public static interface ExprMacro
    extends NamedFunction {
        public Expr apply(List<Expr> var1);
    }
}

