/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.ValueType;

public class SingleValueBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector selector;
    private final ColumnType columnType;
    private final NullableTypeStrategy typeStrategy;
    private boolean isAggregateInvoked = false;

    public SingleValueBufferAggregator(ColumnValueSelector selector, ColumnType columnType) {
        this.selector = selector;
        this.columnType = columnType;
        this.typeStrategy = columnType.getNullableStrategy();
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.put(position, (byte)1);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if (this.isAggregateInvoked) {
            throw InvalidInput.exception("Subquery expression returned more than one row", new Object[0]);
        }
        int maxbufferSixe = 1 + (this.columnType.isNumeric() ? 8 : 1024);
        int written = this.typeStrategy.write(buf, position, this.getSelectorObject(), maxbufferSixe);
        if (written < 0) {
            throw DruidException.forPersona(DruidException.Persona.ADMIN).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Subquery result exceeds the buffer limit [%s]", maxbufferSixe);
        }
        this.isAggregateInvoked = true;
    }

    @Nullable
    private Object getSelectorObject() {
        if (this.columnType.isNumeric() && this.selector.isNull()) {
            return null;
        }
        switch ((ValueType)this.columnType.getType()) {
            case LONG: {
                return this.selector.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.selector.getFloat());
            }
            case DOUBLE: {
                return this.selector.getDouble();
            }
        }
        return this.selector.getObject();
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.typeStrategy.read(buf, position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return TypeStrategies.isNullableNull(buf, position) ? NullHandling.ZERO_FLOAT.floatValue() : TypeStrategies.readNotNullNullableFloat(buf, position);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return TypeStrategies.isNullableNull(buf, position) ? NullHandling.ZERO_DOUBLE : TypeStrategies.readNotNullNullableDouble(buf, position);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return TypeStrategies.isNullableNull(buf, position) ? NullHandling.ZERO_LONG : TypeStrategies.readNotNullNullableLong(buf, position);
    }

    @Override
    public void close() {
    }
}

