/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;

public abstract class NumericAnyBufferAggregator<TSelector extends BaseNullableColumnValueSelector>
implements BufferAggregator {
    private static final byte BYTE_FLAG_FOUND_MASK = 2;
    private static final byte BYTE_FLAG_NULL_MASK = 1;
    static final int FOUND_VALUE_OFFSET = 1;
    private final boolean useDefault = NullHandling.replaceWithDefault();
    final TSelector valueSelector;

    public NumericAnyBufferAggregator(TSelector valueSelector) {
        this.valueSelector = valueSelector;
    }

    abstract void initValue(ByteBuffer var1, int var2);

    abstract void putValue(ByteBuffer var1, int var2);

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.put(position, this.useDefault ? (byte)0 : 1);
        this.initValue(buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if ((buf.get(position) & 2) != 2) {
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.putValue(buf, position);
                buf.put(position, (byte)2);
            } else {
                buf.put(position, (byte)3);
            }
        }
    }

    boolean isValueNull(ByteBuffer buf, int position) {
        return (buf.get(position) & 1) == 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("valueSelector", this.valueSelector);
    }
}

