/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;

public interface ColumnHolder {
    public static final String TIME_COLUMN_NAME = "__time";
    public static final String DOUBLE_STORAGE_TYPE_PROPERTY = "druid.indexing.doubleStorage";

    public static boolean storeDoubleAsFloat() {
        String value = System.getProperty(DOUBLE_STORAGE_TYPE_PROPERTY, "double");
        return !"double".equals(StringUtils.toLowerCase(value));
    }

    public ColumnCapabilities getCapabilities();

    default public ColumnFormat getColumnFormat() {
        return new CapabilitiesBasedFormat(this.getCapabilities());
    }

    public int getLength();

    public BaseColumn getColumn();

    @Nullable
    default public Supplier<? extends BaseColumn> getColumnSupplier() {
        return this::getColumn;
    }

    @Nullable
    public ColumnIndexSupplier getIndexSupplier();

    public SettableColumnValueSelector makeNewSettableColumnValueSelector();
}

