/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.UOE;

public class VSizeLongSerde {
    public static final int[] SUPPORTED_SIZES = new int[]{1, 2, 4, 8, 12, 16, 20, 24, 32, 40, 48, 56, 64};
    public static final byte[] EMPTY = new byte[]{0, 0, 0, 0};

    public static int getBitsForMax(long value) {
        if (value < 0L) {
            throw new IAE("maxValue[%s] must be positive", value);
        }
        int numBits = 0;
        long maxValue = 1L;
        for (int supportedSize : SUPPORTED_SIZES) {
            while (numBits < supportedSize && maxValue < 0x3FFFFFFFFFFFFFFFL) {
                numBits = (byte)(numBits + 1);
                maxValue *= 2L;
            }
            if (value > maxValue && maxValue < 0x3FFFFFFFFFFFFFFFL) continue;
            return supportedSize;
        }
        return 64;
    }

    public static int getSerializedSize(int bitsPerValue, int numValues) {
        return (bitsPerValue * numValues + 7) / 8 + 4;
    }

    public static int getNumValuesPerBlock(int bitsPerValue, int blockSize) {
        int ret = 1;
        while (VSizeLongSerde.getSerializedSize(bitsPerValue, ret) <= blockSize) {
            ret *= 2;
        }
        return ret / 2;
    }

    public static LongSerializer getSerializer(int longSize, OutputStream output) {
        switch (longSize) {
            case 1: {
                return new Size1Ser(output);
            }
            case 2: {
                return new Size2Ser(output);
            }
            case 4: {
                return new Mult4Ser(output, 0);
            }
            case 8: {
                return new Mult8Ser(output, 1);
            }
            case 12: {
                return new Mult4Ser(output, 1);
            }
            case 16: {
                return new Mult8Ser(output, 2);
            }
            case 20: {
                return new Mult4Ser(output, 2);
            }
            case 24: {
                return new Mult8Ser(output, 3);
            }
            case 32: {
                return new Mult8Ser(output, 4);
            }
            case 40: {
                return new Mult8Ser(output, 5);
            }
            case 48: {
                return new Mult8Ser(output, 6);
            }
            case 56: {
                return new Mult8Ser(output, 7);
            }
            case 64: {
                return new Mult8Ser(output, 8);
            }
        }
        throw new IAE("Unsupported size %s", longSize);
    }

    public static LongSerializer getSerializer(int longSize, ByteBuffer buffer, int bufferOffset) {
        switch (longSize) {
            case 1: {
                return new Size1Ser(buffer, bufferOffset);
            }
            case 2: {
                return new Size2Ser(buffer, bufferOffset);
            }
            case 4: {
                return new Mult4Ser(buffer, bufferOffset, 0);
            }
            case 8: {
                return new Mult8Ser(buffer, bufferOffset, 1);
            }
            case 12: {
                return new Mult4Ser(buffer, bufferOffset, 1);
            }
            case 16: {
                return new Mult8Ser(buffer, bufferOffset, 2);
            }
            case 20: {
                return new Mult4Ser(buffer, bufferOffset, 2);
            }
            case 24: {
                return new Mult8Ser(buffer, bufferOffset, 3);
            }
            case 32: {
                return new Mult8Ser(buffer, bufferOffset, 4);
            }
            case 40: {
                return new Mult8Ser(buffer, bufferOffset, 5);
            }
            case 48: {
                return new Mult8Ser(buffer, bufferOffset, 6);
            }
            case 56: {
                return new Mult8Ser(buffer, bufferOffset, 7);
            }
            case 64: {
                return new Mult8Ser(buffer, bufferOffset, 8);
            }
        }
        throw new IAE("Unsupported size %s", longSize);
    }

    public static LongDeserializer getDeserializer(int longSize, ByteBuffer fromBuffer, int bufferOffset) {
        ByteBuffer buffer = fromBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        switch (longSize) {
            case 1: {
                return new Size1Des(buffer, bufferOffset);
            }
            case 2: {
                return new Size2Des(buffer, bufferOffset);
            }
            case 4: {
                return new Size4Des(buffer, bufferOffset);
            }
            case 8: {
                return new Size8Des(buffer, bufferOffset);
            }
            case 12: {
                return new Size12Des(buffer, bufferOffset);
            }
            case 16: {
                return new Size16Des(buffer, bufferOffset);
            }
            case 20: {
                return new Size20Des(buffer, bufferOffset);
            }
            case 24: {
                return new Size24Des(buffer, bufferOffset);
            }
            case 32: {
                return new Size32Des(buffer, bufferOffset);
            }
            case 40: {
                return new Size40Des(buffer, bufferOffset);
            }
            case 48: {
                return new Size48Des(buffer, bufferOffset);
            }
            case 56: {
                return new Size56Des(buffer, bufferOffset);
            }
            case 64: {
                return new Size64Des(buffer, bufferOffset);
            }
        }
        throw new IAE("Unsupported size %s", longSize);
    }

    private static final class Size64Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size64Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + (index << 3));
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int indexOffset = startIndex << 3;
            while (i < length) {
                out[outPosition + i] = base + this.buffer.getLong(this.offset + indexOffset);
                ++i;
                indexOffset += 8;
            }
        }

        @Override
        public int getDelta(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit, long base) {
            for (int i = 0; i < length; ++i) {
                int index = indexes[outPosition + i] - indexOffset;
                if (index >= limit) {
                    return i;
                }
                out[outPosition + i] = base + this.buffer.getLong(this.offset + (index << 3));
            }
            return length;
        }
    }

    private static final class Size56Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size56Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + index * 7) >>> 8;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int unpackSize = 56;
            int indexOffset = startIndex * 7;
            while (i + 8 < length) {
                long unpack = this.buffer.getLong(this.offset + indexOffset);
                long unpack2 = this.buffer.getLong(this.offset + indexOffset + 8);
                long unpack3 = this.buffer.getLong(this.offset + indexOffset + 16);
                long unpack4 = this.buffer.getLong(this.offset + indexOffset + 24);
                long unpack5 = this.buffer.getLong(this.offset + indexOffset + 32);
                long unpack6 = this.buffer.getLong(this.offset + indexOffset + 40);
                long unpack7 = this.buffer.getLong(this.offset + indexOffset + 48);
                out[outPosition + i++] = base + (unpack >>> 8 & 0xFFFFFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack & 0xFFL) << 48 | unpack2 >>> 16 & 0xFFFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack2 & 0xFFFFL) << 40 | unpack3 >>> 24 & 0xFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack3 & 0xFFFFFFL) << 32 | unpack4 >>> 32 & 0xFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack4 & 0xFFFFFFFFL) << 24 | unpack5 >>> 40 & 0xFFFFFFL);
                out[outPosition + i++] = base + ((unpack5 & 0xFFFFFFFFFFL) << 16 | unpack6 >>> 48 & 0xFFFFL);
                out[outPosition + i++] = base + ((unpack6 & 0xFFFFFFFFFFFFL) << 8 | unpack7 >>> 56 & 0xFFL);
                out[outPosition + i++] = base + (unpack7 & 0xFFFFFFFFFFFFFFL);
                indexOffset += 56;
            }
            while (i < length) {
                out[outPosition + i] = base + this.get(startIndex + i);
                ++i;
            }
        }
    }

    private static final class Size48Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size48Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + index * 6) >>> 16;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int unpackSize = 48;
            int indexOffset = startIndex * 6;
            while (i + 8 < length) {
                long unpack = this.buffer.getLong(this.offset + indexOffset);
                long unpack2 = this.buffer.getLong(this.offset + indexOffset + 8);
                long unpack3 = this.buffer.getLong(this.offset + indexOffset + 16);
                long unpack4 = this.buffer.getLong(this.offset + indexOffset + 24);
                long unpack5 = this.buffer.getLong(this.offset + indexOffset + 32);
                long unpack6 = this.buffer.getLong(this.offset + indexOffset + 40);
                out[outPosition + i++] = base + (unpack >>> 16 & 0xFFFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack & 0xFFFFL) << 32 | unpack2 >>> 32 & 0xFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack2 & 0xFFFFFFFFL) << 16 | unpack3 >>> 48 & 0xFFFFL);
                out[outPosition + i++] = base + (unpack3 & 0xFFFFFFFFFFFFL);
                out[outPosition + i++] = base + (unpack4 >>> 16 & 0xFFFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack4 & 0xFFFFL) << 32 | unpack5 >>> 32 & 0xFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack5 & 0xFFFFFFFFL) << 16 | unpack6 >>> 48 & 0xFFFFL);
                out[outPosition + i++] = base + (unpack6 & 0xFFFFFFFFFFFFL);
                indexOffset += 48;
            }
            while (i < length) {
                out[outPosition + i] = base + this.get(startIndex + i);
                ++i;
            }
        }
    }

    private static final class Size40Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size40Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getLong(this.offset + index * 5) >>> 24;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int unpackSize = 40;
            int indexOffset = startIndex * 5;
            while (i + 8 < length) {
                long unpack = this.buffer.getLong(this.offset + indexOffset);
                long unpack2 = this.buffer.getLong(this.offset + indexOffset + 8);
                long unpack3 = this.buffer.getLong(this.offset + indexOffset + 16);
                long unpack4 = this.buffer.getLong(this.offset + indexOffset + 24);
                long unpack5 = this.buffer.getLong(this.offset + indexOffset + 32);
                out[outPosition + i++] = base + (unpack >>> 24 & 0xFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack & 0xFFFFFFL) << 16 | unpack2 >>> 48 & 0xFFFFL);
                out[outPosition + i++] = base + (unpack2 >>> 8 & 0xFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack2 & 0xFFL) << 32 | unpack3 >>> 32 & 0xFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack3 & 0xFFFFFFFFL) << 8 | unpack4 >>> 56 & 0xFFL);
                out[outPosition + i++] = base + (unpack4 >>> 16 & 0xFFFFFFFFFFL);
                out[outPosition + i++] = base + ((unpack4 & 0xFFFFL) << 24 | unpack5 >>> 40 & 0xFFFFFFL);
                out[outPosition + i++] = base + (unpack5 & 0xFFFFFFFFFFL);
                indexOffset += 40;
            }
            while (i < length) {
                out[outPosition + i] = base + this.get(startIndex + i);
                ++i;
            }
        }
    }

    private static final class Size32Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size32Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return (long)this.buffer.getInt(this.offset + (index << 2)) & 0xFFFFFFFFL;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int indexOffset = startIndex << 2;
            while (i < length) {
                out[outPosition + i] = base + ((long)this.buffer.getInt(this.offset + indexOffset) & 0xFFFFFFFFL);
                ++i;
                indexOffset += 4;
            }
        }
    }

    private static final class Size24Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size24Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getInt(this.offset + index * 3) >>> 8;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int unpackSize = 24;
            int indexOffset = startIndex * 3;
            while (i + 8 < length) {
                long unpack = this.buffer.getLong(this.offset + indexOffset);
                long unpack2 = this.buffer.getLong(this.offset + indexOffset + 8);
                long unpack3 = this.buffer.getLong(this.offset + indexOffset + 8 + 8);
                out[outPosition + i++] = base + (unpack >> 40 & 0xFFFFFFL);
                out[outPosition + i++] = base + (unpack >> 16 & 0xFFFFFFL);
                out[outPosition + i++] = base + ((unpack & 0xFFFFL) << 8 | unpack2 >>> 56 & 0xFFL);
                out[outPosition + i++] = base + (unpack2 >> 32 & 0xFFFFFFL);
                out[outPosition + i++] = base + (unpack2 >> 8 & 0xFFFFFFL);
                out[outPosition + i++] = base + ((unpack2 & 0xFFL) << 16 | unpack3 >>> 48 & 0xFFFFL);
                out[outPosition + i++] = base + (unpack3 >> 24 & 0xFFFFFFL);
                out[outPosition + i++] = base + (unpack3 & 0xFFFFFFL);
                indexOffset += 24;
            }
            while (i < length) {
                out[outPosition + i] = base + this.get(startIndex + i);
                ++i;
            }
        }
    }

    private static final class Size20Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size20Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = ((index + 1 & 1) << 2) + 8;
            int indexOffset = index * 5 >> 1;
            return this.buffer.getInt(this.offset + indexOffset) >> shift & 0xFFFFF;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int index = startIndex;
            if ((index & 1) != 0) {
                out[outPosition + i++] = base + this.get(index++);
            }
            int unpackSize = 20;
            int indexOffset = index * 5 >> 1;
            while (i + 8 < length) {
                long unpack = this.buffer.getLong(this.offset + indexOffset);
                long unpack2 = this.buffer.getLong(this.offset + indexOffset + 8);
                int unpack3 = this.buffer.getInt(this.offset + indexOffset + 8 + 8);
                out[outPosition + i++] = base + (unpack >> 44 & 0xFFFFFL);
                out[outPosition + i++] = base + (unpack >> 24 & 0xFFFFFL);
                out[outPosition + i++] = base + (unpack >> 4 & 0xFFFFFL);
                out[outPosition + i++] = base + ((unpack & 0xFL) << 16 | unpack2 >>> 48 & 0xFFFFL);
                out[outPosition + i++] = base + (unpack2 >> 28 & 0xFFFFFL);
                out[outPosition + i++] = base + (unpack2 >> 8 & 0xFFFFFL);
                out[outPosition + i++] = base + ((unpack2 & 0xFFL) << 12 | (long)(unpack3 >>> 20 & 0xFFF));
                out[outPosition + i++] = base + (long)(unpack3 & 0xFFFFF);
                indexOffset += 20;
            }
            while (i < length) {
                out[outPosition + i] = base + this.get(startIndex + i);
                ++i;
            }
        }
    }

    private static final class Size16Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size16Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.getShort(this.offset + (index << 1)) & 0xFFFF;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int indexOffset = startIndex << 1;
            while (i < length) {
                out[outPosition + i] = base + (long)(this.buffer.getShort(this.offset + indexOffset) & 0xFFFF);
                ++i;
                indexOffset += 2;
            }
        }

        @Override
        public int getDelta(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit, long base) {
            for (int i = 0; i < length; ++i) {
                int index = indexes[outPosition + i] - indexOffset;
                if (index >= limit) {
                    return i;
                }
                out[outPosition + i] = base + (long)(this.buffer.getShort(this.offset + (index << 1)) & 0xFFFF);
            }
            return length;
        }
    }

    private static final class Size12Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size12Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = (index + 1 & 1) << 2;
            int indexOffset = index * 3 >> 1;
            return this.buffer.getShort(this.offset + indexOffset) >> shift & 0xFFF;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int index = startIndex;
            if ((index & 1) != 0) {
                out[outPosition + i++] = base + this.get(index++);
            }
            int unpackSize = 12;
            int indexOffset = index * 3 >> 1;
            while (i + 8 < length) {
                long unpack = this.buffer.getLong(this.offset + indexOffset);
                int unpack2 = this.buffer.getInt(this.offset + indexOffset + 8);
                out[outPosition + i++] = base + (unpack >> 52 & 0xFFFL);
                out[outPosition + i++] = base + (unpack >> 40 & 0xFFFL);
                out[outPosition + i++] = base + (unpack >> 28 & 0xFFFL);
                out[outPosition + i++] = base + (unpack >> 16 & 0xFFFL);
                out[outPosition + i++] = base + (unpack >> 4 & 0xFFFL);
                out[outPosition + i++] = base + ((unpack & 0xFL) << 8 | (long)(unpack2 >>> 24 & 0xFF));
                out[outPosition + i++] = base + (long)(unpack2 >> 12 & 0xFFF);
                out[outPosition + i++] = base + (long)(unpack2 & 0xFFF);
                indexOffset += 12;
            }
            while (i < length) {
                out[outPosition + i] = base + this.get(startIndex + i);
                ++i;
            }
        }
    }

    private static final class Size8Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size8Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            return this.buffer.get(this.offset + index) & 0xFF;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int i = 0;
            int indexOffset = startIndex;
            while (i < length) {
                out[outPosition + i] = base + (long)(this.buffer.get(this.offset + indexOffset) & 0xFF);
                ++i;
                ++indexOffset;
            }
        }

        @Override
        public int getDelta(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit, long base) {
            for (int i = 0; i < length; ++i) {
                int index = indexes[outPosition + i] - indexOffset;
                if (index >= limit) {
                    return i;
                }
                out[outPosition + i] = base + (long)(this.buffer.get(this.offset + index) & 0xFF);
            }
            return length;
        }

        @Override
        public void getTable(long[] out, int outPosition, int startIndex, int length, long[] table) {
            int i = 0;
            int indexOffset = startIndex;
            while (i < length) {
                out[outPosition + i] = table[this.buffer.get(this.offset + indexOffset) & 0xFF];
                ++i;
                ++indexOffset;
            }
        }

        @Override
        public int getTable(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit, long[] table) {
            for (int i = 0; i < length; ++i) {
                int index = indexes[outPosition + i] - indexOffset;
                if (index >= limit) {
                    return i;
                }
                out[outPosition + i] = table[this.buffer.get(this.offset + index) & 0xFF];
            }
            return length;
        }
    }

    private static final class Size4Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size4Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = (index + 1 & 1) << 2;
            return this.buffer.get(this.offset + (index >> 1)) >> shift & 0xF;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int index = startIndex;
            int i = 0;
            while ((index & 1) != 0 && i < length) {
                out[outPosition + i++] = base + (this.get(index++) & 0xFL);
            }
            while (i + 8 < length) {
                int unpack = this.buffer.getInt(this.offset + (index >> 1));
                out[outPosition + i++] = base + (long)(unpack >> 28 & 0xF);
                out[outPosition + i++] = base + (long)(unpack >> 24 & 0xF);
                out[outPosition + i++] = base + (long)(unpack >> 20 & 0xF);
                out[outPosition + i++] = base + (long)(unpack >> 16 & 0xF);
                out[outPosition + i++] = base + (long)(unpack >> 12 & 0xF);
                out[outPosition + i++] = base + (long)(unpack >> 8 & 0xF);
                out[outPosition + i++] = base + (long)(unpack >> 4 & 0xF);
                out[outPosition + i++] = base + (long)(unpack & 0xF);
                index += 8;
            }
            while (i < length) {
                out[outPosition + i++] = base + this.get(index++);
            }
        }

        @Override
        public void getTable(long[] out, int outPosition, int startIndex, int length, long[] table) {
            int index = startIndex;
            int i = 0;
            while ((index & 1) != 0 && i < length) {
                out[outPosition + i++] = table[(int)this.get(index++)];
            }
            while (i + 8 < length) {
                int unpack = this.buffer.getInt(this.offset + (index >> 1));
                out[outPosition + i++] = table[unpack >> 28 & 0xF];
                out[outPosition + i++] = table[unpack >> 24 & 0xF];
                out[outPosition + i++] = table[unpack >> 20 & 0xF];
                out[outPosition + i++] = table[unpack >> 16 & 0xF];
                out[outPosition + i++] = table[unpack >> 12 & 0xF];
                out[outPosition + i++] = table[unpack >> 8 & 0xF];
                out[outPosition + i++] = table[unpack >> 4 & 0xF];
                out[outPosition + i++] = table[unpack & 0xF];
                index += 8;
            }
            while (i < length) {
                out[outPosition + i++] = table[(int)this.get(index++)];
            }
        }
    }

    private static final class Size2Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size2Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = 6 - ((index & 3) << 1);
            return this.buffer.get(this.offset + (index >> 2)) >> shift & 3;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int index = startIndex;
            int i = 0;
            while ((index & 3) != 0 && i < length) {
                out[outPosition + i++] = base + this.get(index++);
            }
            while (i + 8 < length) {
                short unpack = this.buffer.getShort(this.offset + (index >> 2));
                out[outPosition + i++] = base + (long)(unpack >> 14 & 3);
                out[outPosition + i++] = base + (long)(unpack >> 12 & 3);
                out[outPosition + i++] = base + (long)(unpack >> 10 & 3);
                out[outPosition + i++] = base + (long)(unpack >> 8 & 3);
                out[outPosition + i++] = base + (long)(unpack >> 6 & 3);
                out[outPosition + i++] = base + (long)(unpack >> 4 & 3);
                out[outPosition + i++] = base + (long)(unpack >> 2 & 3);
                out[outPosition + i++] = base + (long)(unpack & 3);
                index += 8;
            }
            while (i < length) {
                out[outPosition + i++] = base + this.get(index++);
            }
        }

        @Override
        public void getTable(long[] out, int outPosition, int startIndex, int length, long[] table) {
            int index = startIndex;
            int i = 0;
            while ((index & 3) != 0 && i < length) {
                out[outPosition + i++] = table[(int)this.get(index++)];
            }
            while (i + 8 < length) {
                short unpack = this.buffer.getShort(this.offset + (index >> 2));
                out[outPosition + i++] = table[unpack >> 14 & 3];
                out[outPosition + i++] = table[unpack >> 12 & 3];
                out[outPosition + i++] = table[unpack >> 10 & 3];
                out[outPosition + i++] = table[unpack >> 8 & 3];
                out[outPosition + i++] = table[unpack >> 6 & 3];
                out[outPosition + i++] = table[unpack >> 4 & 3];
                out[outPosition + i++] = table[unpack >> 2 & 3];
                out[outPosition + i++] = table[unpack & 3];
                index += 8;
            }
            while (i < length) {
                out[outPosition + i++] = table[(int)this.get(index++)];
            }
        }
    }

    private static final class Size1Des
    implements LongDeserializer {
        final ByteBuffer buffer;
        final int offset;

        public Size1Des(ByteBuffer buffer, int bufferOffset) {
            this.buffer = buffer;
            this.offset = bufferOffset;
        }

        @Override
        public long get(int index) {
            int shift = 7 - (index & 7);
            return this.buffer.get(this.offset + (index >> 3)) >> shift & 1;
        }

        @Override
        public void getDelta(long[] out, int outPosition, int startIndex, int length, long base) {
            int index = startIndex;
            int i = 0;
            while ((index & 7) != 0 && i < length) {
                out[outPosition + i++] = base + this.get(index++);
            }
            while (i + 8 < length) {
                byte unpack = this.buffer.get(this.offset + (index >> 3));
                out[outPosition + i++] = base + (long)(unpack >> 7 & 1);
                out[outPosition + i++] = base + (long)(unpack >> 6 & 1);
                out[outPosition + i++] = base + (long)(unpack >> 5 & 1);
                out[outPosition + i++] = base + (long)(unpack >> 4 & 1);
                out[outPosition + i++] = base + (long)(unpack >> 3 & 1);
                out[outPosition + i++] = base + (long)(unpack >> 2 & 1);
                out[outPosition + i++] = base + (long)(unpack >> 1 & 1);
                out[outPosition + i++] = base + (long)(unpack & 1);
                index += 8;
            }
            while (i < length) {
                out[outPosition + i++] = base + this.get(index++);
            }
        }

        @Override
        public void getTable(long[] out, int outPosition, int startIndex, int length, long[] table) {
            int index = startIndex;
            int i = 0;
            while ((index & 7) != 0 && i < length) {
                out[outPosition + i++] = table[(int)this.get(index++)];
            }
            while (i + 8 < length) {
                byte unpack = this.buffer.get(this.offset + (index >> 3));
                out[outPosition + i++] = table[unpack >> 7 & 1];
                out[outPosition + i++] = table[unpack >> 6 & 1];
                out[outPosition + i++] = table[unpack >> 5 & 1];
                out[outPosition + i++] = table[unpack >> 4 & 1];
                out[outPosition + i++] = table[unpack >> 3 & 1];
                out[outPosition + i++] = table[unpack >> 2 & 1];
                out[outPosition + i++] = table[unpack >> 1 & 1];
                out[outPosition + i++] = table[unpack & 1];
                index += 8;
            }
            while (i < length) {
                out[outPosition + i++] = table[(int)this.get(index++)];
            }
        }
    }

    public static interface LongDeserializer {
        public long get(int var1);

        public void getDelta(long[] var1, int var2, int var3, int var4, long var5);

        default public int getDelta(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit, long base) {
            for (int i = 0; i < length; ++i) {
                int index = indexes[outPosition + i] - indexOffset;
                if (index >= limit) {
                    return i;
                }
                out[outPosition + i] = base + this.get(index);
            }
            return length;
        }

        default public void getTable(long[] out, int outPosition, int startIndex, int length, long[] table) {
            throw new UOE("Table decoding not supported for %s", this.getClass().getSimpleName());
        }

        default public int getTable(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit, long[] table) {
            for (int i = 0; i < length; ++i) {
                int index = indexes[outPosition + i] - indexOffset;
                if (index >= limit) {
                    return i;
                }
                out[outPosition + i] = table[(int)this.get(index)];
            }
            return length;
        }
    }

    private static final class Mult8Ser
    implements LongSerializer {
        @Nullable
        OutputStream output;
        ByteBuffer buffer;
        int numBytes;
        private boolean closed = false;

        public Mult8Ser(OutputStream output, int numBytes) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(1);
            this.numBytes = numBytes;
        }

        public Mult8Ser(ByteBuffer buffer, int offset, int numBytes) {
            this.buffer = buffer;
            this.buffer.position(offset);
            this.numBytes = numBytes;
        }

        @Override
        public void write(long value) throws IOException {
            if (this.numBytes != 8) {
                Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
            }
            for (int i = this.numBytes - 1; i >= 0; --i) {
                this.buffer.put((byte)(value >>> i * 8));
                if (this.output == null) continue;
                this.output.write(this.buffer.array());
                this.buffer.position(0);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.output != null) {
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    private static final class Mult4Ser
    implements LongSerializer {
        @Nullable
        OutputStream output;
        ByteBuffer buffer;
        int numBytes;
        byte curByte = 0;
        boolean first = true;
        private boolean closed = false;

        public Mult4Ser(OutputStream output, int numBytes) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(numBytes * 2 + 1);
            this.numBytes = numBytes;
        }

        public Mult4Ser(ByteBuffer buffer, int offset, int numBytes) {
            this.buffer = buffer;
            this.buffer.position(offset);
            this.numBytes = numBytes;
        }

        @Override
        public void write(long value) throws IOException {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
            int shift = 0;
            if (this.first) {
                shift = 4;
                this.curByte = (byte)value;
                this.first = false;
            } else {
                this.curByte = (byte)((long)(this.curByte << 4) | value >> (this.numBytes << 3) & 0xFL);
                this.buffer.put(this.curByte);
                this.first = true;
            }
            for (int i = this.numBytes - 1; i >= 0; --i) {
                this.buffer.put((byte)(value >>> i * 8 + shift));
            }
            if (!this.buffer.hasRemaining() && this.output != null) {
                this.output.write(this.buffer.array());
                this.buffer.rewind();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.first) {
                this.buffer.put((byte)(this.curByte << 4));
            }
            if (this.output != null) {
                this.output.write(this.buffer.array(), 0, this.buffer.position());
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    private static final class Size2Ser
    implements LongSerializer {
        @Nullable
        OutputStream output = null;
        ByteBuffer buffer;
        byte curByte = 0;
        int count = 0;
        private boolean closed = false;

        public Size2Ser(OutputStream output) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(1);
        }

        public Size2Ser(ByteBuffer buffer, int offset) {
            this.buffer = buffer;
            this.buffer.position(offset);
        }

        @Override
        public void write(long value) throws IOException {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
            if (this.count == 8) {
                this.buffer.put(this.curByte);
                this.count = 0;
                if (!this.buffer.hasRemaining() && this.output != null) {
                    this.output.write(this.buffer.array());
                    this.buffer.rewind();
                }
            }
            this.curByte = (byte)((long)(this.curByte << 2) | value & 3L);
            this.count += 2;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.buffer.put((byte)(this.curByte << 8 - this.count));
            if (this.output != null) {
                this.output.write(this.buffer.array());
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    private static final class Size1Ser
    implements LongSerializer {
        @Nullable
        OutputStream output = null;
        ByteBuffer buffer;
        byte curByte = 0;
        int count = 0;
        private boolean closed = false;

        public Size1Ser(OutputStream output) {
            this.output = output;
            this.buffer = ByteBuffer.allocate(1);
        }

        public Size1Ser(ByteBuffer buffer, int offset) {
            this.buffer = buffer;
            this.buffer.position(offset);
        }

        @Override
        public void write(long value) throws IOException {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
            if (this.count == 8) {
                this.buffer.put(this.curByte);
                this.count = 0;
                if (!this.buffer.hasRemaining() && this.output != null) {
                    this.output.write(this.buffer.array());
                    this.buffer.rewind();
                }
            }
            this.curByte = (byte)((long)(this.curByte << 1) | value & 1L);
            ++this.count;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.buffer.put((byte)(this.curByte << 8 - this.count));
            if (this.output != null) {
                this.output.write(this.buffer.array());
                this.output.write(EMPTY);
                this.output.flush();
            } else {
                this.buffer.putInt(0);
            }
            this.closed = true;
        }
    }

    public static interface LongSerializer
    extends Closeable {
        public void write(long var1) throws IOException;
    }
}

