/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.incremental.IncrementalIndexColumnSelectorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class IncrementalIndexCursorHolder
implements CursorHolder {
    private final IncrementalIndexRowSelector rowSelector;
    private final CursorBuildSpec spec;
    private final List<OrderBy> ordering;

    public IncrementalIndexCursorHolder(IncrementalIndexRowSelector rowSelector, CursorBuildSpec spec) {
        this.rowSelector = rowSelector;
        this.spec = spec;
        List<OrderBy> ordering = rowSelector.getOrdering();
        this.ordering = Cursors.getTimeOrdering(ordering) != Order.NONE ? (Cursors.preferDescendingTimeOrdering(spec) ? Cursors.descendingTimeOrder() : Cursors.ascendingTimeOrder()) : ordering;
    }

    @Override
    public Cursor asCursor() {
        if (this.rowSelector.isEmpty()) {
            return null;
        }
        if (this.spec.getQueryMetrics() != null) {
            this.spec.getQueryMetrics().vectorized(false);
        }
        IncrementalIndexRowHolder currentRow = new IncrementalIndexRowHolder();
        return new IncrementalIndexCursor(this.rowSelector, currentRow, this.makeSelectorFactory(this.spec, currentRow), this.spec, IncrementalIndexCursorHolder.getTimeOrder(this.ordering));
    }

    @Override
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    public ColumnSelectorFactory makeSelectorFactory(CursorBuildSpec buildSpec, IncrementalIndexRowHolder currEntry) {
        return new IncrementalIndexColumnSelectorFactory(this.rowSelector, currEntry, buildSpec.getVirtualColumns(), this.getTimeOrder());
    }

    private static Order getTimeOrder(List<OrderBy> ordering) {
        if (!ordering.isEmpty() && "__time".equals(ordering.get(0).getColumnName())) {
            return ordering.get(0).getOrder();
        }
        return Order.NONE;
    }

    static class IncrementalIndexCursor
    implements Cursor {
        private final Iterable<IncrementalIndexRow> cursorIterable;
        private final IncrementalIndexRowHolder currEntry;
        private final ColumnSelectorFactory columnSelectorFactory;
        private final ValueMatcher filterMatcher;
        private final int maxRowIndex;
        private @MonotonicNonNull Iterator<IncrementalIndexRow> baseIter;
        private int numAdvanced;
        private boolean done;

        IncrementalIndexCursor(IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder currentRow, ColumnSelectorFactory selectorFactory, CursorBuildSpec buildSpec, Order timeOrder) {
            this.currEntry = currentRow;
            this.columnSelectorFactory = selectorFactory;
            this.maxRowIndex = rowSelector.getLastRowIndex();
            this.numAdvanced = -1;
            this.cursorIterable = rowSelector.getFacts().timeRangeIterable(timeOrder == Order.DESCENDING, buildSpec.getInterval().getStartMillis(), buildSpec.getInterval().getEndMillis());
            this.filterMatcher = buildSpec.getFilter() == null ? ValueMatchers.allTrue() : buildSpec.getFilter().makeMatcher(this.columnSelectorFactory);
            this.reset();
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public void advance() {
            if (!this.baseIter.hasNext()) {
                this.done = true;
                return;
            }
            while (this.baseIter.hasNext()) {
                BaseQuery.checkInterrupted();
                IncrementalIndexRow entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) continue;
                this.currEntry.set(entry);
                if (!this.filterMatcher.matches(false)) continue;
                return;
            }
            this.done = true;
        }

        @Override
        public void advanceUninterruptibly() {
            if (!this.baseIter.hasNext()) {
                this.done = true;
                return;
            }
            while (this.baseIter.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                IncrementalIndexRow entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) continue;
                this.currEntry.set(entry);
                if (!this.filterMatcher.matches(false)) continue;
                return;
            }
            this.done = true;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.baseIter = this.cursorIterable.iterator();
            if (this.numAdvanced == -1) {
                this.numAdvanced = 0;
            } else {
                Iterators.advance(this.baseIter, (int)this.numAdvanced);
            }
            BaseQuery.checkInterrupted();
            boolean foundMatched = false;
            while (this.baseIter.hasNext()) {
                IncrementalIndexRow entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) {
                    ++this.numAdvanced;
                    continue;
                }
                this.currEntry.set(entry);
                if (this.filterMatcher.matches(false)) {
                    foundMatched = true;
                    break;
                }
                ++this.numAdvanced;
            }
            this.done = !foundMatched;
        }

        private boolean beyondMaxRowIndex(int rowIndex) {
            return rowIndex > this.maxRowIndex;
        }
    }
}

