/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReaders;
import org.apache.druid.frame.segment.columnar.FrameQueryableIndex;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;
import org.apache.druid.segment.join.table.RowBasedIndexBuilder;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;

public class FrameBasedIndexedTable
implements IndexedTable {
    private static final Logger LOG = new Logger(FrameBasedIndexedTable.class);
    private final Set<String> keyColumns;
    private final RowSignature rowSignature;
    private final String version;
    private final List<IndexedTable.Index> keyColumnsIndexes;
    private final int numRows;
    private final List<QueryableIndex> frameQueryableIndexes = new ArrayList<QueryableIndex>();
    private final List<Integer> cumulativeRowCount = new ArrayList<Integer>();

    public FrameBasedIndexedTable(FrameBasedInlineDataSource frameBasedInlineDataSource, Set<String> keyColumns, String version) {
        this.keyColumns = keyColumns;
        this.version = version;
        this.rowSignature = frameBasedInlineDataSource.getRowSignature();
        int rowCount = 0;
        for (FrameSignaturePair frameSignaturePair2 : frameBasedInlineDataSource.getFrames()) {
            Frame frame = frameSignaturePair2.getFrame();
            RowSignature frameRowSignature = frameSignaturePair2.getRowSignature();
            this.frameQueryableIndexes.add(new FrameQueryableIndex(frame, frameRowSignature, this.createColumnReaders(frameRowSignature)));
            this.cumulativeRowCount.add(rowCount += frame.numRows());
        }
        this.numRows = rowCount;
        ArrayList<RowBasedIndexBuilder> indexBuilders = new ArrayList<RowBasedIndexBuilder>(this.rowSignature.size());
        ArrayList<String> keyColumnNames = new ArrayList<String>(keyColumns.size());
        for (int i = 0; i < this.rowSignature.size(); ++i) {
            RowBasedIndexBuilder m;
            String columnName = this.rowSignature.getColumnName(i);
            if (keyColumns.contains(columnName)) {
                ColumnType keyType = this.rowSignature.getColumnType(i).orElse(IndexedTableJoinMatcher.DEFAULT_KEY_TYPE);
                m = new RowBasedIndexBuilder(keyType);
                keyColumnNames.add(columnName);
            } else {
                m = null;
            }
            indexBuilders.add(m);
        }
        Sequence cursorFactories = Sequences.simple(frameBasedInlineDataSource.getFrames().stream().map(frameSignaturePair -> {
            Frame frame = frameSignaturePair.getFrame();
            RowSignature rowSignature = frameSignaturePair.getRowSignature();
            return FrameReader.create(rowSignature).makeCursorFactory(frame);
        }).collect(Collectors.toList()));
        Sequence sequence = Sequences.map(cursorFactories, cursorFactory -> {
            try (CursorHolder holder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
                Cursor cursor = holder.asCursor();
                if (cursor == null) {
                    Integer n = 0;
                    return n;
                }
                int rowNumber = 0;
                ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                List selectors = keyColumnNames.stream().map(columnSelectorFactory::makeColumnValueSelector).collect(Collectors.toList());
                while (!cursor.isDone()) {
                    for (int keyColumnSelectorIndex = 0; keyColumnSelectorIndex < selectors.size(); ++keyColumnSelectorIndex) {
                        String keyColumnName = (String)keyColumnNames.get(keyColumnSelectorIndex);
                        int columnPosition = this.rowSignature.indexOf(keyColumnName);
                        RowBasedIndexBuilder keyColumnIndexBuilder = (RowBasedIndexBuilder)indexBuilders.get(columnPosition);
                        keyColumnIndexBuilder.add(((BaseObjectColumnValueSelector)selectors.get(keyColumnSelectorIndex)).getObject());
                    }
                    if (rowNumber % 100000 == 0) {
                        if (rowNumber == 0) {
                            LOG.debug("Indexed first row for frame based datasource", new Object[0]);
                        } else {
                            LOG.debug("Indexed row %s for frame based datasource", rowNumber);
                        }
                    }
                    ++rowNumber;
                    cursor.advance();
                }
                Integer n = rowNumber;
                return n;
            }
        });
        Integer totalRows = sequence.accumulate(0, (accumulated, in) -> {
            accumulated = accumulated + in;
            return accumulated;
        });
        this.keyColumnsIndexes = indexBuilders.stream().map(builder -> builder != null ? builder.build() : null).collect(Collectors.toList());
        LOG.info("Created FrameBasedIndexedTable with %s rows.", totalRows);
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public Set<String> keyColumns() {
        return this.keyColumns;
    }

    @Override
    public RowSignature rowSignature() {
        return this.rowSignature;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public IndexedTable.Index columnIndex(int column) {
        return RowBasedIndexedTable.getKeyColumnIndex(column, this.keyColumnsIndexes);
    }

    @Override
    public IndexedTable.Reader columnReader(int column) {
        if (!this.rowSignature.contains(column)) {
            throw new IAE("Column[%d] is not a valid column for the frame based datasource", column);
        }
        String columnName = this.rowSignature.getColumnName(column);
        final SimpleAscendingOffset offset = new SimpleAscendingOffset(this.numRows());
        final ArrayList columnValueSelectors = new ArrayList();
        final HashSet<BaseColumn> closeables = new HashSet<BaseColumn>();
        for (QueryableIndex frameQueryableIndex : this.frameQueryableIndexes) {
            ColumnHolder columnHolder = frameQueryableIndex.getColumnHolder(columnName);
            if (columnHolder == null) {
                columnValueSelectors.add(NilColumnValueSelector.instance());
                continue;
            }
            BaseColumn baseColumn = columnHolder.getColumn();
            columnValueSelectors.add(baseColumn.makeColumnValueSelector(offset));
            closeables.add(baseColumn);
        }
        return new IndexedTable.Reader(){

            @Override
            @Nullable
            public Object read(int row) {
                int frameIndex = FrameBasedIndexedTable.this.binSearch(FrameBasedIndexedTable.this.cumulativeRowCount, row);
                if (frameIndex == FrameBasedIndexedTable.this.frameQueryableIndexes.size()) {
                    throw new IndexOutOfBoundsException(StringUtils.format("Requested row index [%d], Max row count [%d]", row, FrameBasedIndexedTable.this.numRows()));
                }
                int adjustedOffset = frameIndex == 0 ? row : IntMath.checkedSubtract((int)row, (int)((Integer)FrameBasedIndexedTable.this.cumulativeRowCount.get(frameIndex - 1)));
                offset.setCurrentOffset(adjustedOffset);
                return ((BaseObjectColumnValueSelector)columnValueSelectors.get(frameIndex)).getObject();
            }

            @Override
            public void close() throws IOException {
                for (Closeable c : closeables) {
                    c.close();
                }
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return Optional.of(() -> {});
    }

    private List<FrameColumnReader> createColumnReaders(RowSignature rowSignature) {
        ArrayList<FrameColumnReader> columnReaders = new ArrayList<FrameColumnReader>(rowSignature.size());
        for (int columnNumber = 0; columnNumber < rowSignature.size(); ++columnNumber) {
            ColumnType columnType = (ColumnType)Preconditions.checkNotNull(rowSignature.getColumnType(columnNumber).orElse(null), (String)"Type for column [%s]", (Object)rowSignature.getColumnName(columnNumber));
            columnReaders.add(FrameColumnReaders.create(rowSignature.getColumnName(columnNumber), columnNumber, columnType));
        }
        return columnReaders;
    }

    private int binSearch(List<Integer> arr, int row) {
        int start = 0;
        int end = arr.size();
        while (start < end) {
            int middle = start + (end - start) / 2;
            if (arr.get(middle) > row) {
                end = middle;
                continue;
            }
            start = middle + 1;
        }
        return start;
    }
}

