/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.DictionaryRangeScanningBitmapIndex;
import org.apache.druid.segment.index.DictionaryScanningBitmapIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapDelegatingIterableIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.NumericRangeIndexes;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.index.semantic.ValueSetIndexes;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.ScalarDoubleColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class ScalarDoubleColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<ColumnarDoubles> valueColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final BitmapFactory bitmapFactory;
    private final ImmutableBitmap nullValueBitmap;
    private final ColumnConfig columnConfig;

    public static ScalarDoubleColumnAndIndexSupplier read(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, @Nullable ScalarDoubleColumnAndIndexSupplier parent) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version == 0) {
            try {
                Object doubleDictionarySupplier;
                SmooshedFileMapper mapper = columnBuilder.getFileMapper();
                ByteBuffer doublesValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleColumn");
                if (parent != null) {
                    doubleDictionarySupplier = parent.doubleDictionarySupplier;
                } else {
                    ByteBuffer doubleDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleDictionary");
                    doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), byteOrder, 8);
                }
                Supplier<ColumnarDoubles> doubles = CompressedColumnarDoublesSuppliers.fromByteBuffer(doublesValueColumn, byteOrder);
                ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__valueIndexes");
                GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
                return new ScalarDoubleColumnAndIndexSupplier((Supplier<FixedIndexed<Double>>)doubleDictionarySupplier, doubles, rBitmaps, bitmapSerdeFactory.getBitmapFactory(), columnConfig);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private ScalarDoubleColumnAndIndexSupplier(Supplier<FixedIndexed<Double>> longDictionary, Supplier<ColumnarDoubles> valueColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, BitmapFactory bitmapFactory, ColumnConfig columnConfig) {
        this.doubleDictionarySupplier = longDictionary;
        this.valueColumnSupplier = valueColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.bitmapFactory = bitmapFactory;
        this.nullValueBitmap = valueIndexes.get(0) == null ? bitmapFactory.makeEmptyImmutableBitmap() : (ImmutableBitmap)valueIndexes.get(0);
        this.columnConfig = columnConfig;
    }

    public NestedCommonFormatColumn get() {
        return new ScalarDoubleColumn((FixedIndexed)this.doubleDictionarySupplier.get(), (ColumnarDoubles)this.valueColumnSupplier.get(), this.nullValueBitmap);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = NullHandling.replaceWithDefault() ? new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap()) : new SimpleImmutableBitmapIndex(this.nullValueBitmap);
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(ValueIndexes.class)) {
            return (T)new DoubleValueIndexes();
        }
        if (clazz.equals(ValueSetIndexes.class)) {
            return (T)new DoubleValueSetIndexes();
        }
        if (clazz.equals(StringValueSetIndexes.class)) {
            return (T)new DoubleStringValueSetIndexes();
        }
        if (clazz.equals(NumericRangeIndexes.class)) {
            return (T)new DoubleNumericRangeIndex();
        }
        if (clazz.equals(DruidPredicateIndexes.class)) {
            return (T)new DoublePredicateIndexes();
        }
        if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
            return (T)new DoubleDictionaryEncodedValueSetIndex();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = (ImmutableBitmap)this.valueIndexes.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private class DoubleDictionaryEncodedValueSetIndex
    implements DictionaryEncodedStringValueIndex {
        private final FixedIndexed<Double> dictionary;

        private DoubleDictionaryEncodedValueSetIndex() {
            this.dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(idx);
        }

        @Override
        public int getCardinality() {
            return this.dictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            Double value = this.dictionary.get(index);
            return value == null ? null : String.valueOf(value);
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory;
        }
    }

    private class DoublePredicateIndexes
    implements DruidPredicateIndexes {
        private DoublePredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            FixedIndexed dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
            return new DictionaryScanningBitmapIndex(dictionary.size()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final DruidDoublePredicate doublePredicate;
                        int index;
                        boolean nextSet;
                        final Iterator iterator;
                        {
                            this.iterator = ((FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get()).iterator();
                            this.doublePredicate = matcherFactory.makeDoublePredicate();
                            this.index = -1;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(this.index);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Double nextValue = (Double)this.iterator.next();
                                ++this.index;
                                if (nextValue == null) {
                                    if (NullHandling.sqlCompatible()) {
                                        this.nextSet = this.doublePredicate.applyNull().matches(includeUnknown);
                                        continue;
                                    }
                                    this.nextSet = this.doublePredicate.applyDouble(NullHandling.defaultDoubleValue()).matches(includeUnknown);
                                    continue;
                                }
                                this.nextSet = this.doublePredicate.applyDouble(nextValue).matches(includeUnknown);
                            }
                        }
                    };
                }
            };
        }
    }

    private class DoubleNumericRangeIndex
    implements NumericRangeIndexes {
        private DoubleNumericRangeIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            FixedIndexed dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
            IntIntPair range = dictionary.getRange(startValue == null ? null : Double.valueOf(startValue.doubleValue()), startStrict, endValue == null ? null : Double.valueOf(endValue.doubleValue()), endStrict);
            final int startIndex = range.leftInt();
            final int endIndex = range.rightInt();
            return new DictionaryRangeScanningBitmapIndex(ScalarDoubleColumnAndIndexSupplier.this.columnConfig.skipValueRangeIndexScale(), endIndex - startIndex){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final IntIterator rangeIterator;
                        {
                            this.rangeIterator = IntListUtils.fromTo(startIndex, endIndex).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.rangeIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(this.rangeIterator.nextInt());
                        }
                    };
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    return ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap;
                }
            };
        }
    }

    private class DoubleStringValueSetIndexes
    implements StringValueSetIndexes {
        private DoubleStringValueSetIndexes() {
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Double doubleValue = Strings.isNullOrEmpty((String)value) ? null : Doubles.tryParse((String)value);
            final FixedIndexed dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
            final int defaultValueIndex = dictionary.indexOf(NullHandling.defaultDoubleValue());
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    if (doubleValue == null) {
                        if (inputNull && NullHandling.sqlCompatible()) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0));
                        }
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    if (NullHandling.replaceWithDefault() && doubleValue.equals(NullHandling.defaultDoubleValue())) {
                        if (defaultValueIndex >= 0) {
                            return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0), (Object)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(defaultValueIndex)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0));
                    }
                    int id = dictionary.indexOf(doubleValue);
                    if (includeUnknown) {
                        if (id < 0) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(id), (Object)ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap));
                    }
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(id));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return values.size();
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    DoubleArraySet doubles = new DoubleArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Double theValue = Doubles.tryParse((String)value);
                        if (theValue == null) continue;
                        doubles.add(theValue.doubleValue());
                        if (!NullHandling.replaceWithDefault() || !theValue.equals(NullHandling.defaultDoubleValue())) continue;
                        needNullCheck = true;
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((DoubleSet)doubles, doNullCheck);
                }

                @Override
                @Nullable
                @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!values.contains(null)) {
                        return ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap;
                    }
                    return null;
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final DoubleSet doubles, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final DoubleIterator iterator;
                        int next;
                        boolean nullChecked;
                        final FixedIndexed dictionary;
                        {
                            this.dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
                            this.iterator = doubles.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return ScalarDoubleColumnAndIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                double nextValue = this.iterator.nextDouble();
                                this.next = this.dictionary.indexOf(nextValue);
                            }
                        }
                    };
                }
            };
        }
    }

    private final class DoubleValueSetIndexes
    implements ValueSetIndexes {
        final FixedIndexed<Double> dictionary;

        private DoubleValueSetIndexes() {
            this.dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
        }

        @Override
        @Nullable
        public BitmapColumnIndex forSortedValues(@Nonnull List<?> sortedValues, TypeSignature<ValueType> matchValueType) {
            if (sortedValues.isEmpty()) {
                return new AllFalseBitmapColumnIndex(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory);
            }
            boolean matchNull = sortedValues.get(0) == null;
            Supplier unknownsIndex = () -> {
                if (!matchNull && this.dictionary.get(0) == null) {
                    return (ImmutableBitmap)ScalarDoubleColumnAndIndexSupplier.this.valueIndexes.get(0);
                }
                return null;
            };
            if (matchValueType.is(ValueType.DOUBLE)) {
                List<?> tailSet;
                List<?> baseSet = sortedValues;
                if (sortedValues.size() >= 8) {
                    double minValueInColumn = this.dictionary.get(0) == null ? this.dictionary.get(1).doubleValue() : this.dictionary.get(0).doubleValue();
                    int position = Collections.binarySearch(sortedValues, minValueInColumn, matchValueType.getNullableStrategy());
                    tailSet = baseSet.subList(position >= 0 ? position : -(position + 1), baseSet.size());
                } else {
                    tailSet = baseSet;
                }
                if ((double)tailSet.size() > 0.12 * (double)this.dictionary.size()) {
                    return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorScan(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory, ColumnType.DOUBLE.getNullableStrategy(), tailSet, tailSet.size(), this.dictionary, ScalarDoubleColumnAndIndexSupplier.this.valueIndexes, (Supplier<ImmutableBitmap>)unknownsIndex);
                }
                return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorBinarySearch(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory, tailSet, tailSet.size(), this.dictionary, ScalarDoubleColumnAndIndexSupplier.this.valueIndexes, (Supplier<ImmutableBitmap>)unknownsIndex);
            }
            return ValueSetIndexes.buildBitmapColumnIndexFromIteratorBinarySearch(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory, Iterables.transform(sortedValues, DimensionHandlerUtils::convertObjectToDouble), sortedValues.size(), this.dictionary, ScalarDoubleColumnAndIndexSupplier.this.valueIndexes, (Supplier<ImmutableBitmap>)unknownsIndex);
        }
    }

    private class DoubleValueIndexes
    implements ValueIndexes {
        private DoubleValueIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
            ExprEval eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value);
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.DOUBLE);
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory, ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap);
            }
            final double doubleValue = castForComparison.asDouble();
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Double> dictionary;
                {
                    this.dictionary = (FixedIndexed)ScalarDoubleColumnAndIndexSupplier.this.doubleDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int id = this.dictionary.indexOf(doubleValue);
                    if (includeUnknown) {
                        if (id < 0) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarDoubleColumnAndIndexSupplier.this.getBitmap(id), (Object)ScalarDoubleColumnAndIndexSupplier.this.nullValueBitmap));
                    }
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(ScalarDoubleColumnAndIndexSupplier.this.getBitmap(id));
                }
            };
        }
    }
}

