/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.segment.serde.Serializer;

public class ColumnSerializerUtils {
    public static final String STRING_DICTIONARY_FILE_NAME = "__stringDictionary";
    public static final String LONG_DICTIONARY_FILE_NAME = "__longDictionary";
    public static final String DOUBLE_DICTIONARY_FILE_NAME = "__doubleDictionary";
    public static final String ARRAY_DICTIONARY_FILE_NAME = "__arrayDictionary";
    public static final String ARRAY_ELEMENT_DICTIONARY_FILE_NAME = "__arrayElementDictionary";
    public static final String ENCODED_VALUE_COLUMN_FILE_NAME = "__encodedColumn";
    public static final String LONG_VALUE_COLUMN_FILE_NAME = "__longColumn";
    public static final String DOUBLE_VALUE_COLUMN_FILE_NAME = "__doubleColumn";
    public static final String BITMAP_INDEX_FILE_NAME = "__valueIndexes";
    public static final String ARRAY_ELEMENT_BITMAP_INDEX_FILE_NAME = "__arrayElementIndexes";
    public static final String NULL_BITMAP_FILE_NAME = "__nullIndex";
    public static final ObjectMapper SMILE_MAPPER;

    public static void writeInternal(FileSmoosher smoosher, Serializer serializer, String columnName, String fileName) throws IOException {
        String internalName = ColumnSerializerUtils.getInternalFileName(columnName, fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, serializer.getSerializedSize());){
            serializer.writeTo(smooshChannel, smoosher);
        }
    }

    public static void writeInternal(FileSmoosher smoosher, ByteBuffer buffer, String columnName, String fileName) throws IOException {
        String internalName = ColumnSerializerUtils.getInternalFileName(columnName, fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, buffer.capacity());){
            smooshChannel.write(buffer);
        }
    }

    public static String getInternalFileName(String fileNameBase, String field) {
        return fileNameBase + "." + field;
    }

    static {
        SmileFactory smileFactory = new SmileFactory();
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileFactory.delegateToTextual(true);
        DefaultObjectMapper mapper = new DefaultObjectMapper((JsonFactory)smileFactory, null);
        mapper.getFactory().setCodec((ObjectCodec)mapper);
        mapper.registerModules(BuiltInTypesModule.getJacksonModulesList());
        SMILE_MAPPER = mapper;
    }
}

