/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumn;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.utils.CloseableUtils;

public final class CompressedComplexColumn
implements ComplexColumn {
    private final String typeName;
    private final CompressedVariableSizedBlobColumn compressedColumn;
    private final ImmutableBitmap nullValues;
    private final ObjectStrategy<?> objectStrategy;

    public CompressedComplexColumn(String typeName, CompressedVariableSizedBlobColumn compressedColumn, ImmutableBitmap nullValues, ObjectStrategy<?> objectStrategy) {
        this.typeName = typeName;
        this.compressedColumn = compressedColumn;
        this.nullValues = nullValues;
        this.objectStrategy = objectStrategy;
    }

    @Override
    public Class<?> getClazz() {
        return this.objectStrategy.getClazz();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public Object getRowValue(int rowNum) {
        if (this.nullValues.get(rowNum)) {
            return null;
        }
        ByteBuffer valueBuffer = this.compressedColumn.get(rowNum);
        return this.objectStrategy.fromByteBuffer(valueBuffer, valueBuffer.remaining());
    }

    @Override
    public int getLength() {
        return this.compressedColumn.size();
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(this.compressedColumn);
    }
}

