/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdMapping;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.DictionaryRangeScanningBitmapIndex;
import org.apache.druid.segment.index.DictionaryScanningBitmapIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapDelegatingIterableIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;

public class ListFilteredVirtualColumn
implements VirtualColumn {
    private final String name;
    private final DimensionSpec delegate;
    private final Set<String> values;
    private final boolean allowList;

    @JsonCreator
    public ListFilteredVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="isAllowList") @Nullable Boolean isAllowList) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.delegate = delegate;
        this.values = values;
        this.allowList = isAllowList == null ? true : isAllowList;
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="isAllowList")
    public boolean isAllowList() {
        return this.allowList;
    }

    @JsonProperty
    public DimensionSpec getDelegate() {
        return this.delegate;
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(2).appendString(this.name).appendCacheable(this.delegate).appendStringsIgnoringOrder(this.values).appendBoolean(this.allowList);
        return builder.build();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        if (this.allowList) {
            return ListFilteredDimensionSpec.filterAllowList(this.values, factory.makeDimensionSelector(this.delegate), this.delegate.getExtractionFn() != null);
        }
        return ListFilteredDimensionSpec.filterDenyList(this.values, factory.makeDimensionSelector(this.delegate), this.delegate.getExtractionFn() != null);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName), factory);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.delegate.getOutputType()).setDictionaryEncoded(true).setHasBitmapIndexes(true);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return inspector.getColumnCapabilities(this.delegate.getDimension());
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.delegate.getDimension());
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, final ColumnIndexSelector indexSelector) {
        if (this.delegate.getExtractionFn() != null) {
            return NoIndexesColumnIndexSupplier.getInstance();
        }
        return new ColumnIndexSupplier(){

            @Override
            @Nullable
            public <T> T as(Class<T> clazz) {
                ColumnIndexSupplier indexSupplier = indexSelector.getIndexSupplier(ListFilteredVirtualColumn.this.delegate.getDimension());
                if (indexSupplier == null) {
                    return null;
                }
                DictionaryEncodedStringValueIndex underlyingIndex = indexSupplier.as(DictionaryEncodedStringValueIndex.class);
                if (underlyingIndex == null) {
                    return null;
                }
                IdMapping idMapping = ListFilteredVirtualColumn.this.allowList ? ListFilteredDimensionSpec.buildAllowListIdMapping(ListFilteredVirtualColumn.this.values, underlyingIndex.getCardinality(), null, underlyingIndex::getValue) : ListFilteredDimensionSpec.buildDenyListIdMapping(ListFilteredVirtualColumn.this.values, underlyingIndex.getCardinality(), underlyingIndex::getValue);
                ColumnHolder time = indexSelector.getColumnHolder("__time");
                int numRows = time.getLength();
                Supplier nullValueBitmapSupplier = Suppliers.memoize(() -> underlyingIndex.getBitmapFactory().complement(underlyingIndex.getBitmapFactory().union(ListFilteredVirtualColumn.getNonNullBitmaps(underlyingIndex, idMapping)), numRows));
                if (clazz.equals(NullValueIndex.class)) {
                    return (T)new ListFilteredNullValueIndex(nullValueBitmapSupplier);
                }
                if (clazz.equals(StringValueSetIndexes.class)) {
                    return (T)new ListFilteredStringValueSetIndexes(underlyingIndex, idMapping, nullValueBitmapSupplier);
                }
                if (clazz.equals(DruidPredicateIndexes.class)) {
                    return (T)new ListFilteredDruidPredicateIndexes(underlyingIndex, idMapping, nullValueBitmapSupplier);
                }
                if (clazz.equals(LexicographicalRangeIndexes.class)) {
                    return (T)new ListFilteredLexicographicalRangeIndexes(underlyingIndex, idMapping, nullValueBitmapSupplier);
                }
                if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                    return (T)new ListFilteredDictionaryEncodedStringValueIndex(underlyingIndex, idMapping);
                }
                return null;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFilteredVirtualColumn that = (ListFilteredVirtualColumn)o;
        return this.allowList == that.allowList && this.name.equals(that.name) && this.delegate.equals(that.delegate) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate, this.values, this.allowList);
    }

    public String toString() {
        return "ListFilteredVirtualColumn{name='" + this.name + '\'' + ", delegate=" + this.delegate + ", values=" + this.values + ", isAllowList=" + this.allowList + '}';
    }

    private static Iterable<ImmutableBitmap> getNonNullBitmaps(DictionaryEncodedStringValueIndex delegateIndex, IdMapping idMapping) {
        int start = NullHandling.isNullOrEquivalent((String)delegateIndex.getValue(idMapping.getReverseId(0))) ? 1 : 0;
        return ListFilteredVirtualColumn.getBitmapsInRange(delegateIndex, idMapping, DruidObjectPredicate.alwaysTrue(), start, idMapping.getValueCardinality(), false);
    }

    private static Iterable<ImmutableBitmap> getBitmapsInRange(final DictionaryEncodedStringValueIndex delegate, final IdMapping idMapping, final DruidObjectPredicate<String> matcher, final int start, final int end, final boolean includeUnknown) {
        return () -> new Iterator<ImmutableBitmap>(){
            int currIndex;
            int found;
            {
                this.currIndex = start;
                this.found = this.findNext();
            }

            private int findNext() {
                while (this.currIndex < end && !matcher.apply(delegate.getValue(idMapping.getReverseId(this.currIndex))).matches(includeUnknown)) {
                    ++this.currIndex;
                }
                if (this.currIndex < end) {
                    return this.currIndex++;
                }
                return -1;
            }

            @Override
            public boolean hasNext() {
                return this.found != -1;
            }

            @Override
            public ImmutableBitmap next() {
                int cur = this.found;
                if (cur == -1) {
                    throw new NoSuchElementException();
                }
                this.found = this.findNext();
                return delegate.getBitmap(idMapping.getReverseId(cur));
            }
        };
    }

    private static class ListFilteredDictionaryEncodedStringValueIndex
    extends BaseListFilteredColumnIndex
    implements DictionaryEncodedStringValueIndex {
        private ListFilteredDictionaryEncodedStringValueIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            super(delegate, idMapping);
        }

        @Override
        public int getCardinality() {
            return this.idMapping.getValueCardinality();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            return (String)this.delegate.getValue(this.idMapping.getReverseId(index));
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return this.delegate.getBitmapFactory();
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return this.delegate.getBitmap(this.idMapping.getReverseId(idx));
        }
    }

    private static class ListFilteredLexicographicalRangeIndexes
    extends BaseListFilteredColumnIndex
    implements LexicographicalRangeIndexes {
        private final Supplier<ImmutableBitmap> nullValueBitmapSupplier;

        private ListFilteredLexicographicalRangeIndexes(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping, Supplier<ImmutableBitmap> nullValueBitmapSupplier) {
            super(delegate, idMapping);
            this.nullValueBitmapSupplier = nullValueBitmapSupplier;
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            return this.forRange(startValue, startStrict, endValue, endStrict, DruidObjectPredicate.alwaysTrue());
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict, final DruidObjectPredicate<String> matcher) {
            IntIntPair range = this.getRange(startValue, startStrict, endValue, endStrict);
            final int start = range.leftInt();
            final int end = range.rightInt();
            return new DictionaryRangeScanningBitmapIndex(1.0, end - start){

                @Override
                protected Iterable<ImmutableBitmap> getBitmapIterable() {
                    return this.getBitmapsInRange(matcher, start, end, false);
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    return (ImmutableBitmap)nullValueBitmapSupplier.get();
                }
            };
        }

        private IntIntPair getRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            int found;
            int firstValue;
            int n = firstValue = NullHandling.isNullOrEquivalent((String)this.delegate.getValue(this.idMapping.getReverseId(0))) ? 1 : 0;
            int startIndex = startValue == null ? firstValue : ((found = this.getReverseIndex(NullHandling.emptyToNullIfNeeded(startValue))) >= 0 ? (startStrict ? found + 1 : found) : -(found + 1));
            int endIndex = endValue == null ? this.idMapping.getValueCardinality() : ((found = this.getReverseIndex(NullHandling.emptyToNullIfNeeded(endValue))) >= 0 ? (endStrict ? found : found + 1) : -(found + 1));
            endIndex = Math.max(startIndex, endIndex);
            return new IntIntImmutablePair(startIndex, endIndex);
        }
    }

    private static class ListFilteredDruidPredicateIndexes
    extends BaseListFilteredColumnIndex
    implements DruidPredicateIndexes {
        private final Supplier<ImmutableBitmap> nullValueBitmapSupplier;

        private ListFilteredDruidPredicateIndexes(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping, Supplier<ImmutableBitmap> nullValueBitmapSupplier) {
            super(delegate, idMapping);
            this.nullValueBitmapSupplier = nullValueBitmapSupplier;
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new DictionaryScanningBitmapIndex(this.getCardinality()){

                @Override
                protected Iterable<ImmutableBitmap> getBitmapIterable(boolean includeUnknown) {
                    return Iterables.concat(this.getBitmapsInRange(matcherFactory.makeStringPredicate(), 0, this.getCardinality(), includeUnknown), includeUnknown ? Collections.singletonList(nullValueBitmapSupplier.get()) : Collections.emptyList());
                }
            };
        }
    }

    private static class ListFilteredStringValueSetIndexes
    extends BaseListFilteredColumnIndex
    implements StringValueSetIndexes {
        private final Supplier<ImmutableBitmap> nullValueBitmapSupplier;

        private ListFilteredStringValueSetIndexes(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping, Supplier<ImmutableBitmap> nullValueBitmapSupplier) {
            super(delegate, idMapping);
            this.nullValueBitmapSupplier = nullValueBitmapSupplier;
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    if (includeUnknown) {
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)this.getBitmapForValue(), (Object)nullValueBitmapSupplier.get()));
                    }
                    return bitmapResultFactory.wrapDimensionValue(this.getBitmapForValue());
                }

                private ImmutableBitmap getBitmapForValue() {
                    int reverseIndex = this.getReverseIndex(value);
                    if (reverseIndex < 0) {
                        return delegate.getBitmap(-1);
                    }
                    return delegate.getBitmap(idMapping.getReverseId(reverseIndex));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return values.size();
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        final Iterator iterator;
                        {
                            this.iterator = values.iterator();
                            this.next = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.next = this.getReverseIndex(nextValue);
                            }
                        }
                    };
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    return (ImmutableBitmap)nullValueBitmapSupplier.get();
                }
            };
        }
    }

    private static class ListFilteredNullValueIndex
    implements NullValueIndex {
        private final Supplier<ImmutableBitmap> nullValueBitmapSupplier;

        private ListFilteredNullValueIndex(Supplier<ImmutableBitmap> nullValueBitmapSupplier) {
            this.nullValueBitmapSupplier = nullValueBitmapSupplier;
        }

        @Override
        public BitmapColumnIndex get() {
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 0;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknowns) {
                    return bitmapResultFactory.wrapDimensionValue((ImmutableBitmap)nullValueBitmapSupplier.get());
                }
            };
        }
    }

    private static class BaseListFilteredColumnIndex {
        final DictionaryEncodedStringValueIndex delegate;
        final IdMapping idMapping;

        private BaseListFilteredColumnIndex(DictionaryEncodedStringValueIndex delegate, IdMapping idMapping) {
            this.delegate = delegate;
            this.idMapping = idMapping;
        }

        ImmutableBitmap getBitmap(int idx) {
            return this.delegate.getBitmap(this.idMapping.getReverseId(idx));
        }

        int getCardinality() {
            return this.idMapping.getValueCardinality();
        }

        int getReverseIndex(@Nullable String value) {
            int minIndex = 0;
            int maxIndex = this.idMapping.getValueCardinality() - 1;
            StringComparator comparator = StringComparators.LEXICOGRAPHIC;
            while (minIndex <= maxIndex) {
                int currIndex = minIndex + maxIndex >>> 1;
                String currValue = (String)this.delegate.getValue(this.idMapping.getReverseId(currIndex));
                int comparison = comparator.compare(currValue, value);
                if (comparison == 0) {
                    return currIndex;
                }
                if (comparison < 0) {
                    minIndex = currIndex + 1;
                    continue;
                }
                maxIndex = currIndex - 1;
            }
            return -(minIndex + 1);
        }

        Iterable<ImmutableBitmap> getBitmapsInRange(DruidObjectPredicate<String> matcher, int start, int end, boolean includeUnknown) {
            return ListFilteredVirtualColumn.getBitmapsInRange(this.delegate, this.idMapping, matcher, start, end, includeUnknown);
        }
    }
}

