/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.ReflectUtils;

public interface FieldUtils {
    public static Field getDeclaredField(Class<?> declaredClass, String fieldName) {
        Field field = null;
        try {
            field = declaredClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
            field = null;
        }
        return field;
    }

    public static Field findField(Class<?> declaredClass, String fieldName) {
        Class<?> superType;
        Field field = FieldUtils.getDeclaredField(declaredClass, fieldName);
        if (field != null) {
            return field;
        }
        Iterator<Class<?>> iterator = ClassUtils.getAllInheritedTypes(declaredClass, new Predicate[0]).iterator();
        while (iterator.hasNext() && (field = FieldUtils.getDeclaredField(superType = iterator.next(), fieldName)) == null) {
        }
        if (field == null) {
            throw new IllegalStateException(String.format("cannot find field %s,field is null", fieldName));
        }
        return field;
    }

    public static Field findField(Object object, String fieldName) {
        return FieldUtils.findField(object.getClass(), fieldName);
    }

    public static Object getFieldValue(Object object, String fieldName) {
        return FieldUtils.getFieldValue(object, FieldUtils.findField(object, fieldName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFieldValue(Object object, Field field) {
        Object value = null;
        try {
            ReflectUtils.makeAccessible(field);
            value = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        finally {
            ReflectUtils.makeAccessible(field);
        }
        return (T)value;
    }

    public static <T> T setFieldValue(Object object, String fieldName, T value) {
        return FieldUtils.setFieldValue(object, FieldUtils.findField(object, fieldName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T setFieldValue(Object object, Field field, T value) {
        Object previousValue = null;
        try {
            ReflectUtils.makeAccessible(field);
            previousValue = field.get(object);
            field.set(object, value);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        finally {
            ReflectUtils.makeAccessible(field);
        }
        return (T)previousValue;
    }
}

