/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.AppendParametersComponent;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.event.ReferenceConfigDestroyedEvent;
import org.apache.dubbo.config.event.ReferenceConfigInitializedEvent;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ReferenceConfig<T>
extends ReferenceConfigBase<T> {
    public static final Logger logger = LoggerFactory.getLogger(ReferenceConfig.class);
    private static final Protocol REF_PROTOCOL = (Protocol)ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    private static final Cluster CLUSTER = (Cluster)ExtensionLoader.getExtensionLoader(Cluster.class).getAdaptiveExtension();
    private static final ProxyFactory PROXY_FACTORY = (ProxyFactory)ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private volatile transient T ref;
    private volatile transient Invoker<?> invoker;
    private volatile transient boolean initialized;
    private volatile transient boolean destroyed;
    private DubboBootstrap bootstrap;
    private final Object finalizerGuardian = new Object(){

        protected void finalize() throws Throwable {
            super.finalize();
            if (!ReferenceConfig.this.destroyed) {
                logger.warn("ReferenceConfig(" + ReferenceConfig.this.url + ") is not DESTROYED when FINALIZE");
            }
        }
    };

    public ReferenceConfig() {
    }

    public ReferenceConfig(Reference reference) {
        super(reference);
    }

    public synchronized T get() {
        if (this.destroyed) {
            throw new IllegalStateException("The invoker of ReferenceConfig(" + this.url + ") has already destroyed!");
        }
        if (this.ref == null) {
            this.init();
        }
        return this.ref;
    }

    public synchronized void destroy() {
        if (this.ref == null) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.invoker.destroy();
        }
        catch (Throwable t) {
            logger.warn("Unexpected error occured when destroy invoker of ReferenceConfig(" + this.url + ").", t);
        }
        this.invoker = null;
        this.ref = null;
        this.dispatch(new ReferenceConfigDestroyedEvent(this));
    }

    public synchronized void init() {
        String hostToRegistry;
        if (this.initialized) {
            return;
        }
        if (this.bootstrap == null) {
            this.bootstrap = DubboBootstrap.getInstance();
            this.bootstrap.init();
        }
        this.checkAndUpdateSubConfigs();
        this.serviceMetadata.setVersion(this.version);
        this.serviceMetadata.setGroup(this.group);
        this.serviceMetadata.setDefaultGroup(this.group);
        this.serviceMetadata.setServiceType(this.getActualInterface());
        this.serviceMetadata.setServiceInterfaceName(this.interfaceName);
        this.serviceMetadata.setServiceKey(URL.buildKey((String)this.interfaceName, (String)this.group, (String)this.version));
        this.checkStubAndLocal(this.interfaceClass);
        ConfigValidationUtils.checkMock(this.interfaceClass, (AbstractInterfaceConfig)this);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("side", "consumer");
        ReferenceConfigBase.appendRuntimeParameters(map);
        if (!ProtocolUtils.isGeneric((String)this.generic)) {
            Object methods;
            String revision = Version.getVersion((Class)this.interfaceClass, (String)this.version);
            if (revision != null && revision.length() > 0) {
                map.put("revision", revision);
            }
            if (((String[])(methods = Wrapper.getWrapper((Class)this.interfaceClass).getMethodNames())).length == 0) {
                logger.warn("No method found in service interface " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new HashSet<String>(Arrays.asList(methods)), (String)","));
            }
        }
        map.put("interface", this.interfaceName);
        AbstractConfig.appendParameters(map, (Object)this.getMetrics());
        AbstractConfig.appendParameters(map, (Object)this.getApplication());
        AbstractConfig.appendParameters(map, (Object)this.getModule());
        AbstractConfig.appendParameters(map, (Object)this.consumer);
        AbstractConfig.appendParameters(map, (Object)((Object)this));
        HashMap<String, ConsumerModel.AsyncMethodInfo> attributes = null;
        if (CollectionUtils.isNotEmpty((Collection)this.getMethods())) {
            attributes = new HashMap<String, ConsumerModel.AsyncMethodInfo>();
            for (MethodConfig methodConfig : this.getMethods()) {
                ConsumerModel.AsyncMethodInfo asyncMethodInfo;
                String retryValue;
                AbstractConfig.appendParameters(map, (Object)methodConfig, (String)methodConfig.getName());
                String retryKey = methodConfig.getName() + ".retry";
                if (map.containsKey(retryKey) && "false".equals(retryValue = (String)map.remove(retryKey))) {
                    map.put(methodConfig.getName() + ".retries", "0");
                }
                if ((asyncMethodInfo = AbstractConfig.convertMethodConfig2AsyncInfo((MethodConfig)methodConfig)) == null) continue;
                attributes.put(methodConfig.getName(), asyncMethodInfo);
            }
        }
        if (StringUtils.isEmpty((String)(hostToRegistry = ConfigUtils.getSystemProperty((String)"DUBBO_IP_TO_REGISTRY")))) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost((String)hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        this.serviceMetadata.getAttachments().putAll(map);
        ServiceRepository repository = ApplicationModel.getServiceRepository();
        ServiceDescriptor serviceDescriptor = repository.registerService(this.interfaceClass);
        repository.registerConsumer(this.serviceMetadata.getServiceKey(), attributes, serviceDescriptor, (ReferenceConfigBase)this, null, this.serviceMetadata);
        this.ref = this.createProxy(map);
        this.serviceMetadata.setTarget(this.ref);
        this.serviceMetadata.addAttribute("refClass", this.ref);
        repository.lookupReferredService(this.serviceMetadata.getServiceKey()).setProxyObject(this.ref);
        this.initialized = true;
        this.dispatch(new ReferenceConfigInitializedEvent(this, this.invoker));
    }

    private T createProxy(Map<String, String> map) {
        String metadata;
        WritableMetadataService metadataService;
        if (this.shouldJvmRefer(map)) {
            URL url = new URL("injvm", "127.0.0.1", 0, this.interfaceClass.getName()).addParameters(map);
            this.invoker = REF_PROTOCOL.refer(this.interfaceClass, url);
            if (logger.isInfoEnabled()) {
                logger.info("Using injvm service " + this.interfaceClass.getName());
            }
        } else {
            Iterator us;
            this.urls.clear();
            if (this.url != null && this.url.length() > 0) {
                us = CommonConstants.SEMICOLON_SPLIT_PATTERN.split(this.url);
                if (us != null && ((String[])us).length > 0) {
                    for (Object u : us) {
                        URL url = URL.valueOf((String)u);
                        if (StringUtils.isEmpty((String)url.getPath())) {
                            url = url.setPath(this.interfaceName);
                        }
                        if (UrlUtils.isRegistry((URL)url)) {
                            this.urls.add(url.addParameterAndEncoded("refer", StringUtils.toQueryString(map)));
                            continue;
                        }
                        this.urls.add(ClusterUtils.mergeUrl((URL)url, map));
                    }
                }
            } else if (!"injvm".equalsIgnoreCase(this.getProtocol())) {
                this.checkRegistry();
                us = ConfigValidationUtils.loadRegistries((AbstractInterfaceConfig)this, false);
                if (CollectionUtils.isNotEmpty((Collection)((Object)us))) {
                    Iterator iterator = us.iterator();
                    while (iterator.hasNext()) {
                        URL u = (URL)iterator.next();
                        URL monitorUrl = ConfigValidationUtils.loadMonitor((AbstractInterfaceConfig)this, u);
                        if (monitorUrl != null) {
                            map.put("monitor", URL.encode((String)monitorUrl.toFullString()));
                        }
                        this.urls.add(u.addParameterAndEncoded("refer", StringUtils.toQueryString(map)));
                    }
                }
                if (this.urls.isEmpty()) {
                    throw new IllegalStateException("No such any registry to reference " + this.interfaceName + " on the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please config <dubbo:registry address=\"...\" /> to your spring config.");
                }
            }
            if (this.urls.size() == 1) {
                this.invoker = REF_PROTOCOL.refer(this.interfaceClass, (URL)this.urls.get(0));
            } else {
                ArrayList<Invoker> invokers = new ArrayList<Invoker>();
                URL registryURL = null;
                for (URL url : this.urls) {
                    invokers.add(REF_PROTOCOL.refer(this.interfaceClass, url));
                    if (!UrlUtils.isRegistry((URL)url)) continue;
                    registryURL = url;
                }
                if (registryURL != null) {
                    URL u = registryURL.addParameterIfAbsent("cluster", "zone-aware");
                    this.invoker = CLUSTER.join((Directory)new StaticDirectory(u, invokers));
                } else {
                    this.invoker = CLUSTER.join((Directory)new StaticDirectory(invokers));
                }
            }
        }
        if (this.shouldCheck() && !this.invoker.isAvailable()) {
            throw new IllegalStateException("Failed to check the status of the service " + this.interfaceName + ". No provider available for the service " + (this.group == null ? "" : this.group + "/") + this.interfaceName + (this.version == null ? "" : ":" + this.version) + " from the url " + this.invoker.getUrl() + " to the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Refer dubbo service " + this.interfaceClass.getName() + " from url " + this.invoker.getUrl());
        }
        if ((metadataService = WritableMetadataService.getExtension((String)((metadata = map.get("metadata")) == null ? "local" : metadata))) != null) {
            URL consumerURL = new URL("consumer", map.remove("register.ip"), 0, map.get("interface"), map);
            metadataService.publishServiceDefinition(consumerURL);
        }
        return (T)PROXY_FACTORY.getProxy(this.invoker);
    }

    public void checkAndUpdateSubConfigs() {
        if (StringUtils.isEmpty((String)this.interfaceName)) {
            throw new IllegalStateException("<dubbo:reference interface=\"\" /> interface not allow null!");
        }
        this.completeCompoundConfigs();
        this.checkDefault();
        this.refresh();
        if (this.getGeneric() == null && this.getConsumer() != null) {
            this.setGeneric(this.getConsumer().getGeneric());
        }
        if (ProtocolUtils.isGeneric((String)this.generic)) {
            this.interfaceClass = GenericService.class;
        } else {
            try {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            this.checkInterfaceAndMethods(this.interfaceClass, this.getMethods());
        }
        this.resolveFile();
        ConfigValidationUtils.validateReferenceConfig(this);
        this.appendParameters();
    }

    protected boolean shouldJvmRefer(Map<String, String> map) {
        URL tmpUrl = new URL("temp", "localhost", 0, map);
        boolean isJvmRefer = this.isInjvm() == null ? (this.url != null && this.url.length() > 0 ? false : InjvmProtocol.getInjvmProtocol().isInjvmRefer(tmpUrl)) : this.isInjvm();
        return isJvmRefer;
    }

    protected void dispatch(Event event) {
        EventDispatcher.getDefaultExtension().dispatch(event);
    }

    public DubboBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(DubboBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void appendParameters() {
        URL appendParametersUrl = URL.valueOf((String)"appendParameters://");
        List appendParametersComponents = ExtensionLoader.getExtensionLoader(AppendParametersComponent.class).getActivateExtension(appendParametersUrl, (String[])null);
        appendParametersComponents.forEach(component -> component.appendReferParameters(this));
    }

    Invoker<?> getInvoker() {
        return this.invoker;
    }
}

