/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractReferenceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class InternalServiceConfigBuilder<T> {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private static final Set<String> UNACCEPTABLE_PROTOCOL = Stream.of("rest", "grpc").collect(Collectors.toSet());
    private final ApplicationModel applicationModel;
    private String protocol;
    private Integer port;
    private String registryId;
    private Class<T> interfaceClass;
    private Executor executor;
    private T ref;

    private InternalServiceConfigBuilder(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public static <T> InternalServiceConfigBuilder<T> newBuilder(ApplicationModel applicationModel) {
        return new InternalServiceConfigBuilder<T>(applicationModel);
    }

    public InternalServiceConfigBuilder<T> interfaceClass(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return this.getThis();
    }

    public InternalServiceConfigBuilder<T> executor(Executor executor) {
        this.executor = executor;
        return this.getThis();
    }

    public InternalServiceConfigBuilder<T> ref(T ref) {
        this.ref = ref;
        return this.getThis();
    }

    public InternalServiceConfigBuilder<T> registryId(String registryId) {
        this.registryId = registryId;
        return this.getThis();
    }

    public InternalServiceConfigBuilder<T> protocol(String protocol, String key) {
        Map params;
        if (StringUtils.isEmpty((String)protocol) && StringUtils.isNotBlank((CharSequence)key) && CollectionUtils.isNotEmptyMap((Map)(params = this.getApplicationConfig().getParameters()))) {
            protocol = (String)params.get(key);
        }
        this.protocol = StringUtils.isNotEmpty((String)protocol) ? protocol : this.getRelatedOrDefaultProtocol();
        return this.getThis();
    }

    private String getRelatedOrDefaultProtocol() {
        Map params;
        Collection protocols;
        String protocol = "";
        List moduleModels = this.applicationModel.getPubModuleModels();
        protocol = moduleModels.stream().map(ModuleModel::getConfigManager).map(ModuleConfigManager::getConsumers).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).map(AbstractReferenceConfig::getProtocol).filter(StringUtils::isNotEmpty).filter(p -> !UNACCEPTABLE_PROTOCOL.contains(p)).findFirst().orElse("");
        if (StringUtils.isEmpty((String)protocol)) {
            Stream providerConfigStream = moduleModels.stream().map(ModuleModel::getConfigManager).map(ModuleConfigManager::getProviders).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream);
            protocol = providerConfigStream.filter(providerConfig -> providerConfig.getProtocol() != null || CollectionUtils.isNotEmpty((Collection)providerConfig.getProtocols())).map(providerConfig -> {
                if (providerConfig.getProtocol() != null && StringUtils.isNotEmpty((String)providerConfig.getProtocol().getName())) {
                    return providerConfig.getProtocol().getName();
                }
                return providerConfig.getProtocols().stream().map(ProtocolConfig::getName).filter(StringUtils::isNotEmpty).findFirst().orElse("");
            }).filter(StringUtils::isNotEmpty).filter(p -> !UNACCEPTABLE_PROTOCOL.contains(p)).findFirst().orElse("");
        }
        if (StringUtils.isEmpty((String)protocol) && CollectionUtils.isNotEmpty((Collection)(protocols = this.applicationModel.getApplicationConfigManager().getProtocols()))) {
            protocol = protocols.stream().map(ProtocolConfig::getName).filter(StringUtils::isNotEmpty).filter(p -> !UNACCEPTABLE_PROTOCOL.contains(p)).findFirst().orElse("");
        }
        if (StringUtils.isEmpty((String)protocol) && StringUtils.isEmpty((String)(protocol = this.getApplicationConfig().getProtocol())) && CollectionUtils.isNotEmptyMap((Map)(params = this.getApplicationConfig().getParameters()))) {
            protocol = (String)params.get("application-protocol");
        }
        return StringUtils.isNotEmpty((String)protocol) && !UNACCEPTABLE_PROTOCOL.contains(protocol) ? protocol : "dubbo";
    }

    public InternalServiceConfigBuilder<T> protocol(String protocol) {
        this.protocol(protocol, null);
        return this.getThis();
    }

    public InternalServiceConfigBuilder<T> port(Integer specPort) {
        return this.port(specPort, null);
    }

    public InternalServiceConfigBuilder<T> port(Integer specPort, String key) {
        String rawPort;
        Assert.notEmptyString((String)this.protocol, (String)"export protocol is null");
        Assert.notNull(this.interfaceClass, (String)"export interfaceClass is null");
        if (specPort != null) {
            this.port = specPort;
            return this.getThis();
        }
        Map params = this.getApplicationConfig().getParameters();
        if (CollectionUtils.isNotEmptyMap((Map)params) && StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotEmpty((String)(rawPort = (String)this.getApplicationConfig().getParameters().get(key)))) {
            specPort = Integer.parseInt(rawPort);
        }
        if (specPort == null || specPort < -1) {
            try {
                Protocol protocol;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.interfaceClass.getName() + "Service Port hasn't been set will use default protocol defined in protocols.");
                }
                if ((protocol = (Protocol)this.applicationModel.getExtensionLoader(Protocol.class).getExtension(this.protocol)) != null && protocol.getServers() != null) {
                    Iterator it = protocol.getServers().iterator();
                    if (it.hasNext()) {
                        ProtocolServer server = (ProtocolServer)it.next();
                        String rawPort2 = server.getUrl().getParameter("bind.port");
                        if (rawPort2 == null) {
                            String addr = server.getAddress();
                            rawPort2 = addr.substring(addr.indexOf(":") + 1);
                        }
                        this.port = Integer.parseInt(rawPort2);
                    } else {
                        Integer protocolPort;
                        ProtocolConfig specifiedProtocolConfig = this.getProtocolConfig();
                        if (specifiedProtocolConfig != null && null != (protocolPort = specifiedProtocolConfig.getPort()) && protocolPort != -1) {
                            this.port = protocolPort;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("99-0", "invalid specified " + this.port + "  port, error " + e.getMessage(), "", "Failed to find any valid protocol, will use random port to export  service.", (Throwable)e);
            }
        }
        if (this.port == null) {
            this.port = -1;
        }
        return this.getThis();
    }

    private ProtocolConfig getProtocolConfig() {
        return this.applicationModel.getApplicationConfigManager().getProtocol(this.protocol).orElse(null);
    }

    public ServiceConfig<T> build(Consumer<ServiceConfig<T>> configConsumer) {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(this.protocol);
        protocolConfig.setPort(this.port);
        this.nullAssert();
        this.logger.info("Using " + this.protocol + " protocol to export " + this.interfaceClass.getName() + " service on port " + protocolConfig.getPort());
        this.applicationModel.getApplicationConfigManager().getProtocol(this.protocol).ifPresent(arg_0 -> ((ProtocolConfig)protocolConfig).mergeProtocol(arg_0));
        ApplicationConfig applicationConfig = this.getApplicationConfig();
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setScopeModel((ScopeModel)this.applicationModel.getInternalModule());
        serviceConfig.setApplication(applicationConfig);
        RegistryConfig registryConfig = new RegistryConfig("N/A");
        registryConfig.setId(this.registryId);
        registryConfig.setScopeModel((ScopeModel)this.applicationModel);
        serviceConfig.setRegistry(registryConfig);
        serviceConfig.setRegister(false);
        serviceConfig.setProtocol(protocolConfig);
        serviceConfig.setDelay(0);
        serviceConfig.setInterface(this.interfaceClass);
        serviceConfig.setRef(this.ref);
        serviceConfig.setGroup(applicationConfig.getName());
        serviceConfig.setVersion("1.0.0");
        serviceConfig.setFilter("-default");
        serviceConfig.setExecutor(this.executor);
        if (null != configConsumer) {
            configConsumer.accept(serviceConfig);
        }
        return serviceConfig;
    }

    public ServiceConfig<T> build() {
        return this.build(null);
    }

    private void nullAssert() {
        Assert.notNull((Object)this.port, (String)"export service port is null");
        Assert.notNull((Object)this.protocol, (String)"export service protocol is null");
        Assert.notNull(this.interfaceClass, (String)"export service interfaceClass is null");
        Assert.notNull(this.ref, (String)"export service ref is null");
        Assert.notNull((Object)this.registryId, (String)"export service registryId is null");
    }

    protected InternalServiceConfigBuilder<T> getThis() {
        return this;
    }

    private ApplicationConfig getApplicationConfig() {
        return this.applicationModel.getApplicationConfigManager().getApplicationOrElseThrow();
    }
}

