/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.exchange.support.MultiMessage;
import org.apache.dubbo.remoting.transport.netty4.NettyBackedChannelBuffer;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;

public final class NettyCodecAdapter {
    private final io.netty.channel.ChannelHandler encoder = new InternalEncoder();
    private final io.netty.channel.ChannelHandler decoder = new InternalDecoder();
    private final Codec2 codec;
    private final URL url;
    private final ChannelHandler handler;

    public NettyCodecAdapter(Codec2 codec, URL url, ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
    }

    public io.netty.channel.ChannelHandler getEncoder() {
        return this.encoder;
    }

    public io.netty.channel.ChannelHandler getDecoder() {
        return this.decoder;
    }

    private class InternalEncoder
    extends MessageToByteEncoder {
        private InternalEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
            boolean encoded = false;
            if (msg instanceof ByteBuf) {
                out.writeBytes((ByteBuf)msg);
                encoded = true;
            } else if (msg instanceof MultiMessage) {
                for (Object singleMessage : (MultiMessage)msg) {
                    if (!(singleMessage instanceof ByteBuf)) continue;
                    ByteBuf buf = (ByteBuf)singleMessage;
                    out.writeBytes(buf);
                    encoded = true;
                    buf.release();
                }
            }
            if (!encoded) {
                NettyBackedChannelBuffer buffer = new NettyBackedChannelBuffer(out);
                io.netty.channel.Channel ch = ctx.channel();
                NettyChannel channel = NettyChannel.getOrAddChannel(ch, NettyCodecAdapter.this.url, NettyCodecAdapter.this.handler);
                NettyCodecAdapter.this.codec.encode((Channel)channel, (ChannelBuffer)buffer, msg);
            }
        }
    }

    private class InternalDecoder
    extends ByteToMessageDecoder {
        private InternalDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
            NettyBackedChannelBuffer message = new NettyBackedChannelBuffer(input);
            NettyChannel channel = NettyChannel.getOrAddChannel(ctx.channel(), NettyCodecAdapter.this.url, NettyCodecAdapter.this.handler);
            do {
                int saveReaderIndex = message.readerIndex();
                Object msg = NettyCodecAdapter.this.codec.decode((Channel)channel, (ChannelBuffer)message);
                if (msg == Codec2.DecodeResult.NEED_MORE_INPUT) {
                    message.readerIndex(saveReaderIndex);
                    break;
                }
                if (saveReaderIndex == message.readerIndex()) {
                    throw new IOException("Decode without read data.");
                }
                if (msg == null) continue;
                out.add(msg);
            } while (message.readable());
        }
    }
}

