/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCUtils.class);

    public static void setRecordToStatement(PreparedStatement upload, int[] typesArray, Row row) throws SQLException {
        if (typesArray != null && typesArray.length > 0 && typesArray.length != row.getArity()) {
            LOG.warn("Column SQL types array doesn't match arity of passed Row! Check the passed array...");
        }
        if (typesArray == null) {
            for (int index = 0; index < row.getArity(); ++index) {
                LOG.warn("Unknown column type for column {}. Best effort approach to set its value: {}.", (Object)(index + 1), row.getField(index));
                upload.setObject(index + 1, row.getField(index));
            }
        } else {
            for (int i = 0; i < row.getArity(); ++i) {
                JDBCUtils.setField(upload, typesArray[i], row.getField(i), i);
            }
        }
    }

    public static void setField(PreparedStatement upload, int type, Object field, int index) throws SQLException {
        if (field == null) {
            upload.setNull(index + 1, type);
        } else {
            try {
                switch (type) {
                    case 0: {
                        upload.setNull(index + 1, type);
                        break;
                    }
                    case -7: 
                    case 16: {
                        upload.setBoolean(index + 1, (Boolean)field);
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -1: 
                    case 1: 
                    case 12: {
                        upload.setString(index + 1, (String)field);
                        break;
                    }
                    case -6: {
                        upload.setByte(index + 1, (Byte)field);
                        break;
                    }
                    case 5: {
                        upload.setShort(index + 1, (Short)field);
                        break;
                    }
                    case 4: {
                        upload.setInt(index + 1, (Integer)field);
                        break;
                    }
                    case -5: {
                        upload.setLong(index + 1, (Long)field);
                        break;
                    }
                    case 7: {
                        upload.setFloat(index + 1, ((Float)field).floatValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        upload.setDouble(index + 1, (Double)field);
                        break;
                    }
                    case 2: 
                    case 3: {
                        upload.setBigDecimal(index + 1, (BigDecimal)field);
                        break;
                    }
                    case 91: {
                        upload.setDate(index + 1, (Date)field);
                        break;
                    }
                    case 92: {
                        upload.setTime(index + 1, (Time)field);
                        break;
                    }
                    case 93: {
                        upload.setTimestamp(index + 1, (Timestamp)field);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        upload.setBytes(index + 1, (byte[])field);
                        break;
                    }
                    default: {
                        upload.setObject(index + 1, field);
                        LOG.warn("Unmanaged sql type ({}) for column {}. Best effort approach to set its value: {}.", new Object[]{type, index + 1, field});
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                String errorMessage = String.format("%s, field index: %s, field value: %s.", e.getMessage(), index, field);
                ClassCastException enrichedException = new ClassCastException(errorMessage);
                enrichedException.setStackTrace(e.getStackTrace());
                throw enrichedException;
            }
        }
    }

    public static Object getFieldFromResultSet(int index, int type, ResultSet set) throws SQLException {
        Object ret;
        switch (type) {
            case 0: {
                ret = null;
                break;
            }
            case -7: 
            case 16: {
                ret = set.getBoolean(index + 1);
                break;
            }
            case -16: 
            case -15: 
            case -1: 
            case 1: 
            case 12: {
                ret = set.getString(index + 1);
                break;
            }
            case -6: {
                ret = set.getByte(index + 1);
                break;
            }
            case 5: {
                ret = set.getShort(index + 1);
                break;
            }
            case 4: {
                ret = set.getInt(index + 1);
                break;
            }
            case -5: {
                ret = set.getLong(index + 1);
                break;
            }
            case 7: {
                ret = Float.valueOf(set.getFloat(index + 1));
                break;
            }
            case 6: 
            case 8: {
                ret = set.getDouble(index + 1);
                break;
            }
            case 2: 
            case 3: {
                ret = set.getBigDecimal(index + 1);
                break;
            }
            case 91: {
                ret = set.getDate(index + 1);
                break;
            }
            case 92: {
                ret = set.getTime(index + 1);
                break;
            }
            case 93: {
                ret = set.getTimestamp(index + 1);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                ret = set.getBytes(index + 1);
                break;
            }
            default: {
                ret = set.getObject(index + 1);
                LOG.warn("Unmanaged sql type ({}) for column {}. Best effort approach to get its value: {}.", new Object[]{type, index + 1, ret});
            }
        }
        if (set.wasNull()) {
            return null;
        }
        return ret;
    }
}

