/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.flink.formats.parquet.ParquetVectorizedInputFormat;
import org.apache.flink.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.formats.parquet.vector.ColumnBatchFactory;
import org.apache.flink.formats.parquet.vector.ParquetSplitReaderUtil;
import org.apache.flink.table.data.ColumnarRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.vector.writable.WritableColumnVector;
import org.apache.flink.table.filesystem.ColumnarRowIterator;
import org.apache.flink.table.filesystem.PartitionFieldExtractor;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class ParquetColumnarRowInputFormat<SplitT extends FileSourceSplit>
extends ParquetVectorizedInputFormat<RowData, SplitT> {
    private static final long serialVersionUID = 1L;
    private final RowType producedType;

    public ParquetColumnarRowInputFormat(Configuration hadoopConfig, RowType projectedType, int batchSize, boolean isUtcTimestamp, boolean isCaseSensitive) {
        this(hadoopConfig, projectedType, projectedType, ColumnBatchFactory.withoutExtraFields(), batchSize, isUtcTimestamp, isCaseSensitive);
    }

    public ParquetColumnarRowInputFormat(Configuration hadoopConfig, RowType projectedType, RowType producedType, ColumnBatchFactory<SplitT> batchFactory, int batchSize, boolean isUtcTimestamp, boolean isCaseSensitive) {
        super(new SerializableConfiguration(hadoopConfig), projectedType, batchFactory, batchSize, isUtcTimestamp, isCaseSensitive);
        this.producedType = producedType;
    }

    @Override
    protected ParquetVectorizedInputFormat.ParquetReaderBatch<RowData> createReaderBatch(WritableColumnVector[] writableVectors, VectorizedColumnBatch columnarBatch, Pool.Recycler<ParquetVectorizedInputFormat.ParquetReaderBatch<RowData>> recycler) {
        return new ColumnarRowReaderBatch(writableVectors, columnarBatch, recycler);
    }

    public TypeInformation<RowData> getProducedType() {
        return InternalTypeInfo.of((RowType)this.producedType);
    }

    public static <SplitT extends FileSourceSplit> ParquetColumnarRowInputFormat<SplitT> createPartitionedFormat(Configuration hadoopConfig, RowType producedRowType, List<String> partitionKeys, PartitionFieldExtractor<SplitT> extractor, int batchSize, boolean isUtcTimestamp, boolean isCaseSensitive) {
        RowType projectedRowType = new RowType(producedRowType.getFields().stream().filter(field -> !partitionKeys.contains(field.getName())).collect(Collectors.toList()));
        List projectedNames = projectedRowType.getFieldNames();
        ColumnBatchFactory<FileSourceSplit> factory = (split, parquetVectors) -> {
            ColumnVector[] vectors = new ColumnVector[producedRowType.getFieldCount()];
            for (int i = 0; i < vectors.length; ++i) {
                RowType.RowField field = (RowType.RowField)producedRowType.getFields().get(i);
                vectors[i] = partitionKeys.contains(field.getName()) ? ParquetSplitReaderUtil.createVectorFromConstant(field.getType(), extractor.extract(split, field.getName(), field.getType()), batchSize) : parquetVectors[projectedNames.indexOf(field.getName())];
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new ParquetColumnarRowInputFormat<FileSourceSplit>(hadoopConfig, projectedRowType, producedRowType, factory, batchSize, isUtcTimestamp, isCaseSensitive);
    }

    private static class ColumnarRowReaderBatch
    extends ParquetVectorizedInputFormat.ParquetReaderBatch<RowData> {
        private final ColumnarRowIterator result;

        private ColumnarRowReaderBatch(WritableColumnVector[] writableVectors, VectorizedColumnBatch columnarBatch, Pool.Recycler<ParquetVectorizedInputFormat.ParquetReaderBatch<RowData>> recycler) {
            super(writableVectors, columnarBatch, recycler);
            this.result = new ColumnarRowIterator(new ColumnarRowData(columnarBatch), this::recycle);
        }

        @Override
        public BulkFormat.RecordIterator<RowData> convertAndGetIterator(long rowsReturned) {
            this.result.set(this.columnarBatch.getNumRows(), rowsReturned);
            return this.result;
        }
    }
}

