/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.jsonplan.JsonPlanGenerator;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.utils.JarHandlerUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JarPlanHandler
extends AbstractRestHandler<RestfulGateway, JarPlanRequestBody, JobPlanInfo, JarPlanMessageParameters> {
    private final Path jarDir;
    private final Configuration configuration;
    private final Executor executor;
    private final Function<JobGraph, JobPlanInfo> planGenerator;

    public JarPlanHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<JarPlanRequestBody, JobPlanInfo, JarPlanMessageParameters> messageHeaders, Path jarDir, Configuration configuration, Executor executor) {
        this(leaderRetriever, timeout, responseHeaders, messageHeaders, jarDir, configuration, executor, jobGraph -> new JobPlanInfo(JsonPlanGenerator.generatePlan((JobGraph)jobGraph)));
    }

    public JarPlanHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<JarPlanRequestBody, JobPlanInfo, JarPlanMessageParameters> messageHeaders, Path jarDir, Configuration configuration, Executor executor, Function<JobGraph, JobPlanInfo> planGenerator) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.jarDir = Objects.requireNonNull(jarDir);
        this.configuration = Objects.requireNonNull(configuration);
        this.executor = Objects.requireNonNull(executor);
        this.planGenerator = planGenerator;
    }

    protected CompletableFuture<JobPlanInfo> handleRequest(@Nonnull HandlerRequest<JarPlanRequestBody, JarPlanMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JarHandlerUtils.JarHandlerContext context = JarHandlerUtils.JarHandlerContext.fromRequest(request, this.jarDir, this.log);
        return CompletableFuture.supplyAsync(() -> {
            try (PackagedProgram packagedProgram = context.toPackagedProgram(this.configuration);){
                JobGraph jobGraph = context.toJobGraph(packagedProgram, this.configuration, true);
                JobPlanInfo jobPlanInfo = this.planGenerator.apply(jobGraph);
                return jobPlanInfo;
            }
        }, this.executor);
    }
}

