/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers.utils;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerRequestUtils;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.EntryClassQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.JarIdPathParameter;
import org.apache.flink.runtime.webmonitor.handlers.JarRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.ParallelismQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.ProgramArgQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.ProgramArgsQueryParameter;
import org.apache.flink.shaded.guava18.com.google.common.base.Strings;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class JarHandlerUtils {
    private static final Pattern ARGUMENTS_TOKENIZE_PATTERN = Pattern.compile("([^\"']\\S*|\".+?\"|'.+?')\\s*");

    private static <R extends JarRequestBody, M extends MessageParameters> List<String> getProgramArgs(HandlerRequest<R, M> request, Logger log) throws RestHandlerException {
        JarRequestBody requestBody = (JarRequestBody)request.getRequestBody();
        List<String> programArgs = JarHandlerUtils.tokenizeArguments((String)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)Strings.emptyToNull((String)requestBody.getProgramArguments()), () -> (String)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, ProgramArgsQueryParameter.class), null, (Logger)log));
        List programArgsList = (List)HandlerRequestUtils.fromRequestBodyOrQueryParameter(requestBody.getProgramArgumentsList(), () -> request.getQueryParameter(ProgramArgQueryParameter.class), null, (Logger)log);
        if (!programArgsList.isEmpty()) {
            if (!programArgs.isEmpty()) {
                throw new RestHandlerException("Confusing request: programArgs and programArgsList are specified, please, use only programArgsList", HttpResponseStatus.BAD_REQUEST);
            }
            return programArgsList;
        }
        return programArgs;
    }

    @VisibleForTesting
    static List<String> tokenizeArguments(@Nullable String args) {
        if (args == null) {
            return Collections.emptyList();
        }
        Matcher matcher = ARGUMENTS_TOKENIZE_PATTERN.matcher(args);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group().trim().replace("\"", "").replace("'", ""));
        }
        return tokens;
    }

    public static class JarHandlerContext {
        private final Path jarFile;
        private final String entryClass;
        private final List<String> programArgs;
        private final int parallelism;
        private final JobID jobId;

        private JarHandlerContext(Path jarFile, String entryClass, List<String> programArgs, int parallelism, JobID jobId) {
            this.jarFile = jarFile;
            this.entryClass = entryClass;
            this.programArgs = programArgs;
            this.parallelism = parallelism;
            this.jobId = jobId;
        }

        public static <R extends JarRequestBody> JarHandlerContext fromRequest(@Nonnull HandlerRequest<R, ?> request, @Nonnull Path jarDir, @Nonnull Logger log) throws RestHandlerException {
            JarRequestBody requestBody = (JarRequestBody)request.getRequestBody();
            String pathParameter = (String)request.getPathParameter(JarIdPathParameter.class);
            Path jarFile = jarDir.resolve(pathParameter);
            String entryClass = (String)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)Strings.emptyToNull((String)requestBody.getEntryClassName()), () -> Strings.emptyToNull((String)((String)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, EntryClassQueryParameter.class))), null, (Logger)log);
            List programArgs = JarHandlerUtils.getProgramArgs(request, log);
            int parallelism = (Integer)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)requestBody.getParallelism(), () -> (Integer)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, ParallelismQueryParameter.class), (Object)CoreOptions.DEFAULT_PARALLELISM.defaultValue(), (Logger)log);
            JobID jobId = (JobID)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)requestBody.getJobId(), () -> null, null, (Logger)log);
            return new JarHandlerContext(jarFile, entryClass, programArgs, parallelism, jobId);
        }

        public void applyToConfiguration(Configuration configuration) {
            Preconditions.checkNotNull((Object)configuration);
            if (this.jobId != null) {
                configuration.set(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, (Object)this.jobId.toHexString());
            }
            configuration.set(CoreOptions.DEFAULT_PARALLELISM, (Object)this.parallelism);
            PackagedProgram program = this.toPackagedProgram(configuration);
            ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, (Collection)program.getJobJarAndDependencies(), URL::toString);
            ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, (Collection)program.getClasspaths(), URL::toString);
        }

        public JobGraph toJobGraph(PackagedProgram packagedProgram, Configuration configuration, boolean suppressOutput) {
            try {
                return PackagedProgramUtils.createJobGraph((PackagedProgram)packagedProgram, (Configuration)configuration, (int)this.parallelism, (JobID)this.jobId, (boolean)suppressOutput);
            }
            catch (ProgramInvocationException e) {
                throw new CompletionException(e);
            }
        }

        public PackagedProgram toPackagedProgram(Configuration configuration) {
            Preconditions.checkNotNull((Object)configuration);
            if (!Files.exists(this.jarFile, new LinkOption[0])) {
                throw new CompletionException((Throwable)new RestHandlerException(String.format("Jar file %s does not exist", this.jarFile), HttpResponseStatus.BAD_REQUEST));
            }
            try {
                return PackagedProgram.newBuilder().setJarFile(this.jarFile.toFile()).setEntryPointClassName(this.entryClass).setConfiguration(configuration).setArguments(this.programArgs.toArray(new String[0])).build();
            }
            catch (ProgramInvocationException e) {
                throw new CompletionException(e);
            }
        }
    }
}

