/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.shaded.guava18.com.google.common.base.Joiner;
import org.apache.flink.util.LambdaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StateUtil.class);

    private StateUtil() {
        throw new AssertionError();
    }

    public static long getStateSize(StateObject handle) {
        return handle == null ? 0L : handle.getStateSize();
    }

    public static void bestEffortDiscardAllStateObjects(Iterable<? extends StateObject> handlesToDiscard) throws Exception {
        LambdaUtil.applyToAllWhileSuppressingExceptions(handlesToDiscard, StateObject::discardState);
    }

    public static long discardStateFuture(Future<? extends StateObject> stateFuture) throws Exception {
        long stateSize = 0L;
        if (null != stateFuture) {
            if (!stateFuture.cancel(true)) {
                try {
                    StateObject stateObject;
                    if (stateFuture instanceof RunnableFuture && !stateFuture.isDone()) {
                        ((RunnableFuture)stateFuture).run();
                    }
                    if ((stateObject = stateFuture.get()) != null) {
                        stateSize = stateObject.getStateSize();
                        stateObject.discardState();
                    }
                }
                catch (Exception ex) {
                    LOG.debug("Cancelled execution of snapshot future runnable. Cancellation produced the following exception, which is expected an can be ignored.", (Throwable)ex);
                }
            } else if (stateFuture.isDone()) {
                try {
                    stateSize = stateFuture.get().getStateSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stateSize;
    }

    public static RuntimeException unexpectedStateHandleException(Class<? extends StateObject> expectedStateHandleClass, Class<? extends StateObject> actualStateHandleClass) {
        return StateUtil.unexpectedStateHandleException(new Class[]{expectedStateHandleClass}, actualStateHandleClass);
    }

    public static RuntimeException unexpectedStateHandleException(Class<? extends StateObject>[] expectedStateHandleClasses, Class<? extends StateObject> actualStateHandleClass) {
        return new IllegalStateException("Unexpected state handle type, expected one of: " + Joiner.on((String)", ").join((Object[])expectedStateHandleClasses) + ", but found: " + actualStateHandleClass + ". This can mostly happen when a different StateBackend from the one that was used for taking a checkpoint/savepoint is used when restoring.");
    }
}

