/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.contrib.streaming.state.ConfigurableRocksDBOptionsFactory;
import org.apache.flink.contrib.streaming.state.RocksDBConfigurableOptions;
import org.apache.flink.util.Preconditions;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.TableFormatConfig;

public class DefaultConfigurableOptionsFactory
implements ConfigurableRocksDBOptionsFactory {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> configuredOptions = new HashMap<String, String>();
    private static final ConfigOption<?>[] CANDIDATE_CONFIGS = new ConfigOption[]{RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS, RocksDBConfigurableOptions.MAX_OPEN_FILES, RocksDBConfigurableOptions.LOG_LEVEL, RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE, RocksDBConfigurableOptions.LOG_FILE_NUM, RocksDBConfigurableOptions.LOG_DIR, RocksDBConfigurableOptions.COMPACTION_STYLE, RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE, RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE, RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE, RocksDBConfigurableOptions.WRITE_BUFFER_SIZE, RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER, RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE, RocksDBConfigurableOptions.BLOCK_SIZE, RocksDBConfigurableOptions.METADATA_BLOCK_SIZE, RocksDBConfigurableOptions.BLOCK_CACHE_SIZE, RocksDBConfigurableOptions.USE_BLOOM_FILTER, RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY, RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE};
    private static final Set<ConfigOption<?>> POSITIVE_INT_CONFIG_SET = new HashSet<ConfigOption>(Arrays.asList(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS, RocksDBConfigurableOptions.LOG_FILE_NUM, RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER, RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE));
    private static final Set<ConfigOption<?>> SIZE_CONFIG_SET = new HashSet<ConfigOption>(Arrays.asList(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE, RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE, RocksDBConfigurableOptions.WRITE_BUFFER_SIZE, RocksDBConfigurableOptions.BLOCK_SIZE, RocksDBConfigurableOptions.METADATA_BLOCK_SIZE, RocksDBConfigurableOptions.BLOCK_CACHE_SIZE));

    @Override
    public DBOptions createDBOptions(DBOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
        if (this.isOptionConfigured(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS)) {
            currentOptions.setIncreaseParallelism(this.getMaxBackgroundThreads());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.MAX_OPEN_FILES)) {
            currentOptions.setMaxOpenFiles(this.getMaxOpenFiles());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.LOG_LEVEL)) {
            currentOptions.setInfoLogLevel(this.getLogLevel());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.LOG_DIR)) {
            currentOptions.setDbLogDir(this.getLogDir());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE)) {
            currentOptions.setMaxLogFileSize(this.getMaxLogFileSize());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.LOG_FILE_NUM)) {
            currentOptions.setKeepLogFileNum(this.getLogFileNum());
        }
        return currentOptions;
    }

    @Override
    public ColumnFamilyOptions createColumnOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
        boolean enabled;
        BlockBasedTableConfig blockBasedTableConfig;
        TableFormatConfig tableFormatConfig;
        if (this.isOptionConfigured(RocksDBConfigurableOptions.COMPACTION_STYLE)) {
            currentOptions.setCompactionStyle(this.getCompactionStyle());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE)) {
            currentOptions.setLevelCompactionDynamicLevelBytes(this.getUseDynamicLevelSize());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE)) {
            currentOptions.setTargetFileSizeBase(this.getTargetFileSizeBase());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE)) {
            currentOptions.setMaxBytesForLevelBase(this.getMaxSizeLevelBase());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE)) {
            currentOptions.setWriteBufferSize(this.getWriteBufferSize());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER)) {
            currentOptions.setMaxWriteBufferNumber(this.getMaxWriteBufferNumber());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE)) {
            currentOptions.setMinWriteBufferNumberToMerge(this.getMinWriteBufferNumberToMerge());
        }
        if ((tableFormatConfig = currentOptions.tableFormatConfig()) == null) {
            blockBasedTableConfig = new BlockBasedTableConfig();
        } else {
            if (tableFormatConfig instanceof PlainTableConfig) {
                return currentOptions;
            }
            blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.BLOCK_SIZE)) {
            blockBasedTableConfig.setBlockSize(this.getBlockSize());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.METADATA_BLOCK_SIZE)) {
            blockBasedTableConfig.setMetadataBlockSize(this.getMetadataBlockSize());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE)) {
            blockBasedTableConfig.setBlockCacheSize(this.getBlockCacheSize());
        }
        if (this.isOptionConfigured(RocksDBConfigurableOptions.USE_BLOOM_FILTER) && (enabled = Boolean.parseBoolean(this.getInternal(RocksDBConfigurableOptions.USE_BLOOM_FILTER.key())))) {
            double bitsPerKey = this.isOptionConfigured(RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY) ? Double.parseDouble(this.getInternal(RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY.key())) : (Double)RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY.defaultValue();
            boolean blockBasedMode = this.isOptionConfigured(RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE) ? Boolean.parseBoolean(this.getInternal(RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE.key())) : (Boolean)RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE.defaultValue();
            BloomFilter bloomFilter = new BloomFilter(bitsPerKey, blockBasedMode);
            handlesToClose.add((AutoCloseable)bloomFilter);
            blockBasedTableConfig.setFilterPolicy((Filter)bloomFilter);
        }
        return currentOptions.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
    }

    public Map<String, String> getConfiguredOptions() {
        return new HashMap<String, String>(this.configuredOptions);
    }

    private boolean isOptionConfigured(ConfigOption<?> configOption) {
        return this.configuredOptions.containsKey(configOption.key());
    }

    private int getMaxBackgroundThreads() {
        return Integer.parseInt(this.getInternal(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS.key()));
    }

    public DefaultConfigurableOptionsFactory setMaxBackgroundThreads(int totalThreadCount) {
        Preconditions.checkArgument((totalThreadCount > 0 ? 1 : 0) != 0);
        this.configuredOptions.put(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS.key(), String.valueOf(totalThreadCount));
        return this;
    }

    private int getMaxOpenFiles() {
        return Integer.parseInt(this.getInternal(RocksDBConfigurableOptions.MAX_OPEN_FILES.key()));
    }

    public DefaultConfigurableOptionsFactory setMaxOpenFiles(int maxOpenFiles) {
        this.configuredOptions.put(RocksDBConfigurableOptions.MAX_OPEN_FILES.key(), String.valueOf(maxOpenFiles));
        return this;
    }

    private InfoLogLevel getLogLevel() {
        return InfoLogLevel.valueOf((String)this.getInternal(RocksDBConfigurableOptions.LOG_LEVEL.key()).toUpperCase());
    }

    public DefaultConfigurableOptionsFactory setLogLevel(InfoLogLevel logLevel) {
        this.setInternal(RocksDBConfigurableOptions.LOG_LEVEL.key(), logLevel.name());
        return this;
    }

    private String getLogDir() {
        return this.getInternal(RocksDBConfigurableOptions.LOG_DIR.key());
    }

    public DefaultConfigurableOptionsFactory setLogDir(String logDir) {
        Preconditions.checkArgument((boolean)new File(logDir).isAbsolute(), (Object)("Invalid configuration: " + logDir + " does not point to an absolute path."));
        this.setInternal(RocksDBConfigurableOptions.LOG_DIR.key(), logDir);
        return this;
    }

    private long getMaxLogFileSize() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE.key()));
    }

    public DefaultConfigurableOptionsFactory setMaxLogFileSize(String maxLogFileSize) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)maxLogFileSize) >= 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + maxLogFileSize + " for max log file size."));
        this.setInternal(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE.key(), maxLogFileSize);
        return this;
    }

    private long getLogFileNum() {
        return Long.parseLong(this.getInternal(RocksDBConfigurableOptions.LOG_FILE_NUM.key()));
    }

    public DefaultConfigurableOptionsFactory setLogFileNum(int logFileNum) {
        Preconditions.checkArgument((logFileNum > 0 ? 1 : 0) != 0, (Object)"Invalid configuration: Must keep at least one log file.");
        this.configuredOptions.put(RocksDBConfigurableOptions.LOG_FILE_NUM.key(), String.valueOf(logFileNum));
        return this;
    }

    private CompactionStyle getCompactionStyle() {
        return CompactionStyle.valueOf((String)this.getInternal(RocksDBConfigurableOptions.COMPACTION_STYLE.key()).toUpperCase());
    }

    public DefaultConfigurableOptionsFactory setCompactionStyle(CompactionStyle compactionStyle) {
        this.setInternal(RocksDBConfigurableOptions.COMPACTION_STYLE.key(), compactionStyle.name());
        return this;
    }

    private boolean getUseDynamicLevelSize() {
        return this.getInternal(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE.key()).compareToIgnoreCase("false") != 0;
    }

    public DefaultConfigurableOptionsFactory setUseDynamicLevelSize(boolean value) {
        this.configuredOptions.put(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE.key(), value ? "true" : "false");
        return this;
    }

    private long getTargetFileSizeBase() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE.key()));
    }

    public DefaultConfigurableOptionsFactory setTargetFileSizeBase(String targetFileSizeBase) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)targetFileSizeBase) > 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + targetFileSizeBase + " for target file size base."));
        this.setInternal(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE.key(), targetFileSizeBase);
        return this;
    }

    private long getMaxSizeLevelBase() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE.key()));
    }

    public DefaultConfigurableOptionsFactory setMaxSizeLevelBase(String maxSizeLevelBase) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)maxSizeLevelBase) > 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + maxSizeLevelBase + " for max size of level base."));
        this.setInternal(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE.key(), maxSizeLevelBase);
        return this;
    }

    private long getWriteBufferSize() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE.key()));
    }

    public DefaultConfigurableOptionsFactory setWriteBufferSize(String writeBufferSize) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)writeBufferSize) > 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + writeBufferSize + " for write-buffer size."));
        this.setInternal(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE.key(), writeBufferSize);
        return this;
    }

    private int getMaxWriteBufferNumber() {
        return Integer.parseInt(this.getInternal(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER.key()));
    }

    public DefaultConfigurableOptionsFactory setMaxWriteBufferNumber(int writeBufferNumber) {
        Preconditions.checkArgument((writeBufferNumber > 0 ? 1 : 0) != 0, (Object)("Invalid configuration " + writeBufferNumber + " for max write-buffer number."));
        this.setInternal(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER.key(), Integer.toString(writeBufferNumber));
        return this;
    }

    private int getMinWriteBufferNumberToMerge() {
        return Integer.parseInt(this.getInternal(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE.key()));
    }

    public DefaultConfigurableOptionsFactory setMinWriteBufferNumberToMerge(int writeBufferNumber) {
        Preconditions.checkArgument((writeBufferNumber > 0 ? 1 : 0) != 0, (Object)("Invalid configuration " + writeBufferNumber + " for min write-buffer number to merge."));
        this.setInternal(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE.key(), Integer.toString(writeBufferNumber));
        return this;
    }

    private long getBlockSize() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.BLOCK_SIZE.key()));
    }

    public DefaultConfigurableOptionsFactory setBlockSize(String blockSize) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)blockSize) > 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + blockSize + " for block size."));
        this.setInternal(RocksDBConfigurableOptions.BLOCK_SIZE.key(), blockSize);
        return this;
    }

    private long getMetadataBlockSize() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.METADATA_BLOCK_SIZE.key()));
    }

    public DefaultConfigurableOptionsFactory setMetadataBlockSize(String metadataBlockSize) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)metadataBlockSize) > 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + metadataBlockSize + " for metadata block size."));
        this.setInternal(RocksDBConfigurableOptions.METADATA_BLOCK_SIZE.key(), metadataBlockSize);
        return this;
    }

    private long getBlockCacheSize() {
        return MemorySize.parseBytes((String)this.getInternal(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE.key()));
    }

    public DefaultConfigurableOptionsFactory setBlockCacheSize(String blockCacheSize) {
        Preconditions.checkArgument((MemorySize.parseBytes((String)blockCacheSize) > 0L ? 1 : 0) != 0, (Object)("Invalid configuration " + blockCacheSize + " for block cache size."));
        this.setInternal(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE.key(), blockCacheSize);
        return this;
    }

    private boolean getUseBloomFilter() {
        return Boolean.parseBoolean(this.getInternal(RocksDBConfigurableOptions.USE_BLOOM_FILTER.key()));
    }

    public DefaultConfigurableOptionsFactory setUseBloomFilter(boolean useBloomFilter) {
        this.setInternal(RocksDBConfigurableOptions.USE_BLOOM_FILTER.key(), String.valueOf(useBloomFilter));
        return this;
    }

    private double getBloomFilterBitsPerKey() {
        return Double.parseDouble(this.getInternal(RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY.key()));
    }

    public DefaultConfigurableOptionsFactory setBloomFilterBitsPerKey(double bitsPerKey) {
        this.setInternal(RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY.key(), String.valueOf(bitsPerKey));
        return this;
    }

    private boolean getBloomFilterBlockBasedMode() {
        return Boolean.parseBoolean(this.getInternal(RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE.key()));
    }

    public DefaultConfigurableOptionsFactory setBloomFilterBlockBasedMode(boolean blockBasedMode) {
        this.setInternal(RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE.key(), String.valueOf(blockBasedMode));
        return this;
    }

    @Override
    public DefaultConfigurableOptionsFactory configure(ReadableConfig configuration) {
        for (ConfigOption<?> option : CANDIDATE_CONFIGS) {
            Optional newValue = configuration.getOptional(option);
            if (!newValue.isPresent()) continue;
            DefaultConfigurableOptionsFactory.checkArgumentValid(option, newValue.get());
            this.configuredOptions.put(option.key(), newValue.get().toString());
        }
        return this;
    }

    public String toString() {
        return "DefaultConfigurableOptionsFactory{configuredOptions=" + this.configuredOptions + '}';
    }

    private static void checkArgumentValid(ConfigOption<?> option, Object value) {
        String key = option.key();
        if (POSITIVE_INT_CONFIG_SET.contains(option)) {
            Preconditions.checkArgument(((Integer)value > 0 ? 1 : 0) != 0, (Object)("Configured value for key: " + key + " must be larger than 0."));
        } else if (SIZE_CONFIG_SET.contains(option)) {
            Preconditions.checkArgument((((MemorySize)value).getBytes() > 0L ? 1 : 0) != 0, (Object)("Configured size for key" + key + " must be larger than 0."));
        } else if (RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE.equals(option)) {
            Preconditions.checkArgument((((MemorySize)value).getBytes() >= 0L ? 1 : 0) != 0, (Object)("Configured size for key " + key + " must be larger than or equal to 0."));
        } else if (RocksDBConfigurableOptions.LOG_DIR.equals(option)) {
            Preconditions.checkArgument((boolean)new File((String)value).isAbsolute(), (Object)("Configured path for key " + key + " is not absolute."));
        }
    }

    private void setInternal(String key, String value) {
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (Object)"The configuration value must not be empty.");
        this.configuredOptions.put(key, value);
    }

    private String getInternal(String key) {
        Preconditions.checkArgument((boolean)this.configuredOptions.containsKey(key), (Object)("The configuration " + key + " has not been configured."));
        return this.configuredOptions.get(key);
    }
}

