/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.RocksDBKeySerializationUtils;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public abstract class AbstractRocksDBState<K, N, V, S extends State>
implements InternalKvState<K, N, V>,
State {
    final TypeSerializer<N> namespaceSerializer;
    final TypeSerializer<V> valueSerializer;
    private N currentNamespace;
    protected RocksDBKeyedStateBackend<K> backend;
    protected ColumnFamilyHandle columnFamily;
    protected final V defaultValue;
    protected final WriteOptions writeOptions;
    protected final DataOutputSerializer dataOutputView;
    protected final DataInputDeserializer dataInputView;
    private final boolean ambiguousKeyPossible;

    protected AbstractRocksDBState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, RocksDBKeyedStateBackend<K> backend) {
        this.namespaceSerializer = namespaceSerializer;
        this.backend = backend;
        this.columnFamily = columnFamily;
        this.writeOptions = backend.getWriteOptions();
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer, (String)"State value serializer");
        this.defaultValue = defaultValue;
        this.dataOutputView = new DataOutputSerializer(128);
        this.dataInputView = new DataInputDeserializer();
        this.ambiguousKeyPossible = RocksDBKeySerializationUtils.isAmbiguousKeyPossible(backend.getKeySerializer(), namespaceSerializer);
    }

    public void clear() {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.dataOutputView.getCopyOfBuffer();
            this.backend.db.delete(this.columnFamily, this.writeOptions, key);
        }
        catch (IOException | RocksDBException e) {
            throw new FlinkRuntimeException("Error while removing entry from RocksDB", e);
        }
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace, (String)"Namespace");
    }

    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        Preconditions.checkNotNull((Object)serializedKeyAndNamespace);
        Preconditions.checkNotNull(safeKeySerializer);
        Preconditions.checkNotNull(safeNamespaceSerializer);
        Preconditions.checkNotNull(safeValueSerializer);
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup((Object)keyAndNamespace.f0, (int)this.backend.getNumberOfKeyGroups());
        DataOutputSerializer tmpKeySerializationView = new DataOutputSerializer(128);
        this.writeKeyWithGroupAndNamespace(keyGroup, keyAndNamespace.f0, safeKeySerializer, keyAndNamespace.f1, safeNamespaceSerializer, tmpKeySerializationView);
        return this.backend.db.get(this.columnFamily, tmpKeySerializationView.getCopyOfBuffer());
    }

    public void migrateSerializedValue(DataInputDeserializer serializedOldValueInput, DataOutputSerializer serializedMigratedValueOutput, TypeSerializer<V> priorSerializer, TypeSerializer<V> newSerializer) throws StateMigrationException {
        try {
            Object value = priorSerializer.deserialize((DataInputView)serializedOldValueInput);
            newSerializer.serialize(value, (DataOutputView)serializedMigratedValueOutput);
        }
        catch (Exception e) {
            throw new StateMigrationException("Error while trying to migration RocksDB state.", (Throwable)e);
        }
    }

    byte[] getKeyBytes() {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            return this.dataOutputView.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Error while serializing key", (Throwable)e);
        }
    }

    byte[] getValueBytes(V value) {
        try {
            this.dataOutputView.clear();
            this.valueSerializer.serialize(value, (DataOutputView)this.dataOutputView);
            return this.dataOutputView.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Error while serializing value", (Throwable)e);
        }
    }

    protected void writeCurrentKeyWithGroupAndNamespace() throws IOException {
        this.writeKeyWithGroupAndNamespace(this.backend.getCurrentKeyGroupIndex(), this.backend.getCurrentKey(), this.currentNamespace, this.dataOutputView);
    }

    protected void writeKeyWithGroupAndNamespace(int keyGroup, K key, N namespace, DataOutputSerializer keySerializationDataOutputView) throws IOException {
        this.writeKeyWithGroupAndNamespace(keyGroup, key, this.backend.getKeySerializer(), namespace, this.namespaceSerializer, keySerializationDataOutputView);
    }

    protected void writeKeyWithGroupAndNamespace(int keyGroup, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, DataOutputSerializer keySerializationDataOutputView) throws IOException {
        Preconditions.checkNotNull(key, (String)"No key set. This method should not be called outside of a keyed context.");
        Preconditions.checkNotNull(keySerializer);
        Preconditions.checkNotNull(namespaceSerializer);
        keySerializationDataOutputView.clear();
        RocksDBKeySerializationUtils.writeKeyGroup(keyGroup, this.backend.getKeyGroupPrefixBytes(), (DataOutputView)keySerializationDataOutputView);
        RocksDBKeySerializationUtils.writeKey(key, keySerializer, keySerializationDataOutputView, this.ambiguousKeyPossible);
        RocksDBKeySerializationUtils.writeNameSpace(namespace, namespaceSerializer, keySerializationDataOutputView, this.ambiguousKeyPossible);
    }

    protected V getDefaultValue() {
        if (this.defaultValue != null) {
            return (V)this.valueSerializer.copy(this.defaultValue);
        }
        return null;
    }
}

