/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.TableFormatConfig;

public enum PredefinedOptions {
    DEFAULT{

        @Override
        public DBOptions createDBOptions() {
            return new DBOptions().setUseFsync(false);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions() {
            return new ColumnFamilyOptions();
        }
    }
    ,
    SPINNING_DISK_OPTIMIZED{

        @Override
        public DBOptions createDBOptions() {
            return new DBOptions().setIncreaseParallelism(4).setUseFsync(false).setMaxOpenFiles(-1);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions() {
            return new ColumnFamilyOptions().setCompactionStyle(CompactionStyle.LEVEL).setLevelCompactionDynamicLevelBytes(true);
        }
    }
    ,
    SPINNING_DISK_OPTIMIZED_HIGH_MEM{

        @Override
        public DBOptions createDBOptions() {
            return new DBOptions().setIncreaseParallelism(4).setUseFsync(false).setMaxOpenFiles(-1);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions() {
            long blockCacheSize = 0x10000000L;
            long blockSize = 131072L;
            long targetFileSize = 0x10000000L;
            long writeBufferSize = 0x4000000L;
            return new ColumnFamilyOptions().setCompactionStyle(CompactionStyle.LEVEL).setLevelCompactionDynamicLevelBytes(true).setTargetFileSizeBase(0x10000000L).setMaxBytesForLevelBase(0x40000000L).setWriteBufferSize(0x4000000L).setMinWriteBufferNumberToMerge(3).setMaxWriteBufferNumber(4).setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setBlockCacheSize(0x10000000L).setBlockSize(131072L).setFilter((Filter)new BloomFilter()));
        }
    }
    ,
    FLASH_SSD_OPTIMIZED{

        @Override
        public DBOptions createDBOptions() {
            return new DBOptions().setIncreaseParallelism(4).setUseFsync(false).setMaxOpenFiles(-1);
        }

        @Override
        public ColumnFamilyOptions createColumnOptions() {
            return new ColumnFamilyOptions();
        }
    };


    public abstract DBOptions createDBOptions();

    public abstract ColumnFamilyOptions createColumnOptions();
}

