/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Closeable;
import javax.annotation.Nonnull;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksIteratorInterface;

public class RocksIteratorWrapper
implements RocksIteratorInterface,
Closeable {
    private RocksIterator iterator;

    public RocksIteratorWrapper(@Nonnull RocksIterator iterator) {
        this.iterator = iterator;
    }

    public boolean isValid() {
        return this.iterator.isValid();
    }

    public void seekToFirst() {
        this.iterator.seekToFirst();
        this.status();
    }

    public void seekToLast() {
        this.iterator.seekToFirst();
        this.status();
    }

    public void seek(byte[] target) {
        this.iterator.seek(target);
        this.status();
    }

    public void next() {
        this.iterator.next();
        this.status();
    }

    public void prev() {
        this.iterator.prev();
        this.status();
    }

    public void status() {
        try {
            this.iterator.status();
        }
        catch (RocksDBException ex) {
            throw new FlinkRuntimeException("Internal exception found in RocksDB", (Throwable)ex);
        }
    }

    public byte[] key() {
        return this.iterator.key();
    }

    public byte[] value() {
        return this.iterator.value();
    }

    @Override
    public void close() {
        this.iterator.close();
    }
}

