/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CheckpointConfigFromConfigurationTest {
    @Parameterized.Parameter
    public TestSpec spec;

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSpec> specs() {
        return Arrays.asList(TestSpec.testValue(CheckpointingMode.AT_LEAST_ONCE).whenSetFromFile("execution.checkpointing.mode", "AT_LEAST_ONCE").viaSetter(CheckpointConfig::setCheckpointingMode).getterVia(CheckpointConfig::getCheckpointingMode).nonDefaultValue(CheckpointingMode.AT_LEAST_ONCE), TestSpec.testValue(10000L).whenSetFromFile("execution.checkpointing.interval", "10 s").viaSetter(CheckpointConfig::setCheckpointInterval).getterVia(CheckpointConfig::getCheckpointInterval).nonDefaultValue(100L), TestSpec.testValue(12000L).whenSetFromFile("execution.checkpointing.timeout", "12 s").viaSetter(CheckpointConfig::setCheckpointTimeout).getterVia(CheckpointConfig::getCheckpointTimeout).nonDefaultValue(100L), TestSpec.testValue(12).whenSetFromFile("execution.checkpointing.max-concurrent-checkpoints", "12").viaSetter(CheckpointConfig::setMaxConcurrentCheckpoints).getterVia(CheckpointConfig::getMaxConcurrentCheckpoints).nonDefaultValue(100), TestSpec.testValue(1000L).whenSetFromFile("execution.checkpointing.min-pause", "1 s").viaSetter(CheckpointConfig::setMinPauseBetweenCheckpoints).getterVia(CheckpointConfig::getMinPauseBetweenCheckpoints).nonDefaultValue(100L), TestSpec.testValue(true).whenSetFromFile("execution.checkpointing.prefer-checkpoint-for-recovery", "true").viaSetter(CheckpointConfig::setPreferCheckpointForRecovery).getterVia(CheckpointConfig::isPreferCheckpointForRecovery).nonDefaultValue(true), TestSpec.testValue(CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION).whenSetFromFile("execution.checkpointing.externalized-checkpoint-retention", "RETAIN_ON_CANCELLATION").viaSetter(CheckpointConfig::enableExternalizedCheckpoints).getterVia(CheckpointConfig::getExternalizedCheckpointCleanup).nonDefaultValue(CheckpointConfig.ExternalizedCheckpointCleanup.DELETE_ON_CANCELLATION), TestSpec.testValue(12).whenSetFromFile("execution.checkpointing.tolerable-failed-checkpoints", "12").viaSetter(CheckpointConfig::setTolerableCheckpointFailureNumber).getterVia(CheckpointConfig::getTolerableCheckpointFailureNumber).nonDefaultValue(100), TestSpec.testValue(true).whenSetFromFile("execution.checkpointing.unaligned", "true").viaSetter(CheckpointConfig::enableUnalignedCheckpoints).getterVia(CheckpointConfig::isUnalignedCheckpointsEnabled).nonDefaultValue(true));
    }

    @Test
    public void testLoadingFromConfiguration() {
        CheckpointConfig configFromSetters = new CheckpointConfig();
        CheckpointConfig configFromFile = new CheckpointConfig();
        Configuration configuration = new Configuration();
        configuration.setString(this.spec.key, this.spec.value);
        configFromFile.configure((ReadableConfig)configuration);
        this.spec.setValue(configFromSetters);
        this.spec.assertEqual(configFromFile, configFromSetters);
    }

    @Test
    public void testNotOverridingIfNotSet() {
        CheckpointConfig config = new CheckpointConfig();
        this.spec.setNonDefaultValue(config);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration);
        this.spec.assertEqualNonDefault(config);
    }

    private static class TestSpec<T> {
        private String key;
        private String value;
        private final T objectValue;
        private T nonDefaultValue;
        private BiConsumer<CheckpointConfig, T> setter;
        private Function<CheckpointConfig, T> getter;

        private TestSpec(T value) {
            this.objectValue = value;
        }

        public static <T> TestSpec<T> testValue(T value) {
            return new TestSpec<T>(value);
        }

        public TestSpec<T> whenSetFromFile(String key, String value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public TestSpec<T> viaSetter(BiConsumer<CheckpointConfig, T> setter) {
            this.setter = setter;
            return this;
        }

        public TestSpec<T> getterVia(Function<CheckpointConfig, T> getter) {
            this.getter = getter;
            return this;
        }

        public TestSpec<T> nonDefaultValue(T nonDefaultValue) {
            this.nonDefaultValue = nonDefaultValue;
            return this;
        }

        public void setValue(CheckpointConfig config) {
            this.setter.accept(config, (CheckpointConfig)this.objectValue);
        }

        public void setNonDefaultValue(CheckpointConfig config) {
            this.setter.accept(config, (CheckpointConfig)this.nonDefaultValue);
        }

        public void assertEqual(CheckpointConfig configFromFile, CheckpointConfig configFromSetters) {
            Assert.assertThat(this.getter.apply(configFromFile), (Matcher)CoreMatchers.equalTo(this.getter.apply(configFromSetters)));
        }

        public void assertEqualNonDefault(CheckpointConfig configFromFile) {
            Assert.assertThat(this.getter.apply(configFromFile), (Matcher)CoreMatchers.equalTo(this.nonDefaultValue));
        }

        public String toString() {
            return "key='" + this.key + '\'';
        }
    }
}

