/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.RecordingChannelStateWriter;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.checkpointing.SingleCheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;
import org.apache.flink.streaming.runtime.tasks.TestSubtaskCheckpointCoordinator;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TestBarrierHandlerFactory {
    private final AbstractInvokable target;
    private BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> actionRegistration = (callable, delay) -> () -> {};
    private Clock clock = SystemClock.getInstance();

    private TestBarrierHandlerFactory(AbstractInvokable target) {
        this.target = target;
    }

    public static TestBarrierHandlerFactory forTarget(AbstractInvokable target) {
        return new TestBarrierHandlerFactory(target);
    }

    public TestBarrierHandlerFactory withActionRegistration(BiFunction<Callable<?>, Duration, CheckpointBarrierHandler.Cancellable> actionRegistration) {
        this.actionRegistration = actionRegistration;
        return this;
    }

    public TestBarrierHandlerFactory withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public SingleCheckpointBarrierHandler create(SingleInputGate inputGate) {
        return this.create(inputGate, (ChannelStateWriter)new RecordingChannelStateWriter());
    }

    public SingleCheckpointBarrierHandler create(SingleInputGate inputGate, ChannelStateWriter stateWriter) {
        String taskName = "test";
        return SingleCheckpointBarrierHandler.alternating((String)taskName, (AbstractInvokable)this.target, (SubtaskCheckpointCoordinator)new TestSubtaskCheckpointCoordinator(stateWriter), (Clock)this.clock, (int)inputGate.getNumberOfInputChannels(), this.actionRegistration, (CheckpointableInput[])new CheckpointableInput[]{inputGate});
    }
}

