/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import java.util.List;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.OutputTag;

public class CollectorOutput<T>
implements Output<StreamRecord<T>> {
    private final List<StreamElement> list;

    public CollectorOutput(List<StreamElement> list) {
        this.list = list;
    }

    public void emitWatermark(Watermark mark) {
        this.list.add((StreamElement)mark);
    }

    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.list.add((StreamElement)latencyMarker);
    }

    public void collect(StreamRecord<T> record) {
        try {
            ClassLoader cl = record.getClass().getClassLoader();
            Object copied = InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)record.getValue()), (ClassLoader)cl);
            this.list.add((StreamElement)record.copy(copied));
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Unable to deserialize record: " + record, ex);
        }
    }

    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        throw new UnsupportedOperationException("Side output not supported for CollectorOutput");
    }

    public void close() {
    }
}

