/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.datagen.table.DataGenVisitorBase;
import org.apache.flink.connector.datagen.table.DataGeneratorContainer;
import org.apache.flink.connector.datagen.table.types.DataGeneratorMapper;
import org.apache.flink.connector.datagen.table.types.DecimalDataRandomGenerator;
import org.apache.flink.connector.datagen.table.types.RowDataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.RandomGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

@Internal
public class RandomGeneratorVisitor
extends DataGenVisitorBase {
    public static final int RANDOM_STRING_LENGTH_DEFAULT = 100;
    public static final int RANDOM_BYTES_LENGTH_DEFAULT = 100;
    private static final int RANDOM_COLLECTION_LENGTH_DEFAULT = 3;
    private final ConfigOptions.OptionBuilder minKey;
    private final ConfigOptions.OptionBuilder maxKey;
    private final ConfigOptions.OptionBuilder maxPastKey;

    public RandomGeneratorVisitor(String name, ReadableConfig config) {
        super(name, config);
        this.minKey = ConfigOptions.key((String)("fields." + name + "." + "min"));
        this.maxKey = ConfigOptions.key((String)("fields." + name + "." + "max"));
        this.maxPastKey = ConfigOptions.key((String)("fields." + name + "." + "max-past"));
    }

    public DataGeneratorContainer visit(BooleanType booleanType) {
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.booleanGenerator(), new ConfigOption[0]);
    }

    public DataGeneratorContainer visit(CharType charType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)100);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomStringGenerator((Integer)this.config.get(lenOption)), new ConfigOption[]{lenOption});
    }

    public DataGeneratorContainer visit(VarCharType varCharType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)100);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomStringGenerator((Integer)this.config.get(lenOption)), new ConfigOption[]{lenOption});
    }

    public DataGeneratorContainer visit(BinaryType binaryType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)100);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomBytesGenerator((Integer)this.config.get(lenOption)), new ConfigOption[]{lenOption});
    }

    public DataGeneratorContainer visit(VarBinaryType varBinaryType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)100);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomBytesGenerator((Integer)this.config.get(lenOption)), new ConfigOption[]{lenOption});
    }

    public DataGeneratorContainer visit(TinyIntType tinyIntType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)-128);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)127);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.byteGenerator((byte)((Integer)this.config.get(min)).byteValue(), (byte)((Integer)this.config.get(max)).byteValue()), min, max);
    }

    public DataGeneratorContainer visit(SmallIntType smallIntType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)Short.MIN_VALUE);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)Short.MAX_VALUE);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.shortGenerator((short)((Integer)this.config.get(min)).shortValue(), (short)((Integer)this.config.get(max)).shortValue()), min, max);
    }

    public DataGeneratorContainer visit(IntType integerType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)Integer.MIN_VALUE);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)Integer.MAX_VALUE);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.intGenerator((int)((Integer)this.config.get(min)), (int)((Integer)this.config.get(max))), min, max);
    }

    public DataGeneratorContainer visit(BigIntType bigIntType) {
        ConfigOption min = this.minKey.longType().defaultValue((Object)Long.MIN_VALUE);
        ConfigOption max = this.maxKey.longType().defaultValue((Object)Long.MAX_VALUE);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.longGenerator((long)((Long)this.config.get(min)), (long)((Long)this.config.get(max))), min, max);
    }

    public DataGeneratorContainer visit(FloatType floatType) {
        ConfigOption min = this.minKey.floatType().defaultValue((Object)Float.valueOf(Float.MIN_VALUE));
        ConfigOption max = this.maxKey.floatType().defaultValue((Object)Float.valueOf(Float.MAX_VALUE));
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.floatGenerator((float)((Float)this.config.get(min)).floatValue(), (float)((Float)this.config.get(max)).floatValue()), min, max);
    }

    public DataGeneratorContainer visit(DoubleType doubleType) {
        ConfigOption min = this.minKey.doubleType().defaultValue((Object)Double.MIN_VALUE);
        ConfigOption max = this.maxKey.doubleType().defaultValue((Object)Double.MAX_VALUE);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.doubleGenerator((double)((Double)this.config.get(min)), (double)((Double)this.config.get(max))), min, max);
    }

    public DataGeneratorContainer visit(DecimalType decimalType) {
        ConfigOption min = this.minKey.doubleType().defaultValue((Object)Double.MIN_VALUE);
        ConfigOption max = this.maxKey.doubleType().defaultValue((Object)Double.MAX_VALUE);
        return DataGeneratorContainer.of(new DecimalDataRandomGenerator(decimalType.getPrecision(), decimalType.getScale(), (Double)this.config.get(min), (Double)this.config.get(max)), min, max);
    }

    public DataGeneratorContainer visit(YearMonthIntervalType yearMonthIntervalType) {
        ConfigOption min = this.minKey.intType().defaultValue((Object)0);
        ConfigOption max = this.maxKey.intType().defaultValue((Object)120000);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.intGenerator((int)((Integer)this.config.get(min)), (int)((Integer)this.config.get(max))), min, max);
    }

    public DataGeneratorContainer visit(DayTimeIntervalType dayTimeIntervalType) {
        ConfigOption min = this.minKey.longType().defaultValue((Object)Long.MIN_VALUE);
        ConfigOption max = this.maxKey.longType().defaultValue((Object)Long.MAX_VALUE);
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.longGenerator((long)((Long)this.config.get(min)), (long)((Long)this.config.get(max))), min, max);
    }

    public DataGeneratorContainer visit(TimestampType timestampType) {
        ConfigOption maxPastOption = this.maxPastKey.durationType().defaultValue((Object)Duration.ZERO);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomPastTimestampGenerator((Duration)this.config.get(maxPastOption)), new ConfigOption[]{maxPastOption});
    }

    public DataGeneratorContainer visit(ZonedTimestampType zonedTimestampType) {
        ConfigOption maxPastOption = this.maxPastKey.durationType().defaultValue((Object)Duration.ZERO);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomPastTimestampGenerator((Duration)this.config.get(maxPastOption)), new ConfigOption[]{maxPastOption});
    }

    public DataGeneratorContainer visit(LocalZonedTimestampType localZonedTimestampType) {
        ConfigOption maxPastOption = this.maxPastKey.durationType().defaultValue((Object)Duration.ZERO);
        return DataGeneratorContainer.of(RandomGeneratorVisitor.getRandomPastTimestampGenerator((Duration)this.config.get(maxPastOption)), new ConfigOption[]{maxPastOption});
    }

    public DataGeneratorContainer visit(ArrayType arrayType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)3);
        String fieldName = this.name + ".element";
        DataGeneratorContainer container = (DataGeneratorContainer)arrayType.getElementType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(fieldName, this.config));
        RandomGenerator generator = RandomGenerator.arrayGenerator((DataGenerator)container.getGenerator(), (int)((Integer)this.config.get(lenOption)));
        return DataGeneratorContainer.of(new DataGeneratorMapper(generator, GenericArrayData::new), container.getOptions().toArray(new ConfigOption[0]));
    }

    public DataGeneratorContainer visit(MultisetType multisetType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)3);
        String fieldName = this.name + ".element";
        DataGeneratorContainer container = (DataGeneratorContainer)multisetType.getElementType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(fieldName, this.config));
        RandomGenerator mapGenerator = RandomGenerator.mapGenerator((DataGenerator)container.getGenerator(), (DataGenerator)RandomGenerator.intGenerator((int)0, (int)10), (int)((Integer)this.config.get(lenOption)));
        return DataGeneratorContainer.of(new DataGeneratorMapper(mapGenerator, GenericMapData::new), container.getOptions().toArray(new ConfigOption[0]));
    }

    public DataGeneratorContainer visit(MapType mapType) {
        ConfigOption lenOption = ConfigOptions.key((String)("fields." + this.name + "." + "length")).intType().defaultValue((Object)3);
        String keyName = this.name + ".key";
        String valName = this.name + ".value";
        DataGeneratorContainer keyContainer = (DataGeneratorContainer)mapType.getKeyType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(keyName, this.config));
        DataGeneratorContainer valContainer = (DataGeneratorContainer)mapType.getValueType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(valName, this.config));
        Set<ConfigOption<?>> options = keyContainer.getOptions();
        options.addAll(valContainer.getOptions());
        RandomGenerator mapGenerator = RandomGenerator.mapGenerator((DataGenerator)keyContainer.getGenerator(), (DataGenerator)valContainer.getGenerator(), (int)((Integer)this.config.get(lenOption)));
        return DataGeneratorContainer.of(new DataGeneratorMapper(mapGenerator, GenericMapData::new), options.toArray(new ConfigOption[0]));
    }

    public DataGeneratorContainer visit(RowType rowType) {
        List fieldContainers = rowType.getFields().stream().map(field -> {
            String fieldName = this.name + "." + field.getName();
            return (DataGeneratorContainer)field.getType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(fieldName, this.config));
        }).collect(Collectors.toList());
        ConfigOption[] options = (ConfigOption[])fieldContainers.stream().flatMap(container -> container.getOptions().stream()).toArray(ConfigOption[]::new);
        DataGenerator[] generators = (DataGenerator[])fieldContainers.stream().map(DataGeneratorContainer::getGenerator).toArray(DataGenerator[]::new);
        return DataGeneratorContainer.of(new RowDataGenerator(generators, rowType.getFieldNames()), options);
    }

    @Override
    protected DataGeneratorContainer defaultMethod(LogicalType logicalType) {
        throw new ValidationException("Unsupported type: " + logicalType);
    }

    private static RandomGenerator<StringData> getRandomStringGenerator(final int length) {
        return new RandomGenerator<StringData>(){

            public StringData next() {
                return StringData.fromString((String)this.random.nextHexString(length));
            }
        };
    }

    private static RandomGenerator<TimestampData> getRandomPastTimestampGenerator(final Duration maxPast) {
        return new RandomGenerator<TimestampData>(){

            public TimestampData next() {
                long maxPastMillis = maxPast.toMillis();
                long past = maxPastMillis > 0L ? this.random.nextLong(0L, maxPastMillis) : 0L;
                return TimestampData.fromEpochMillis((long)(System.currentTimeMillis() - past));
            }
        };
    }

    private static RandomGenerator<byte[]> getRandomBytesGenerator(final int length) {
        return new RandomGenerator<byte[]>(){

            public byte[] next() {
                byte[] arr = new byte[length];
                this.random.getRandomGenerator().nextBytes(arr);
                return arr;
            }
        };
    }
}

