/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public class LocalReferenceExpression
implements ResolvedExpression {
    private final String name;
    private final DataType dataType;

    public LocalReferenceExpression(String name, DataType dataType) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.dataType = (DataType)Preconditions.checkNotNull((Object)dataType);
    }

    public String getName() {
        return this.name;
    }

    public DataType getOutputDataType() {
        return this.dataType;
    }

    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    public String asSummaryString() {
        return this.name;
    }

    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    public <R> R accept(ExpressionVisitor<R> visitor) {
        return (R)visitor.visit((Expression)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalReferenceExpression that = (LocalReferenceExpression)o;
        return this.name.equals(that.name) && this.dataType.equals((Object)that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

