/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class RowType
extends LogicalType {
    public static final String FORMAT = "ROW<%s>";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = RowType.conversionSet(Row.class.getName(), RowData.class.getName());
    private static final Class<?> DEFAULT_CONVERSION = Row.class;
    private final List<RowField> fields;

    public RowType(boolean isNullable, List<RowField> fields) {
        super(isNullable, LogicalTypeRoot.ROW);
        this.fields = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(fields, (String)"Fields must not be null.")));
        RowType.validateFields(fields);
    }

    public RowType(List<RowField> fields) {
        this(true, fields);
    }

    public List<RowField> getFields() {
        return this.fields;
    }

    public List<String> getFieldNames() {
        return this.fields.stream().map(RowField::getName).collect(Collectors.toList());
    }

    public LogicalType getTypeAt(int i) {
        return this.fields.get(i).getType();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new RowType(isNullable, this.fields.stream().map(RowField::copy).collect(Collectors.toList()));
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.fields.stream().map(RowField::asSummaryString).collect(Collectors.joining(", ")));
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.fields.stream().map(RowField::asSerializableString).collect(Collectors.joining(", ")));
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.unmodifiableList(this.fields.stream().map(RowField::getType).collect(Collectors.toList()));
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType rowType = (RowType)o;
        return this.fields.equals(rowType.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }

    private static void validateFields(List<RowField> fields) {
        List fieldNames = fields.stream().map(f -> ((RowField)f).name).collect(Collectors.toList());
        if (fieldNames.stream().anyMatch(StringUtils::isNullOrWhitespaceOnly)) {
            throw new ValidationException("Field names must contain at least one non-whitespace character.");
        }
        Set duplicates = fieldNames.stream().filter(n -> Collections.frequency(fieldNames, n) > 1).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new ValidationException(String.format("Field names must be unique. Found duplicates: %s", duplicates));
        }
    }

    public static RowType of(LogicalType ... types) {
        ArrayList<RowField> fields = new ArrayList<RowField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new RowField("f" + i, types[i]));
        }
        return new RowType(fields);
    }

    public static RowType of(LogicalType[] types, String[] names) {
        ArrayList<RowField> fields = new ArrayList<RowField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new RowField(names[i], types[i]));
        }
        return new RowType(fields);
    }

    public static final class RowField
    implements Serializable {
        public static final String FIELD_FORMAT_WITH_DESCRIPTION = "%s %s '%s'";
        public static final String FIELD_FORMAT_NO_DESCRIPTION = "%s %s";
        private final String name;
        private final LogicalType type;
        @Nullable
        private final String description;

        public RowField(String name, LogicalType type, @Nullable String description) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Field name must not be null.");
            this.type = (LogicalType)Preconditions.checkNotNull((Object)type, (String)"Field type must not be null.");
            this.description = description;
        }

        public RowField(String name, LogicalType type) {
            this(name, type, null);
        }

        public String getName() {
            return this.name;
        }

        public LogicalType getType() {
            return this.type;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public RowField copy() {
            return new RowField(this.name, this.type.copy(), this.description);
        }

        public String asSummaryString() {
            return this.formatString(this.type.asSummaryString(), true);
        }

        public String asSerializableString() {
            return this.formatString(this.type.asSerializableString(), false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowField rowField = (RowField)o;
            return this.name.equals(rowField.name) && this.type.equals(rowField.type) && Objects.equals(this.description, rowField.description);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.description);
        }

        private String formatString(String typeString, boolean excludeDescription) {
            if (this.description == null) {
                return String.format(FIELD_FORMAT_NO_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString);
            }
            if (excludeDescription) {
                return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, "...");
            }
            return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, EncodingUtils.escapeSingleQuotes(this.description));
        }
    }
}

