/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.data.RowData;

public class TestManagedCommittable {
    private final Map<CatalogPartitionSpec, List<RowData>> toAdd;
    private final Map<CatalogPartitionSpec, Set<Path>> toDelete;

    public TestManagedCommittable(Map<CatalogPartitionSpec, List<RowData>> toAdd, Map<CatalogPartitionSpec, Set<Path>> toDelete) {
        this.toAdd = toAdd;
        this.toDelete = toDelete;
    }

    public Map<CatalogPartitionSpec, List<RowData>> getToAdd() {
        return this.toAdd;
    }

    public Map<CatalogPartitionSpec, Set<Path>> getToDelete() {
        return this.toDelete;
    }

    public static TestManagedCommittable combine(List<TestManagedCommittable> committables) {
        HashMap<CatalogPartitionSpec, List<RowData>> toAdd = new HashMap<CatalogPartitionSpec, List<RowData>>();
        HashMap<CatalogPartitionSpec, Set<Path>> toDelete = new HashMap<CatalogPartitionSpec, Set<Path>>();
        for (TestManagedCommittable committable : committables) {
            CatalogPartitionSpec partitionSpec;
            Map<CatalogPartitionSpec, List<RowData>> partialAdd = committable.toAdd;
            Map<CatalogPartitionSpec, Set<Path>> partialDelete = committable.toDelete;
            for (Map.Entry<CatalogPartitionSpec, List<RowData>> entry : partialAdd.entrySet()) {
                partitionSpec = entry.getKey();
                List elements = toAdd.getOrDefault(partitionSpec, new ArrayList());
                elements.addAll((Collection)entry.getValue());
                toAdd.put(partitionSpec, elements);
            }
            for (Map.Entry<CatalogPartitionSpec, Collection<Object>> entry : partialDelete.entrySet()) {
                partitionSpec = entry.getKey();
                Set paths = toDelete.getOrDefault(partitionSpec, new HashSet());
                paths.addAll(entry.getValue());
                toDelete.put(partitionSpec, paths);
            }
        }
        return new TestManagedCommittable(toAdd, toDelete);
    }
}

