/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.utils.ValueDataTypeConverter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ValueDataTypeConverterTest {
    ValueDataTypeConverterTest() {
    }

    private static Stream<Arguments> testData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Hello World", DataTypes.CHAR((int)11)}), Arguments.of((Object[])new Object[]{"", new AtomicDataType((LogicalType)CharType.ofEmptyLiteral())}), Arguments.of((Object[])new Object[]{new byte[]{1, 2, 3}, DataTypes.BINARY((int)3)}), Arguments.of((Object[])new Object[]{new byte[0], new AtomicDataType((LogicalType)BinaryType.ofEmptyLiteral())}), Arguments.of((Object[])new Object[]{BigDecimal.ZERO, DataTypes.DECIMAL((int)1, (int)0)}), Arguments.of((Object[])new Object[]{new BigDecimal("12.123"), DataTypes.DECIMAL((int)5, (int)3)}), Arguments.of((Object[])new Object[]{new BigDecimal("1E+36"), DataTypes.DECIMAL((int)37, (int)0)}), Arguments.of((Object[])new Object[]{12, DataTypes.INT()}), Arguments.of((Object[])new Object[]{LocalTime.of(13, 24, 25, 1000), DataTypes.TIME((int)6)}), Arguments.of((Object[])new Object[]{LocalTime.of(13, 24, 25, 0), DataTypes.TIME((int)0)}), Arguments.of((Object[])new Object[]{LocalTime.of(13, 24, 25, 1), DataTypes.TIME((int)9)}), Arguments.of((Object[])new Object[]{LocalTime.of(13, 24, 25, 999999999), DataTypes.TIME((int)9)}), Arguments.of((Object[])new Object[]{LocalDateTime.of(2019, 11, 11, 13, 24, 25, 1001), DataTypes.TIMESTAMP((int)9)}), Arguments.of((Object[])new Object[]{ZonedDateTime.of(2019, 11, 11, 13, 24, 25, 1001, ZoneId.systemDefault()), DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)9).bridgedTo(ZonedDateTime.class)}), Arguments.of((Object[])new Object[]{OffsetDateTime.of(2019, 11, 11, 13, 24, 25, 1001, ZoneOffset.UTC), DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)9).bridgedTo(OffsetDateTime.class)}), Arguments.of((Object[])new Object[]{Instant.ofEpochMilli(12345602021L), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).bridgedTo(Instant.class)}), Arguments.of((Object[])new Object[]{Period.ofYears(1000), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR((int)4), (DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Period.class)}), Arguments.of((Object[])new Object[]{Duration.ofMillis(1100L), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY((int)1), (DataTypes.Resolution)DataTypes.SECOND((int)1)).bridgedTo(Duration.class)}), Arguments.of((Object[])new Object[]{Duration.ofDays(42L), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY((int)2), (DataTypes.Resolution)DataTypes.SECOND((int)0)).bridgedTo(Duration.class)}), Arguments.of((Object[])new Object[]{Timestamp.valueOf("2018-01-01 12:13:14.123"), DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class)}), Arguments.of((Object[])new Object[]{new Integer[]{1, 2, 3}, DataTypes.ARRAY((DataType)DataTypes.INT())}), Arguments.of((Object[])new Object[]{new Integer[]{1, null, 3}, DataTypes.ARRAY((DataType)DataTypes.INT())}), Arguments.of((Object[])new Object[]{new BigDecimal[]{new BigDecimal("12.1234"), new BigDecimal("42.4321"), new BigDecimal("20.0000")}, DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)6, (int)4))}), Arguments.of((Object[])new Object[]{new BigDecimal[]{null, new BigDecimal("42.4321")}, DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)6, (int)4))}), Arguments.of((Object[])new Object[]{new Integer[0], DataTypes.ARRAY((DataType)DataTypes.INT())}), Arguments.of((Object[])new Object[]{new Integer[][]{{1, null, 3}, new Integer[0], {1}}, DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))}), Arguments.of((Object[])new Object[]{TimePointUnit.HOUR, new AtomicDataType((LogicalType)new SymbolType(), TimePointUnit.class)}), Arguments.of((Object[])new Object[]{new BigDecimal[0], null}));
    }

    @ParameterizedTest(name="[{index}] value: {0} type: {1}")
    @MethodSource(value={"testData"})
    void testClassToDataTypeConversion(Object value, DataType dataType) {
        if (dataType == null) {
            Assertions.assertThat((Optional)ValueDataTypeConverter.extractDataType((Object)value)).isEmpty();
        } else {
            Assertions.assertThat((Optional)ValueDataTypeConverter.extractDataType((Object)value)).contains((Object)dataType.notNull());
        }
    }
}

