/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class TypeStrategiesTestBase {
    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testTypeStrategy(TestSpec testSpec) {
        if (testSpec.expectedErrorMessage != null) {
            Assertions.assertThatThrownBy(() -> this.runTypeInference(testSpec)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
        } else if (testSpec.expectedDataType != null) {
            if (testSpec.compareConversionClass) {
                TableAssertions.assertThat(this.runTypeInference(testSpec).getOutputDataType()).isEqualTo(testSpec.expectedDataType);
            } else {
                TableAssertions.assertThat(this.runTypeInference(testSpec).getOutputDataType().getLogicalType()).isEqualTo(testSpec.expectedDataType.getLogicalType());
            }
        }
    }

    protected abstract Stream<TestSpec> testData();

    private TypeInferenceUtil.Result runTypeInference(TestSpec testSpec) {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = testSpec.inputTypes;
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        callContextMock.isGroupedAggregation = testSpec.isGroupedAggregation;
        callContextMock.argumentLiterals = IntStream.range(0, testSpec.inputTypes.size()).mapToObj(i -> testSpec.literalPos != null && i == testSpec.literalPos).collect(Collectors.toList());
        callContextMock.argumentValues = IntStream.range(0, testSpec.inputTypes.size()).mapToObj(i -> testSpec.literalPos != null && i == testSpec.literalPos ? Optional.ofNullable(testSpec.literalValue) : Optional.empty()).collect(Collectors.toList());
        TypeInference typeInference = TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).outputTypeStrategy(testSpec.strategy).build();
        return TypeInferenceUtil.runTypeInference((TypeInference)typeInference, (CallContext)callContextMock, null);
    }

    public static class TestSpec {
        @Nullable
        private final String description;
        private final TypeStrategy strategy;
        private List<DataType> inputTypes;
        @Nullable
        private DataType expectedDataType;
        @Nullable
        private String expectedErrorMessage;
        @Nullable
        private Integer literalPos;
        @Nullable
        private Object literalValue;
        private boolean isGroupedAggregation;
        private boolean compareConversionClass = false;

        private TestSpec(@Nullable String description, TypeStrategy strategy) {
            this.description = description;
            this.strategy = strategy;
        }

        public static TestSpec forStrategy(TypeStrategy strategy) {
            return new TestSpec(null, strategy);
        }

        public static TestSpec forStrategy(String description, TypeStrategy strategy) {
            return new TestSpec(description, strategy);
        }

        public TestSpec inputTypes(DataType ... dataTypes) {
            this.inputTypes = Arrays.asList(dataTypes);
            return this;
        }

        public TestSpec calledWithLiteralAt(int pos, Object value) {
            this.literalPos = pos;
            this.literalValue = value;
            return this;
        }

        public TestSpec calledWithGroupedAggregation() {
            this.isGroupedAggregation = true;
            return this;
        }

        public TestSpec expectDataType(DataType expectedDataType) {
            this.expectedDataType = expectedDataType;
            return this;
        }

        public TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public TestSpec compareConversionClass() {
            this.compareConversionClass = true;
            return this;
        }

        public String toString() {
            return this.description != null ? this.description : "";
        }
    }
}

