/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.dataview;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.dataview.ListViewTypeInfoFactory;

@TypeInfo(value=ListViewTypeInfoFactory.class)
@PublicEvolving
public class ListView<T>
implements DataView {
    private static final long serialVersionUID = 5502298766901215388L;
    public transient TypeInformation<?> elementType;
    public final List<T> list;

    public ListView(TypeInformation<?> elementType, List<T> list) {
        this.elementType = elementType;
        this.list = list;
    }

    public ListView(TypeInformation<?> elementType) {
        this(elementType, new ArrayList());
    }

    public ListView() {
        this(null);
    }

    public Iterable<T> get() throws Exception {
        return this.list;
    }

    public void add(T value) throws Exception {
        this.list.add(value);
    }

    public void addAll(List<T> list) throws Exception {
        this.list.addAll(list);
    }

    public boolean remove(T value) throws Exception {
        return this.list.remove(value);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListView listView = (ListView)o;
        return Objects.equals(this.elementType, listView.elementType) && Objects.equals(this.list, listView.list);
    }

    public int hashCode() {
        return Objects.hash(this.elementType, this.list);
    }
}

