/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.HierarchyDescriptorValidator;
import org.apache.flink.table.descriptors.LiteralValueValidator;

@Internal
public class ClassInstanceValidator
extends HierarchyDescriptorValidator {
    public static final String CLASS = "class";
    public static final String CONSTRUCTOR = "constructor";

    public ClassInstanceValidator(String keyPrefix) {
        super(keyPrefix);
    }

    public ClassInstanceValidator() {
        this("");
    }

    @Override
    protected void validateWithPrefix(String keyPrefix, DescriptorProperties properties) {
        properties.validateString(keyPrefix + CLASS, false, 1);
        String constructorPrefix = keyPrefix + CONSTRUCTOR;
        List<Map<String, String>> constructorProperties = properties.getVariableIndexedProperties(constructorPrefix, new ArrayList<String>());
        for (int i = 0; i < constructorProperties.size(); ++i) {
            String keyPrefixWithIdx = constructorPrefix + "." + i + ".";
            if (constructorProperties.get(i).containsKey(CLASS)) {
                ClassInstanceValidator classInstanceValidator = new ClassInstanceValidator(keyPrefixWithIdx);
                classInstanceValidator.validate(properties);
                continue;
            }
            LiteralValueValidator primitiveValueValidator = new LiteralValueValidator(keyPrefixWithIdx);
            primitiveValueValidator.validate(properties);
        }
    }
}

