/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class AggregateFunctionDefinition
implements FunctionDefinition {
    private final String name;
    private final AggregateFunction<?, ?> aggregateFunction;
    private final TypeInformation<?> resultTypeInfo;
    private final TypeInformation<?> accumulatorTypeInfo;

    public AggregateFunctionDefinition(String name, AggregateFunction<?, ?> aggregateFunction, TypeInformation<?> resultTypeInfo, TypeInformation<?> accTypeInfo) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.aggregateFunction = (AggregateFunction)Preconditions.checkNotNull(aggregateFunction);
        this.resultTypeInfo = (TypeInformation)Preconditions.checkNotNull(resultTypeInfo);
        this.accumulatorTypeInfo = (TypeInformation)Preconditions.checkNotNull(accTypeInfo);
    }

    public AggregateFunction<?, ?> getAggregateFunction() {
        return this.aggregateFunction;
    }

    public TypeInformation<?> getResultTypeInfo() {
        return this.resultTypeInfo;
    }

    public TypeInformation<?> getAccumulatorTypeInfo() {
        return this.accumulatorTypeInfo;
    }

    @Override
    public FunctionKind getKind() {
        return FunctionKind.AGGREGATE;
    }

    @Override
    public Set<FunctionRequirement> getRequirements() {
        return this.aggregateFunction.getRequirements();
    }

    @Override
    public boolean isDeterministic() {
        return this.aggregateFunction.isDeterministic();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateFunctionDefinition that = (AggregateFunctionDefinition)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

