/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkDeserializationContext;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

public class RelDataTypeJsonDeserializer
extends StdDeserializer<RelDataType> {
    private static final long serialVersionUID = 1L;

    public RelDataTypeJsonDeserializer() {
        super(RelDataType.class);
    }

    public RelDataType deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        return this.deserialize(jsonNode, (FlinkDeserializationContext)ctx);
    }

    private RelDataType deserialize(JsonNode jsonNode, FlinkDeserializationContext ctx) throws JsonProcessingException {
        FlinkTypeFactory typeFactory = ctx.getSerdeContext().getTypeFactory();
        if (jsonNode instanceof ObjectNode) {
            RelDataType type;
            Integer scale;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.has("timestampKind")) {
                boolean nullable = objectNode.get("nullable").booleanValue();
                String typeName = objectNode.get("typeName").textValue();
                boolean isTimestampLtz = SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.name().equals(typeName);
                TimestampKind timestampKind = TimestampKind.valueOf((String)objectNode.get("timestampKind").asText().toUpperCase());
                switch (timestampKind) {
                    case ROWTIME: {
                        return typeFactory.createRowtimeIndicatorType(nullable, isTimestampLtz);
                    }
                    case PROCTIME: {
                        return typeFactory.createProctimeIndicatorType(nullable);
                    }
                }
                throw new TableException(timestampKind + " is not supported.");
            }
            if (objectNode.has("structuredType")) {
                JsonNode structuredTypeNode = objectNode.get("structuredType");
                LogicalType structuredType = (LogicalType)ctx.getObjectMapper().readValue(structuredTypeNode.toPrettyString(), LogicalType.class);
                Preconditions.checkArgument((boolean)(structuredType instanceof StructuredType));
                return ctx.getSerdeContext().getTypeFactory().createFieldTypeFromLogicalType(structuredType);
            }
            if (objectNode.has("structKind")) {
                ArrayNode arrayNode = (ArrayNode)objectNode.get("fields");
                RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
                for (JsonNode node : arrayNode) {
                    ((RelDataTypeFactory.Builder)builder).add(node.get("fieldName").asText(), this.deserialize(node, ctx));
                }
                StructKind structKind = StructKind.valueOf(objectNode.get("structKind").asText().toUpperCase());
                boolean nullable = objectNode.get("nullable").booleanValue();
                return ((RelDataTypeFactory.Builder)builder).kind(structKind).nullableRecord(nullable).build();
            }
            if (objectNode.has("fields")) {
                JsonNode fields2 = objectNode.get("fields");
                return this.deserialize(fields2, ctx);
            }
            SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, objectNode.get("typeName").asText()));
            boolean nullable = objectNode.get("nullable").booleanValue();
            if (SqlTypeName.INTERVAL_TYPES.contains((Object)sqlTypeName)) {
                TimeUnit startUnit = sqlTypeName.getStartUnit();
                TimeUnit endUnit = sqlTypeName.getEndUnit();
                return typeFactory.createTypeWithNullability(typeFactory.createSqlIntervalType(new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO)), nullable);
            }
            if (sqlTypeName == SqlTypeName.OTHER && objectNode.has("rawType")) {
                RawType rawType = (RawType)LogicalTypeParser.parse((String)objectNode.get("rawType").asText(), (ClassLoader)ctx.getSerdeContext().getClassLoader());
                return typeFactory.createTypeWithNullability(typeFactory.createFieldTypeFromLogicalType((LogicalType)rawType), nullable);
            }
            if (sqlTypeName == SqlTypeName.ANY && objectNode.has("rawType")) {
                JsonNode rawTypeNode = objectNode.get("rawType");
                boolean nullableOfTypeInfo = rawTypeNode.get("nullable").booleanValue();
                TypeInformation typeInfo = (TypeInformation)EncodingUtils.decodeStringToObject((String)rawTypeNode.get("typeInfo").asText(), TypeInformation.class, (ClassLoader)ctx.getSerdeContext().getClassLoader());
                TypeInformationRawType rawType = new TypeInformationRawType(nullableOfTypeInfo, typeInfo);
                return typeFactory.createTypeWithNullability(typeFactory.createFieldTypeFromLogicalType((LogicalType)rawType), nullable);
            }
            Integer precision = objectNode.has("precision") ? Integer.valueOf(objectNode.get("precision").intValue()) : null;
            Integer n = scale = objectNode.has("scale") ? Integer.valueOf(objectNode.get("scale").intValue()) : null;
            if (sqlTypeName == SqlTypeName.ARRAY) {
                RelDataType elementType = this.deserialize(objectNode.get("element"), ctx);
                type = typeFactory.createArrayType(elementType, -1L);
            } else if (sqlTypeName == SqlTypeName.MULTISET) {
                RelDataType elementType = this.deserialize(objectNode.get("element"), ctx);
                type = typeFactory.createMultisetType(elementType, -1L);
            } else if (sqlTypeName == SqlTypeName.MAP) {
                RelDataType keyType = this.deserialize(objectNode.get("key"), ctx);
                RelDataType valueType = this.deserialize(objectNode.get("value"), ctx);
                type = typeFactory.createMapType(keyType, valueType);
            } else {
                type = precision == null ? typeFactory.createSqlType(sqlTypeName) : (scale == null ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName, precision, scale));
            }
            return typeFactory.createTypeWithNullability(type, nullable);
        }
        if (jsonNode instanceof TextNode) {
            SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, jsonNode.asText()));
            return typeFactory.createSqlType(sqlTypeName);
        }
        throw new TableException("Unknown type: " + jsonNode.toPrettyString());
    }
}

