/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLegacySink;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.ExecNodeVisitorImpl;
import org.apache.flink.util.Preconditions;

public class ExecNodePlanDumper {
    public static String treeToString(ExecNode<?> node) {
        return ExecNodePlanDumper.treeToString(node, new ArrayList(), false);
    }

    public static String treeToString(ExecNode<?> node, List<ExecNode<?>> borders, boolean includingBorders) {
        Preconditions.checkNotNull(node, (String)"node should not be null.");
        ArrayList borderList = new ArrayList((Collection)Preconditions.checkNotNull(borders, (String)"borders should not be null."));
        TreeReuseInfo reuseInfo = new TreeReuseInfo(node, borderList);
        return ExecNodePlanDumper.doConvertTreeToString(node, reuseInfo, true, borderList, includingBorders);
    }

    public static String dagToString(ExecNodeGraph execGraph) {
        return ExecNodePlanDumper.dagToString(execGraph.getRootNodes());
    }

    public static String dagToString(List<ExecNode<?>> nodes) {
        Preconditions.checkArgument((nodes != null && !nodes.isEmpty() ? 1 : 0) != 0, (Object)"nodes should not be null or empty.");
        if (nodes.size() == 1) {
            return ExecNodePlanDumper.treeToString(nodes.get(0));
        }
        final ArrayList stopVisitNodes = new ArrayList();
        final StringBuilder sb = new StringBuilder();
        final DagReuseInfo reuseInfo = new DagReuseInfo(nodes, new ArrayList());
        ExecNodeVisitorImpl visitor = new ExecNodeVisitorImpl(){

            @Override
            public void visit(ExecNode<?> node) {
                int reuseId;
                boolean isReuseNode;
                boolean isFirstVisit;
                int visitedTimes = reuseInfo.addVisitedTimes(node);
                boolean bl = isFirstVisit = visitedTimes == 1;
                if (isFirstVisit) {
                    super.visit(node);
                }
                boolean bl2 = isReuseNode = (reuseId = reuseInfo.getReuseId(node).intValue()) >= 0;
                if (node instanceof CommonExecLegacySink || node instanceof CommonExecSink || isReuseNode && isFirstVisit) {
                    if (isReuseNode) {
                        reuseInfo.setFirstVisited(node, true);
                    }
                    String reusePlan = ExecNodePlanDumper.doConvertTreeToString(node, reuseInfo, false, stopVisitNodes, false);
                    sb.append(reusePlan).append(System.lineSeparator());
                    if (isReuseNode) {
                        stopVisitNodes.add(node);
                        reuseInfo.setFirstVisited(node, false);
                    }
                }
            }
        };
        nodes.forEach(visitor::visit);
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String doConvertTreeToString(ExecNode<?> node, ReuseInfo reuseInfo, boolean updateVisitedTimes, List<ExecNode<?>> stopVisitNodes, boolean includingBorders) {
        StringBuilder sb = new StringBuilder();
        ExecNodeStringTreeBuilder visitor = new ExecNodeStringTreeBuilder(sb, reuseInfo, updateVisitedTimes, stopVisitNodes, includingBorders);
        node.accept(visitor);
        return sb.toString();
    }

    private ExecNodePlanDumper() {
    }

    private static class ExecNodeStringTreeBuilder
    extends ExecNodeVisitorImpl {
        private final StringBuilder sb;
        private final ReuseInfo reuseInfo;
        private final boolean updateVisitedTimes;
        private final List<ExecNode<?>> stopVisitNodes;
        private final boolean includingBorders;
        private List<Boolean> lastChildren = new ArrayList<Boolean>();
        private int depth = 0;

        private ExecNodeStringTreeBuilder(StringBuilder sb, ReuseInfo reuseInfo, boolean updateVisitedTimes, List<ExecNode<?>> stopVisitNodes, boolean includingBorders) {
            this.sb = sb;
            this.reuseInfo = reuseInfo;
            this.updateVisitedTimes = updateVisitedTimes;
            this.stopVisitNodes = stopVisitNodes;
            this.includingBorders = includingBorders;
        }

        @Override
        public void visit(ExecNode<?> node) {
            int reuseId;
            int borderIndex;
            boolean reachBorder;
            if (this.updateVisitedTimes) {
                this.reuseInfo.addVisitedTimes(node);
            }
            if (this.depth > 0) {
                this.lastChildren.subList(0, this.lastChildren.size() - 1).forEach(isLast -> this.sb.append(isLast != false ? "   " : ":  "));
                this.sb.append(this.lastChildren.get(this.lastChildren.size() - 1) != false ? "+- " : ":- ");
            }
            boolean bl = reachBorder = (borderIndex = this.stopVisitNodes.indexOf(node)) >= 0;
            if (reachBorder && this.includingBorders) {
                this.sb.append("[#").append(borderIndex + 1).append("] ");
            }
            boolean isReuseNode = (reuseId = this.reuseInfo.getReuseId(node).intValue()) >= 0;
            boolean firstVisited = this.reuseInfo.isFirstVisited(node);
            if (isReuseNode && !firstVisited) {
                this.sb.append("Reused");
            } else {
                this.sb.append(node.getDescription());
            }
            if (isReuseNode) {
                if (firstVisited) {
                    this.sb.append("(reuse_id=[").append(reuseId).append("])");
                } else {
                    this.sb.append("(reference_id=[").append(reuseId).append("])");
                }
            }
            this.sb.append("\n");
            boolean visitInputs2 = (firstVisited || !isReuseNode) && !this.stopVisitNodes.contains(node);
            List inputNodes = node.getInputEdges().stream().map(ExecEdge::getSource).collect(Collectors.toList());
            if (visitInputs2 && inputNodes.size() > 1) {
                inputNodes.subList(0, inputNodes.size() - 1).forEach(input -> {
                    ++this.depth;
                    this.lastChildren.add(false);
                    input.accept(this);
                    --this.depth;
                    this.lastChildren = this.lastChildren.subList(0, this.lastChildren.size() - 1);
                });
            }
            if (visitInputs2 && !inputNodes.isEmpty()) {
                ++this.depth;
                this.lastChildren.add(true);
                ((ExecNode)inputNodes.get(inputNodes.size() - 1)).accept(this);
                --this.depth;
                this.lastChildren = this.lastChildren.subList(0, this.lastChildren.size() - 1);
            }
        }
    }

    private static class ReuseIdBuilder
    extends ExecNodeVisitorImpl {
        private final List<ExecNode<?>> borders;
        private final Set<ExecNode<?>> visitedNodes = Collections.newSetFromMap(new IdentityHashMap());
        private final Map<ExecNode<?>, Integer> mapReuseNodeToReuseId = new IdentityHashMap();
        private final AtomicInteger reuseIdGenerator = new AtomicInteger(0);

        public ReuseIdBuilder(List<ExecNode<?>> borders) {
            this.borders = borders;
        }

        @Override
        public void visit(ExecNode<?> node) {
            if (this.borders.contains(node)) {
                return;
            }
            if (this.visitedNodes.contains(node)) {
                if (!this.mapReuseNodeToReuseId.containsKey(node)) {
                    int reuseId = this.reuseIdGenerator.incrementAndGet();
                    this.mapReuseNodeToReuseId.put(node, reuseId);
                }
            } else {
                this.visitedNodes.add(node);
                super.visit(node);
            }
        }

        public Integer getReuseId(ExecNode<?> node) {
            return this.mapReuseNodeToReuseId.getOrDefault(node, -1);
        }
    }

    private static class DagReuseInfo
    extends ReuseInfo {
        private final Map<ExecNode<?>, Boolean> firstVisitedMap = new IdentityHashMap();

        public DagReuseInfo(List<ExecNode<?>> nodes, List<ExecNode<?>> borders) {
            super(nodes, borders);
        }

        @Override
        boolean isFirstVisited(ExecNode<?> node) {
            return this.firstVisitedMap.getOrDefault(node, false);
        }

        void setFirstVisited(ExecNode<?> node, boolean visitedFlag) {
            this.firstVisitedMap.put(node, visitedFlag);
        }
    }

    private static class TreeReuseInfo
    extends ReuseInfo {
        public TreeReuseInfo(ExecNode<?> node, List<ExecNode<?>> borders) {
            super(Collections.singletonList(node), borders);
        }

        @Override
        boolean isFirstVisited(ExecNode<?> node) {
            return (Integer)this.mapNodeToVisitedTimes.get(node) == 1;
        }
    }

    private static abstract class ReuseInfo {
        private final ReuseIdBuilder reuseIdBuilder;
        protected final Map<ExecNode<?>, Integer> mapNodeToVisitedTimes;

        protected ReuseInfo(List<ExecNode<?>> nodes, List<ExecNode<?>> borders) {
            this.reuseIdBuilder = new ReuseIdBuilder(borders);
            nodes.forEach(this.reuseIdBuilder::visit);
            this.mapNodeToVisitedTimes = new IdentityHashMap();
        }

        Integer getReuseId(ExecNode<?> node) {
            return this.reuseIdBuilder.getReuseId(node);
        }

        abstract boolean isFirstVisited(ExecNode<?> var1);

        int addVisitedTimes(ExecNode<?> node) {
            return this.mapNodeToVisitedTimes.compute(node, (k, v) -> v == null ? 1 : v + 1);
        }
    }
}

