/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableEnvironmentInternalTest
extends JsonPlanTestBase {
    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
    }

    @Test
    public void testGetJsonPlan() throws IOException {
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select * from MyTable");
        String expected = TableTestUtil.readFromResource("/jsonplan/testGetJsonPlan.out");
        Assert.assertEquals((Object)TableTestUtil.replaceExecNodeId(TableTestUtil.replaceFlinkVersion(TableTestUtil.getFormattedJson(expected))), (Object)TableTestUtil.replaceExecNodeId(TableTestUtil.replaceFlinkVersion(TableTestUtil.getFormattedJson(jsonPlan))));
    }

    @Test
    public void testExecuteJsonPlan() throws Exception {
        List<String> data = Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world");
        this.createTestCsvSourceTable("src", data, "a bigint", "b int", "c varchar");
        File sinkPath = this.createTestCsvSinkTable("sink", "a bigint", "b int", "c varchar");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into sink select * from src");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        this.assertResult(data, sinkPath);
    }

    @Test
    public void testExplainJsonPlan() {
        String jsonPlan = TableTestUtil.readFromResource("/jsonplan/testGetJsonPlan.out");
        String actual = this.tableEnv.explainJsonPlan(jsonPlan, new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        String expected = TableTestUtil.readFromResource("/explain/testExplainJsonPlan.out");
        Assert.assertEquals((Object)expected, (Object)TableTestUtil.replaceStreamNodeId(actual));
    }

    @Test
    public void testBatchMode() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().useBlinkPlanner().inBatchMode().build();
        this.tableEnv = (TableEnvironmentInternal)TableEnvironment.create((EnvironmentSettings)settings);
        String srcTableDdl = "CREATE TABLE src (\n  a bigint\n) with (\n  'connector' = 'values',\n  'bounded' = 'true')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE sink (\n  a bigint\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
        this.exception.expect(TableException.class);
        this.exception.expectMessage("Only streaming mode is supported now");
        this.tableEnv.getJsonPlan("insert into sink select * from src");
    }
}

