/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Double$;
import scala.Float$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001=\u0011q\u0002R3dS6\fGnQ1tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\ba2\fgN\\3s\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0005M\u0011\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005I)\u0005\u0010\u001d:fgNLwN\u001c+fgR\u0014\u0015m]3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u0004e:$W#\u0001\u0010\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001B;uS2T\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\u0001\u0012aAU1oI>l\u0007BB\u0014\u0001A\u0003%a$\u0001\u0003s]\u0012\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013a\u0005;fgR\u001c\u0015m\u001d;Ge>lg*^7fe&\u001cG#A\u0016\u0011\u00051jS\"\u0001\u0012\n\u00059\u0012#\u0001B+oSRD#\u0001\u000b\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mb\u0011!\u00026v]&$\u0018BA\u001b3\u0005\u0011!Vm\u001d;\t\u000b]\u0002A\u0011\u0001\u0016\u0002#Q,7\u000f^\"bgR4%o\\7GY>\fG\u000f\u000b\u00027a!)!\b\u0001C\u0001U\u0005\u0011B/Z:u\u0007\u0006\u001cHO\u0012:p[N#(/\u001b8hQ\tI\u0004\u0007C\u0003>\u0001\u0011\u0005!&A\nuKN$8)Y:u\rJ|WNQ8pY\u0016\fg\u000e\u000b\u0002=a!)\u0001\t\u0001C\u0001U\u0005\tB/Z:u\u0007\u0006\u001cH\u000fV8Ok6,'/[2)\u0005}\u0002\u0004\"B\"\u0001\t\u0003Q\u0013a\u0004;fgR\u001c\u0015m\u001d;U_\u001acw.\u0019;)\u0005\t\u0003\u0004\"\u0002$\u0001\t\u0003Q\u0013\u0001\u0005;fgR\u001c\u0015m\u001d;U_N#(/\u001b8hQ\t)\u0005\u0007C\u0003J\u0001\u0011\u0005!&A\tuKN$8)Y:u)>\u0014un\u001c7fC:D#\u0001\u0013\u0019\t\u000b1\u0003A\u0011\u0001\u0016\u0002#Q,7\u000f^\"bgR$v\u000eR3dS6\fG\u000e\u000b\u0002La!)q\n\u0001C\u0005!\u0006)B/Z:u+:\u001cX\u000f\u001d9peR,GmQ1tiR{GCA\u0016R\u0011\u0015\u0011f\n1\u0001T\u0003\u0005!\bC\u0001+X\u001d\taS+\u0003\u0002WE\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1&\u0005C\u0003\\\u0001\u0011\u0005!&\u0001\tuKN$8)Y:u)>\u0014\u0015N\\1ss\"\u0012!\f\r\u0005\u0006=\u0002!\tAK\u0001\u0014i\u0016\u001cHoQ1tiR{g+\u0019:CS:\f'/\u001f\u0015\u0003;BBQ!\u0019\u0001\u0005\u0002)\na\u0002^3ti\u000e\u000b7\u000f\u001e+p\t\u0006$X\r\u000b\u0002aa!)A\r\u0001C\u0001U\u0005qA/Z:u\u0007\u0006\u001cH\u000fV8US6,\u0007FA21\u0011\u00159\u0007\u0001\"\u0001+\u0003M!Xm\u001d;DCN$Hk\u001c+j[\u0016\u001cH/Y7qQ\t1\u0007\u0007C\u0003k\u0001\u0011\u0005!&A\u000buKN$8)Y:u)>$\u0016.\\3ti\u0006l\u0007\u000f\u0014>)\u0005%\u0004\u0004\"B7\u0001\t\u0003Q\u0013a\u0004;fgR\u001c\u0015m\u001d;U_\u0006\u0013(/Y=)\u00051\u0004\u0004\"\u00029\u0001\t\u0003Q\u0013A\u0005;fgR\u001c\u0015m\u001d;U_6+H\u000e^5TKRD#a\u001c\u0019\t\u000bM\u0004A\u0011\u0001\u0016\u0002\u001bQ,7\u000f^\"bgR$v.T1qQ\t\u0011\b\u0007C\u0003w\u0001\u0011\u0005!&A\u0007uKN$8)Y:u)>\u0014vn\u001e\u0015\u0003kBBQ!\u001f\u0001\u0005\ni\fq\u0003^3tiVs7/\u001e9q_J$X\rZ\"bgR4%o\\7\u0015\u0005-Z\b\"\u0002*y\u0001\u0004\u0019\u0006\"B?\u0001\t\u0003Q\u0013A\u0005;fgR\u001c\u0015m\u001d;Ge>l')\u001b8befD#\u0001 \u0019\t\r\u0005\u0005\u0001\u0001\"\u0001+\u0003U!Xm\u001d;DCN$hI]8n-\u0006\u0014()\u001b8befD#a \u0019\t\r\u0005\u001d\u0001\u0001\"\u0001+\u0003A!Xm\u001d;DCN$hI]8n\t\u0006$X\rK\u0002\u0002\u0006ABa!!\u0004\u0001\t\u0003Q\u0013\u0001\u0005;fgR\u001c\u0015m\u001d;Ge>lG+[7fQ\r\tY\u0001\r\u0005\u0007\u0003'\u0001A\u0011\u0001\u0016\u0002+Q,7\u000f^\"bgR4%o\\7US6,7\u000f^1na\"\u001a\u0011\u0011\u0003\u0019\t\r\u0005e\u0001\u0001\"\u0001+\u0003]!Xm\u001d;DCN$hI]8n)&lWm\u001d;b[Bd%\u0010K\u0002\u0002\u0018ABa!a\b\u0001\t\u0003Q\u0013!\u0005;fgR\u001c\u0015m\u001d;Ge>l\u0017I\u001d:bs\"\u001a\u0011Q\u0004\u0019\t\r\u0005\u0015\u0002\u0001\"\u0001+\u0003Q!Xm\u001d;DCN$hI]8n\u001bVdG/[*fi\"\u001a\u00111\u0005\u0019\t\r\u0005-\u0002\u0001\"\u0001+\u0003=!Xm\u001d;DCN$hI]8n\u001b\u0006\u0004\bfAA\u0015a!1\u0011\u0011\u0007\u0001\u0005\u0002)\nq\u0002^3ti\u000e\u000b7\u000f\u001e$s_6\u0014vn\u001e\u0015\u0004\u0003_\u0001\u0004bBA\u001c\u0001\u0011\u0005\u0011\u0011H\u0001\u000eI\u0016\u001c\u0017.\\1m?NBt,\r\u001d\u0015\u0007M\u000bY\u0004\u0003\u0005\u0002>\u0005U\u0002\u0019AA \u0003\u0005I\u0007c\u0001\u0017\u0002B%\u0019\u00111\t\u0012\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002H\u0001!\t!!\u0013\u0002\u0019\u0011,7-[7bY~\u001b\u0004h\u0018\u001a\u0015\u0007M\u000bY\u0005\u0003\u0005\u0002>\u0005\u0015\u0003\u0019AA \u0011\u001d\ty\u0005\u0001C!\u0003#\n\u0001\u0002^3ti\u0012\u000bG/Y\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033B\u0011!\u0002;za\u0016\u001c\u0018\u0002BA/\u0003/\u00121AU8x\u0011\u001d\t\t\u0007\u0001C!\u0003G\n\u0001\u0002^=qK&sgm\\\u000b\u0003\u0003K\u0002B!a\u001a\u0002v5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005usB,W\u000f^5mg*!\u0011qNA9\u0003\u0011Q\u0017M^1\u000b\u0007\u0005M\u0004\"A\u0002ba&LA!a\u001e\u0002j\tY!k\\<UsB,\u0017J\u001c4p\u0001")
public class DecimalCastTest
extends ExpressionTestBase {
    private final Random rnd = new Random();

    public Random rnd() {
        return this.rnd;
    }

    @Test
    public void testCastFromNumeric() {
        this.test$1("TINYINT", BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToByte((byte)((byte)this.rnd().nextInt())));
        this.test$1("SMALLINT", BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToShort((short)((short)this.rnd().nextInt())));
        this.test$1("INT", BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
        this.test$1("BIGINT", BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToLong((long)this.rnd().nextLong()));
    }

    @Test
    public void testCastFromFloat() {
        this.test$2("FLOAT", BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
        this.test$2("DOUBLE", BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
    }

    @Test
    public void testCastFromString() {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CAST(null AS VARCHAR) AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CAST(null AS CHAR) AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('0' AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CAST('12.2' AS VARCHAR) AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('-12.2' AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "-12");
        int rV = this.rnd().nextInt();
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('", "' AS DECIMAL(38, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rV)})), ((Object)BoxesRunTime.boxToInteger((int)rV)).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('100' AS DECIMAL(2, 0))"})).s((Seq)Nil$.MODULE$), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('x100' AS DECIMAL(2, 0))"})).s((Seq)Nil$.MODULE$), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('100x' AS DECIMAL(2, 0))"})).s((Seq)Nil$.MODULE$), "null");
    }

    @Test
    public void testCastFromBoolean() {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CAST(null AS BOOLEAN) AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(true AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "1");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(false AS DECIMAL)"})).s((Seq)Nil$.MODULE$), "0");
    }

    @Test
    public void testCastToNumeric() {
        this.test$3("TINYINT", BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToByte((byte)((byte)this.rnd().nextInt())));
        this.test$3("SMALLINT", BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToShort((short)((short)this.rnd().nextInt())));
        this.test$3("INT", BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)this.rnd().nextInt()));
        this.test$3("BIGINT", BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToLong((long)this.rnd().nextLong()));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TINYINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToInteger((int)128))})), "-128");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS SMALLINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToInteger((int)32768))})), "-32768");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS INT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToLong((long)0x80000000L))})), "-2147483648");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(package$.MODULE$.BigDecimal().apply(Long.MAX_VALUE).$plus(BigDecimal$.MODULE$.int2bigDecimal(1)))})), "-9223372036854775808");
    }

    @Test
    public void testCastToFloat() {
        this.test$4("FLOAT");
        this.test$4("DOUBLE");
    }

    @Test
    public void testCastToString() {
        this.test$5("VARCHAR");
        this.test$5("CHAR");
    }

    @Test
    public void testCastToBoolean() {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BOOLEAN)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(null)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BOOLEAN)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToInteger((int)0))})), "false");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BOOLEAN)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToInteger((int)1))})), "true");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BOOLEAN)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)12.2))})), "true");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BOOLEAN)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)-12.2))})), "true");
    }

    @Test
    public void testCastToDecimal() {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(null)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(1, 1))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToInteger((int)0))})), "0.0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(3, 2))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)6.32))})), "6.32");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(2, 1))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)236.2))})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(2, 1))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))})), "5.2");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(2, 1))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.26))})), "5.3");
    }

    private void testUnsupportedCastTo(String t) {
        this.expectedException().expectMessage("Cast function cannot convert value of type DECIMAL(38, 2) to type");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22)), t})), "");
    }

    @Test
    public void testCastToBinary() {
        this.testUnsupportedCastTo("BINARY(4)");
    }

    @Test
    public void testCastToVarBinary() {
        this.testUnsupportedCastTo("VARBINARY");
    }

    @Test
    public void testCastToDate() {
        this.testUnsupportedCastTo("DATE");
    }

    @Test
    public void testCastToTime() {
        this.testUnsupportedCastTo("TIME");
    }

    @Test
    public void testCastToTimestamp() {
        this.expectedException().expectMessage("The cast conversion from NUMERIC type to TIMESTAMP type is not allowed, it's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIMESTAMP)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))})), "");
    }

    @Test
    public void testCastToTimestampLz() {
        this.expectedException().expectMessage("The cast conversion from NUMERIC type to TIMESTAMP_LTZ type is not allowed, it's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIMESTAMP_LTZ)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.22))})), "");
    }

    @Test
    public void testCastToArray() {
        this.testUnsupportedCastTo("ARRAY<INT>");
    }

    @Test
    public void testCastToMultiSet() {
        this.testUnsupportedCastTo("MULTISET<INT>");
    }

    @Test
    public void testCastToMap() {
        this.testUnsupportedCastTo("MAP<INT, INT>");
    }

    @Test
    public void testCastToRow() {
        this.testUnsupportedCastTo("ROW<i INT, j INT>");
    }

    private void testUnsupportedCastFrom(String t) {
        this.expectedException().expectMessage("Cast function cannot convert value of type");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CAST(NULL AS ", ") AS DECIMAL(38, 2))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t})), "");
    }

    @Test
    public void testCastFromBinary() {
        this.testUnsupportedCastFrom("BINARY(4)");
    }

    @Test
    public void testCastFromVarBinary() {
        this.testUnsupportedCastFrom("VARBINARY");
    }

    @Test
    public void testCastFromDate() {
        this.testUnsupportedCastFrom("DATE");
    }

    @Test
    public void testCastFromTime() {
        this.testUnsupportedCastFrom("TIME");
    }

    @Test
    public void testCastFromTimestamp() {
        this.expectedException().expectMessage("The cast conversion from TIMESTAMP type to NUMERIC type is not allowed, it's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(TIMESTAMP '2020-02-02' AS DECIMAL(38, 2))"})).s((Seq)Nil$.MODULE$), "");
    }

    @Test
    public void testCastFromTimestampLz() {
        this.expectedException().expectMessage("The cast conversion from TIMESTAMP_LTZ type to NUMERIC type is not allowed.");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CAST('2020-02-02' AS TIMESTAMP_LTZ) AS DECIMAL(38, 2))"})).s((Seq)Nil$.MODULE$), "");
    }

    @Test
    public void testCastFromArray() {
        this.testUnsupportedCastFrom("ARRAY<INT>");
    }

    @Test
    public void testCastFromMultiSet() {
        this.testUnsupportedCastFrom("MULTISET<INT>");
    }

    @Test
    public void testCastFromMap() {
        this.testUnsupportedCastFrom("MAP<INT, INT>");
    }

    @Test
    public void testCastFromRow() {
        this.testUnsupportedCastFrom("ROW<i INT, j INT>");
    }

    public String decimal_38_18(Object i) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('", "' AS DECIMAL(38, 18))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i}));
    }

    public String decimal_38_2(Object i) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('", "' AS DECIMAL(38, 2))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i}));
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }

    private final String value$1(Object i, String t$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i, t$1}));
    }

    private final void test$1(String t, Object max, Object min, Object rV) {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(null, t)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(BoxesRunTime.boxToInteger((int)0), t)})), "0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(BoxesRunTime.boxToInteger((int)12), t)})), "12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(BoxesRunTime.boxToInteger((int)-12), t)})), "-12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(20, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(max, t)})), max.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(20, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(min, t)})), min.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(20, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(rV, t)})), rV.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(2, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1(BoxesRunTime.boxToInteger((int)100), t)})), "null");
    }

    private final String value$2(Object i, String t$2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i, t$2}));
    }

    private final void test$2(String t, Object max, Object min, Object rV) {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(null, t)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToInteger((int)0), t)})), "0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToDouble((double)12.2), t)})), "12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToDouble((double)-12.2), t)})), "-12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(38, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(max, t)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(38, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(min, t)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(38, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(rV, t)})), rV.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(2, 0))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToInteger((int)100), t)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(10, 4))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToFloat((float)6.8242f), t)})), "6.8242");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(10, 3))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToFloat((float)6.8242f), t)})), "6.824");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(10, 3))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToFloat((float)6.8247f), t)})), "6.825");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(10, 5))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToFloat((float)6.82f), t)})), "6.82000");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(5, 5))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToFloat((float)6.82f), t)})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(5, 4))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2(BoxesRunTime.boxToFloat((float)66.82f), t)})), "null");
    }

    private final void test$3(String t, Object max, Object min, Object rV) {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(null), t})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToInteger((int)0)), t})), "0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToInteger((int)12)), t})), "12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToInteger((int)-12)), t})), "-12");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(max), t})), max.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(min), t})), min.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(rV), t})), rV.toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToDouble((double)5.26)), t})), "5");
    }

    private final void test$4(String t) {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(null), t})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToInteger((int)0)), t})), "0.0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToDouble((double)12.2)), t})), "12.2");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToDouble((double)-12.2)), t})), "-12.2");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_18(BoxesRunTime.boxToDouble((double)5.26)), t})), "5.26");
    }

    private final void test$5(String t) {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(null), t})), "null");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToInteger((int)0)), t})), "0.00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)12.2)), t})), "12.20");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)-12.2)), t})), "-12.20");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decimal_38_2(BoxesRunTime.boxToDouble((double)5.26)), t})), "5.26");
    }
}

