/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001f\t\t\"j]8o\rVt7\r^5p]N$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\t\u0019\"!A\u0003vi&d7/\u0003\u0002\u0016%\t\u0011R\t\u001f9sKN\u001c\u0018n\u001c8UKN$()Y:f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0011\u0005S$\u0001\u0005uKN$H)\u0019;b+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0003EA\u0002S_^DQ!\n\u0001\u0005B\u0019\n\u0001\u0002^=qK&sgm\\\u000b\u0002OA\u0011\u0001fL\u0007\u0002S)\u0011!fK\u0001\nif\u0004X-\u001e;jYNT!\u0001L\u0017\u0002\t)\fg/\u0019\u0006\u0003]!\t1!\u00199j\u0013\t\u0001\u0014FA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0004;fgR\u0004&/\u001a3jG\u0006$Xm\u001d\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t!QK\\5uQ\t\t4\b\u0005\u0002=\u007f5\tQH\u0003\u0002?\u0019\u0005)!.\u001e8ji&\u0011\u0001)\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011%1)\u0001\twKJLg-\u001f)sK\u0012L7-\u0019;fgR\u0019A\u0007R'\t\u000b\u0015\u000b\u0005\u0019\u0001$\u0002\u0013\r\fg\u000eZ5eCR,\u0007CA$K\u001d\t)\u0004*\u0003\u0002Jm\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIe\u0007C\u0003O\u0003\u0002\u0007q*\u0001\bfqB,7\r^3e-\u0006dW/Z:\u0011\u0007U\u0002&+\u0003\u0002Rm\t)\u0011I\u001d:bsB\u0011QgU\u0005\u0003)Z\u0012qAQ8pY\u0016\fg\u000eC\u0003W\u0001\u0011%q+A\bwKJLg-_#yG\u0016\u0004H/[8o+\tA\u0016\rF\u000253jCQ!R+A\u0002\u0019CQaW+A\u0002q\u000b\u0011#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8o!\r9UlX\u0005\u0003=2\u0013Qa\u00117bgN\u0004\"\u0001Y1\r\u0001\u0011)!-\u0016b\u0001G\n\tA+\u0005\u0002eOB\u0011Q'Z\u0005\u0003MZ\u0012qAT8uQ&tw\r\u0005\u0002ia:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y:\ta\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005=4\u0014a\u00029bG.\fw-Z\u0005\u0003cJ\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0005=4\u0004")
public class JsonFunctionsTest
extends ExpressionTestBase {
    /*
     * WARNING - void declaration
     */
    @Override
    public Row testData() {
        void var1_1;
        Row testData = new Row(9);
        testData.setField(0, (Object)"This is a test String.");
        testData.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        testData.setField(2, (Object)BoxesRunTime.boxToByte((byte)((byte)42)));
        testData.setField(3, (Object)BoxesRunTime.boxToShort((short)((short)43)));
        testData.setField(4, (Object)BoxesRunTime.boxToLong((long)44));
        testData.setField(5, (Object)BoxesRunTime.boxToFloat((float)((float)4.5)));
        testData.setField(6, (Object)BoxesRunTime.boxToDouble((double)4.6));
        testData.setField(7, (Object)BoxesRunTime.boxToInteger((int)3));
        testData.setField(8, (Object)"{ \"name\" : \"flink\" }");
        return var1_1;
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[]{Types.STRING, Types.BOOLEAN, Types.BYTE, Types.SHORT, Types.LONG, Types.FLOAT, Types.DOUBLE, Types.INT, Types.STRING});
    }

    @Test
    public void testPredicates() {
        boolean[] malformed = new boolean[]{false, false, false, false};
        boolean[] jsonObject = new boolean[]{true, true, false, false};
        boolean[] jsonArray = new boolean[]{true, false, true, false};
        boolean[] jsonScalar = new boolean[]{true, false, false, true};
        this.verifyPredicates("'{}'", jsonObject);
        this.verifyPredicates("'[]'", jsonArray);
        this.verifyPredicates("'100'", jsonScalar);
        this.verifyPredicates("'{]'", malformed);
        this.verifyPredicates("f0", malformed);
        this.verifyPredicates("f8", jsonObject);
        this.verifyException("f1", ValidationException.class);
        this.verifyException("f2", ValidationException.class);
        this.verifyException("f3", ValidationException.class);
        this.verifyException("f4", ValidationException.class);
        this.verifyException("f5", ValidationException.class);
        this.verifyException("f6", ValidationException.class);
        this.verifyException("f7", ValidationException.class);
    }

    private void verifyPredicates(String candidate, boolean[] expectedValues) {
        Predef$.MODULE$.assert(expectedValues.length == 4);
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((boolean)expectedValues[0])).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((!expectedValues[0] ? 1 : 0) != 0)).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json object"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((boolean)expectedValues[1])).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json object"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((!expectedValues[1] ? 1 : 0) != 0)).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json array"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((boolean)expectedValues[2])).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json array"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((!expectedValues[2] ? 1 : 0) != 0)).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json scalar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((boolean)expectedValues[3])).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json scalar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), ((Object)BoxesRunTime.boxToBoolean((!expectedValues[3] ? 1 : 0) != 0)).toString());
    }

    private <T extends Exception> void verifyException(String candidate, Class<T> expectedException) {
        String[] sqlCandidates = (String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json object"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json object"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json array"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json array"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is json scalar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not json scalar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate}))});
        Predef$.MODULE$.refArrayOps((Object[])sqlCandidates).foreach((Function1)new Serializable(this, expectedException){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonFunctionsTest $outer;
            private final Class expectedException$1;

            public final void apply(String sql) {
                try {
                    this.$outer.testSqlApi(sql, "null");
                }
                catch (Exception exception) {
                    Assert.assertEquals(exception.getClass(), (Object)this.expectedException$1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedException$1 = expectedException$1;
            }
        });
    }
}

