/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Locale;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003V3na>\u0014\u0018\r\u001c+za\u0016\u001cH+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\u00069\u0001!\t!H\u0001\u0016i\u0016\u001cH\u000fV5nKB{\u0017N\u001c;MSR,'/\u00197t)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRD#aG\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!b\u0011!\u00026v]&$\u0018B\u0001\u0016(\u0005\u0011!Vm\u001d;\t\u000b1\u0002A\u0011A\u000f\u00021Q,7\u000f\u001e+j[\u0016Le\u000e^3sm\u0006dG*\u001b;fe\u0006d7\u000f\u000b\u0002,K!)q\u0006\u0001C\u0001;\u0005\u0011B/Z:u)&lW\rU8j]RLe\u000e];uQ\tqS\u0005C\u00033\u0001\u0011\u0005Q$A\u000buKN$H+[7f\u0013:$XM\u001d<bY&s\u0007/\u001e;)\u0005E*\u0003\"B\u001b\u0001\t\u0003i\u0012\u0001\u0006;fgR$\u0016.\\3Q_&tGoQ1ti&tw\r\u000b\u00025K!)\u0001\b\u0001C\u0001;\u0005IB/Z:u)&lWm\u001d;b[BdEO_\"bgRLe.\u0016+DQ\t9T\u0005C\u0003<\u0001\u0011\u0005Q$\u0001\u0010uKN$H+[7fgR\fW\u000e\u001d'uu\u000e\u000b7\u000f^%o'\"\fgn\u001a5bS\"\u0012!(\n\u0005\u0006}\u0001!\t!H\u0001,i\u0016\u001c\u0018J\u001c<bY&$7)Y:u\u0005\u0016$x/Z3o\u001dVlWM]5d\u0003:$G+[7fgR\fW\u000e\u001d'uu\"\u0012Q(\n\u0005\u0006\u0003\u0002!\t!H\u0001)i\u0016\u001c\u0018J\u001c<bY&$7)Y:u\u0005\u0016$x/Z3o\u001dVlWM]5d\u0003:$G+[7fgR\fW\u000e\u001d\u0015\u0003\u0001\u0016BQ\u0001\u0012\u0001\u0005\u0002u\tq\u0003^3tiRKW.Z%oi\u0016\u0014h/\u00197DCN$\u0018N\\4)\u0005\r+\u0003\"B$\u0001\t\u0003i\u0012a\u0006;fgR$\u0016.\\3Q_&tGoQ8na\u0006\u0014\u0018n]8oQ\t1U\u0005C\u0003K\u0001\u0011\u0005Q$\u0001\u000euKN$H+[7f\u0013:$XM\u001d<bY\u0006\u0013\u0018\u000e\u001e5nKRL7\r\u000b\u0002JK!)Q\n\u0001C\u0001;\u0005!B/Z:u'\u0016dWm\u0019;Ok2dg+\u00197vKND#\u0001T\u0013\t\u000bA\u0003A\u0011A\u000f\u0002-Q,7\u000f\u001e+f[B|'/\u00197Ok2dg+\u00197vKND#aT\u0013\t\u000bM\u0003A\u0011A\u000f\u0002\u001dQ,7\u000f\u001e#bi\u00164uN]7bi\"\u0012!+\n\u0005\u0006-\u0002!\t!H\u0001\u0017i\u0016\u001cH\u000fR1uK\u001a{'/\\1u'\"\fgn\u001a5bS\"\u0012Q+\n\u0005\u00063\u0002!\t!H\u0001\u0019i\u0016\u001cH\u000fR1uK\u001a{'/\\1u\u0019>\u001c\u0018I\\4fY\u0016\u001c\bF\u0001-&\u0011\u0015a\u0006\u0001\"\u0001\u001e\u0003=!Xm\u001d;ECR,\u0017I\u001c3US6,\u0007FA.&\u0011\u0015y\u0006\u0001\"\u0001\u001e\u0003Q!Xm\u001d;UK6\u0004xN]1m'\"\fgn\u001a5bS\"\u0012a,\n\u0005\u0006E\u0002!\t!H\u0001\u001bi\u0016\u001cH\u000fR1zY&<\u0007\u000e^*bm&tw\rV5nKj{g.\u001a\u0015\u0003C\u0016BQ!\u001a\u0001\u0005\u0002u\t1\u0004^3ti\"{WO]+oSR\u0014\u0016M\\4p_:$\u0016.\\3[_:,\u0007F\u00013&\u0011\u0015A\u0007\u0001\"\u0001\u001e\u0003E!Xm\u001d;Ok2d\u0017M\u00197f\u0007\u0006\u001cXm\u001d\u0015\u0003O\u0016BQa\u001b\u0001\u0005\u0002u\tA\u0003^3ti&sg/\u00197jI&s\u0007/\u001e;DCN,\u0007F\u00016&\u0011\u0015q\u0007\u0001\"\u0001\u001e\u0003\u0005\"Xm\u001d;UsB,\u0017J\u001c4fe\u0016t7-Z,ji\"LeN^1mS\u0012Le\u000e];uQ\tiW\u0005C\u0003r\u0001\u0011\u0005Q$A\u0007uKN$8i\u001c8wKJ$HK\u0017\u0015\u0003a\u0016BQ\u0001\u001e\u0001\u0005\u0002u\t\u0001\u0003^3ti\u001a\u0013x.\\+oSb$\u0016.\\3)\u0005M,\u0003\"B<\u0001\t\u0003i\u0012a\u0006;fgR4%o\\7V]&DH+[7f\u0013:$vn[=pQ\t1X\u0005C\u0003{\u0001\u0011\u0005Q$A\tuKN$XK\\5y)&lWm\u001d;b[BD#!_\u0013\t\u000bu\u0004A\u0011A\u000f\u00021Q,7\u000f^+oSb$\u0016.\\3ti\u0006l\u0007/\u00138U_.Lx\u000e\u000b\u0002}K!1\u0011\u0011\u0001\u0001\u0005\u0002u\t!\u0004^3ti\"Kw\r\u001b)sK\u000eL7/[8o)&lWm\u001d;b[BD#a`\u0013\t\r\u0005\u001d\u0001\u0001\"\u0001\u001e\u0003i!Xm\u001d;U_RKW.Z:uC6\u0004H\n\u001e>TQ\u0006tw\r[1jQ\r\t)!\n\u0005\u0007\u0003\u001b\u0001A\u0011A\u000f\u0002+Q,7\u000f\u001e+p)&lWm\u001d;b[BdEO_+U\u0007\"\u001a\u00111B\u0013\t\r\u0005M\u0001\u0001\"\u0001\u001e\u0003u!Xm\u001d;C_VtG-\u0019:z\r>\u0014Hk\u001c+j[\u0016\u001cH/Y7q\u0019RT\bfAA\tK!1\u0011\u0011\u0004\u0001\u0005\u0002u\t\u0011\u0004^3ti&sg/\u00197jIR{G+[7fgR\fW\u000e\u001d'uu\"\u001a\u0011qC\u0013\t\r\u0005}\u0001\u0001\"\u0001\u001e\u0003E!Xm\u001d;US6,7\u000f^1na\u0012KgM\u001a\u0015\u0004\u0003;)\u0003BBA\u0013\u0001\u0011\u0005Q$\u0001\u000euKN$H+[7fgR\fW\u000e\u001d'uu\u0006\u0013\u0018\u000e\u001e5nKRL7\rK\u0002\u0002$\u0015Ba!a\u000b\u0001\t\u0003i\u0012!\t;fgRLeN^1mS\u0012$\u0016.\\3ti\u0006l\u0007\u000f\u0014;{\u0003JLG\u000f[7fi&\u001c\u0007fAA\u0015K!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0012\u0001\u0003;fgR$\u0015\r^1\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\u0002\"A\u0003usB,7/\u0003\u0003\u0002@\u0005e\"a\u0001*po\"9\u00111\t\u0001\u0005B\u0005\u0015\u0013\u0001\u0004;fgR$\u0015\r^1UsB,WCAA$!\u0011\tI%!\u0014\u000e\u0005\u0005-#bAA\u001e\r%!\u0011qJA&\u0005!!\u0015\r^1UsB,\u0007bBA*\u0001\u0011\u0005\u0013QK\u0001\u0014G>tG/Y5og2+w-Y2z)f\u0004Xm]\u000b\u0003\u0003/\u00022aHA-\u0013\r\tY\u0006\t\u0002\b\u0005>|G.Z1o\u0001")
public class TemporalTypesTest
extends ExpressionTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("f0");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("f1");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("f2");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("f9");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("f10");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("f7");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("f8");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("f3");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("f4");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("f5");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("f6");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("f11");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("f12");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("f13");

    @Test
    public void testTimePointLiterals() {
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1990-10-14").toDate(), "DATE '1990-10-14'", "1990-10-14");
        this.testTableApi(package$.MODULE$.localDate2Literal(DateTimeTestUtil$.MODULE$.localDate("2040-09-11")), "2040-09-11");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1500-04-30").cast(DataTypes.DATE()), "CAST('1500-04-30' AS DATE)", "1500-04-30");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("15:45:59").toTime(), "TIME '15:45:59'", "15:45:59");
        this.testTableApi(package$.MODULE$.localTime2Literal(DateTimeTestUtil$.MODULE$.localTime("00:00:00")), "00:00:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1:30:00").cast(DataTypes.TIME()), "CAST('1:30:00' AS TIME)", "01:30:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1990-10-14 23:00:00.123").toTimestamp(), "TIMESTAMP '1990-10-14 23:00:00.123'", "1990-10-14 23:00:00.123");
        this.testTableApi(package$.MODULE$.localDateTime2Literal(DateTimeTestUtil$.MODULE$.localDateTime("2040-09-11 00:00:00.000")), "2040-09-11 00:00:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1500-04-30 12:00:00").cast(DataTypes.TIMESTAMP((int)3)), "CAST('1500-04-30 12:00:00' AS TIMESTAMP(3))", "1500-04-30 12:00:00.000");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.123456789'", "1500-04-30 12:00:00.123456789");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.12345678'", "1500-04-30 12:00:00.12345678");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.123456'", "1500-04-30 12:00:00.123456");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.1234'", "1500-04-30 12:00:00.1234");
        this.testSqlApi("CAST('1500-04-30 12:00:00.123456789' AS TIMESTAMP(9))", "1500-04-30 12:00:00.123456789");
        this.testSqlApi("CAST('1500-04-30 12:00:00.123456789' AS TIMESTAMP)", "1500-04-30 12:00:00.123456");
        this.testSqlApi("CAST('1999-9-10 05:20:10.123456' AS TIMESTAMP)", "1999-09-10 05:20:10.123456");
        this.testSqlApi("CAST('1999-9-10' AS TIMESTAMP)", "1999-09-10 00:00:00.000000");
    }

    @Test
    public void testTimeIntervalLiterals() {
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(1).year(), "INTERVAL '1' YEAR", "+1-00");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(1).month(), "INTERVAL '1' MONTH", "+0-01");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(12).days(), "INTERVAL '12' DAY", "+12 00:00:00.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(1).hour(), "INTERVAL '1' HOUR", "+0 01:00:00.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(3).minutes(), "INTERVAL '3' MINUTE", "+0 00:03:00.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(3).seconds(), "INTERVAL '3' SECOND", "+0 00:00:03.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(3).millis(), "INTERVAL '0.003' SECOND", "+0 00:00:00.003");
    }

    @Test
    public void testTimePointInput() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$1), "f0", "1990-10-14");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$2), "f1", "10:20:45");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$3), "f2", "1990-10-14 10:20:45.123");
    }

    @Test
    public void testTimeIntervalInput() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$4), "f9", "+2-00");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$5), "f10", "+0 00:00:12.000");
    }

    @Test
    public void testTimePointCasting() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.TIMESTAMP((int)3)), "CAST(f0 AS TIMESTAMP(3))", "1990-10-14 00:00:00.000");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.TIMESTAMP((int)3)), "CAST(f1 AS TIMESTAMP(3))", "1970-01-01 10:20:45.000");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.DATE()), "CAST(f2 AS DATE)", "1990-10-14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.TIME()), "CAST(f2 AS TIME)", "10:20:45");
    }

    @Test
    public void testTimestampLtzCastInUTC() {
        this.config().setLocalTimeZone(ZoneId.of("UTC"));
        this.testSqlApi("CAST(f0 AS TIMESTAMP_LTZ(3))", "1990-10-14 00:00:00.000");
        this.testSqlApi("CAST(f1 AS TIMESTAMP_LTZ(3))", "1970-01-01 10:20:45.000");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIME)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "01:02:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DATE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14");
    }

    @Test
    public void testTimestampLtzCastInShanghai() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testSqlApi("CAST(f0 AS TIMESTAMP_LTZ(3))", "1990-10-14 00:00:00.000");
        this.testSqlApi("CAST(f1 AS TIMESTAMP_LTZ(3))", "1970-01-01 10:20:45.000");
        this.testSqlApi("CAST(f2 AS TIMESTAMP_LTZ(3))", "1990-10-14 10:20:45.123");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIME)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "01:02:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DATE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIMESTAMP(3))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14 01:02:03.000");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIMESTAMP_LTZ(3))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:00:01.123456")})), "1970-01-01 08:00:01.123");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIMESTAMP_LTZ(6))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:00:01.123456")})), "1970-01-01 08:00:01.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TIMESTAMP_LTZ(9))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:00:01.123456")})), "1970-01-01 08:00:01.123456000");
    }

    @Test
    public void tesInvalidCastBetweenNumericAndTimestampLtz() {
        String castFromTimestampLtzExceptionMsg = "The cast conversion from TIMESTAMP_LTZ type to NUMERIC type is not allowed.";
        String castToTimestampLtzExceptionMsg = "The cast conversion from NUMERIC type to TIMESTAMP_LTZ type is not allowed, it's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead.";
        this.testExpectedSqlException("CAST(CAST(100 AS TINYINT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100 AS SMALLINT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(100 AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100 AS BIGINT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100.01 AS FLOAT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100.123 AS DOUBLE) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100.1234 as DECIMAL(38, 18)) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TINYINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS SMALLINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS INT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS FLOAT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DOUBLE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS DECIMAL(38, 3))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 08:02:03.123")})), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
    }

    @Test
    public void tesInvalidCastBetweenNumericAndTimestamp() {
        String castFromTimestampExceptionMsg = "The cast conversion from TIMESTAMP type to NUMERIC type is not allowed, it's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead.";
        String castToTimestampExceptionMsg = "The cast conversion from NUMERIC type to TIMESTAMP type is not allowed, it's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds.";
        this.testExpectedSqlException("CAST(CAST(123 as TINYINT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS SMALLINT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS INT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS BIGINT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS FLOAT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS DOUBLE) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 as DECIMAL(5, 2)) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS TINYINT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS SMALLINT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS INT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS BIGINT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS FLOAT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS DOUBLE)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS DECIMAL(5, 2))", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
    }

    @Test
    public void testTimeIntervalCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$6).cast(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), "+1000-00");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).cast(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MINUTE())), "+16979 07:23:33.000");
    }

    @Test
    public void testTimePointComparison() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(package$.MODULE$.symbol2FieldExpression(symbol$8)), "f0 < f3", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(package$.MODULE$.symbol2FieldExpression(symbol$9)), "f0 < f4", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$less(package$.MODULE$.symbol2FieldExpression(symbol$10)), "f1 < f5", "false");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.TIMESTAMP((int)3))).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$3)), "CAST(f0 AS TIMESTAMP(9)) <> f2", "true");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.TIMESTAMP((int)9))).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$11)), "CAST(f0 AS TIMESTAMP(9)) = f6", "true");
    }

    @Test
    public void testTimeIntervalArithmetic() {
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(12).months()).$less((Expression)package$.MODULE$.LiteralIntExpression(24).months()), "INTERVAL '12' MONTH < INTERVAL '24' MONTH", "true");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).years()).$eq$eq$eq((Expression)package$.MODULE$.LiteralIntExpression(8).years()), "INTERVAL '8' YEAR = INTERVAL '8' YEAR", "true");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).millis()).$greater((Expression)package$.MODULE$.LiteralIntExpression(10).millis()), "INTERVAL '0.008' SECOND > INTERVAL '0.010' SECOND", "false");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).millis()).$eq$eq$eq((Expression)package$.MODULE$.LiteralIntExpression(8).millis()), "INTERVAL '0.008' SECOND = INTERVAL '0.008' SECOND", "true");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).years()).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).months()), "INTERVAL '8' YEAR + INTERVAL '10' MONTH", "+8-10");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(2).years()).$minus((Expression)package$.MODULE$.LiteralIntExpression(12).months()), "INTERVAL '2' YEAR - INTERVAL '12' MONTH", "+1-00");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(-2).years(), "-INTERVAL '2' YEAR", "-2-00");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).hours()).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).minutes())).$plus((Expression)package$.MODULE$.LiteralIntExpression(12).seconds())).$plus((Expression)package$.MODULE$.LiteralIntExpression(5).millis()), "INTERVAL '8' HOUR + INTERVAL '10' MINUTE + INTERVAL '12.005' SECOND", "+0 08:10:12.005");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(1).minute()).$minus((Expression)package$.MODULE$.LiteralIntExpression(10).seconds()), "INTERVAL '1' MINUTE - INTERVAL '10' SECOND", "+0 00:00:50.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(-10).seconds(), "-INTERVAL '10' SECOND", "-0 00:00:10.000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).days()), "f0 + INTERVAL '2' DAY", "1990-10-16");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(30).days()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$1)), "INTERVAL '30' DAY + f0", "1990-11-13");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).months()), "f0 + INTERVAL '2' MONTH", "1990-12-14");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(2).months()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$1)), "INTERVAL '2' MONTH + f0", "1990-12-14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$plus((Expression)package$.MODULE$.LiteralIntExpression(12).hours()), "f1 + INTERVAL '12' HOUR", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(12).hours()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$2)), "INTERVAL '12' HOUR + f1", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).days())).$plus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "f2 + INTERVAL '10 00:00:00.004' DAY TO SECOND", "1990-10-24 10:20:45.127");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(10).days()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$3))).$plus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "INTERVAL '10 00:00:00.004' DAY TO SECOND + f2", "1990-10-24 10:20:45.127");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).years()), "f2 + INTERVAL '10' YEAR", "2000-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(10).years()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$3)), "INTERVAL '10' YEAR + f2", "2000-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).days()), "f0 - INTERVAL '2' DAY", "1990-10-12");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-30).days()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$1)), "INTERVAL '-30' DAY + f0", "1990-09-14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).months()), "f0 - INTERVAL '2' MONTH", "1990-08-14");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-2).months()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$1)), "-INTERVAL '2' MONTH + f0", "1990-08-14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$minus((Expression)package$.MODULE$.LiteralIntExpression(12).hours()), "f1 - INTERVAL '12' HOUR", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-12).hours()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$2)), "INTERVAL '-12' HOUR + f1", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$minus((Expression)package$.MODULE$.LiteralIntExpression(10).days())).$minus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "f2 - INTERVAL '10 00:00:00.004' DAY TO SECOND", "1990-10-04 10:20:45.119");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-10).days()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$3))).$minus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "INTERVAL '-10 00:00:00.004' DAY TO SECOND + f2", "1990-10-04 10:20:45.119");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$minus((Expression)package$.MODULE$.LiteralIntExpression(10).years()), "f2 - INTERVAL '10' YEAR", "1980-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-10).years()).$plus(package$.MODULE$.symbol2FieldExpression(symbol$3)), "INTERVAL '-10' YEAR + f2", "1980-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).cast((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Integer.class))).unary_$minus(), "-CAST(f9 AS INTERVAL MONTH)", "-2-00");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).cast((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).bridgedTo(Long.class))).unary_$minus(), "-CAST(f10 AS INTERVAL SECOND(3))", "-0 00:00:12.000");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$plus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f0 + INTERVAL '2' DAY + INTERVAL '1' MONTH", "1990-11-16");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$minus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f0 - INTERVAL '2' DAY - INTERVAL '1' MONTH", "1990-09-12");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$plus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f2 + INTERVAL '2' DAY + INTERVAL '1' MONTH", "1990-11-16 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$minus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f2 - INTERVAL '2' DAY - INTERVAL '1' MONTH", "1990-09-12 10:20:45.123");
    }

    @Test
    public void testSelectNullValues() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$12), "f11", "null");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$13), "f12", "null");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$14), "f13", "null");
    }

    @Test
    public void testTemporalNullValues() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$14).extract(TimeIntervalUnit.HOUR), "extract(HOUR FROM f13)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$14).floor(TimeIntervalUnit.HOUR), "FLOOR(f13 TO HOUR)", "null");
        this.testSqlApi("TO_TIMESTAMP(SUBSTRING('', 2, -1))", "null");
        this.testSqlApi("TO_TIMESTAMP(f14, 'yyyy-mm-dd')", "null");
    }

    @Test
    public void testDateFormat() {
        this.config().setLocalTimeZone(ZoneId.of("UTC"));
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '2018-03-14 01:02:03.123456', 'yyyy/MM/dd HH:mm:ss.SSSSSS')", "2018/03/14 01:02:03.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14 01:02:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss.SSSSSS')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03.123456")})), "2018-03-14 01:02:03.123456");
    }

    @Test
    public void testDateFormatShanghai() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '2018-03-14 01:02:03.123456', 'yyyy/MM/dd HH:mm:ss.SSSSSS')", "2018/03/14 01:02:03.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14 01:02:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss.SSSSSS')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03.123456")})), "2018-03-14 01:02:03.123456");
    }

    @Test
    public void testDateFormatLosAngeles() {
        this.config().setLocalTimeZone(ZoneId.of("America/Los_Angeles"));
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '2018-03-14 01:02:03.123456', 'yyyy/MM/dd HH:mm:ss.SSSSSS')", "2018/03/14 01:02:03.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14 01:02:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss.SSSSSS')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03.123456")})), "2018-03-14 01:02:03.123456");
    }

    @Test
    public void testDateAndTime() {
        this.testSqlApi("DATE '2018-03-14'", "2018-03-14");
        this.testSqlApi("TIME '19:01:02.123'", "19:01:02");
        this.testSqlApi("CAST('12:44:31' AS TIME)", "12:44:31");
        this.testSqlApi("CAST('2018-03-18' AS DATE)", "2018-03-18");
        this.testSqlApi("TIME '12:44:31'", "12:44:31");
        this.testSqlApi("TO_DATE('2018-03-18')", "2018-03-18");
        this.testSqlApi("EXTRACT(HOUR FROM TIME '06:07:08')", "6");
        this.testSqlApi("EXTRACT(MINUTE FROM TIME '06:07:08')", "7");
        this.testSqlApi("EXTRACT(HOUR FROM CAST('06:07:08' AS TIME))", "6");
        this.testSqlApi("EXTRACT(DAY FROM CAST('2018-03-18' AS DATE))", "18");
        this.testSqlApi("EXTRACT(DAY FROM DATE '2018-03-18')", "18");
        this.testSqlApi("EXTRACT(DAY FROM TO_DATE('2018-03-18'))", "18");
        this.testSqlApi("EXTRACT(MONTH FROM TO_DATE('2018-01-01'))", "1");
        this.testSqlApi("EXTRACT(YEAR FROM TO_DATE('2018-01-01'))", "2018");
        this.testSqlApi("EXTRACT(QUARTER FROM TO_DATE('2018-01-01'))", "1");
    }

    @Test
    public void testTemporalShanghai() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testSqlApi(this.timestampLtz("2018-03-14 19:01:02.123"), "2018-03-14 19:01:02.123");
        this.testSqlApi(this.timestampLtz("2018-03-14 19:00:00.010"), "2018-03-14 19:00:00.010");
        this.testSqlApi(new StringBuilder().append((Object)this.timestampLtz("2018-03-14 19:00:00.010")).append((Object)" > ").append((Object)"f25").toString(), "true");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03.123456789", 9)})), "2018-03-14 01:02:03.123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03.123456", 6)})), "2018-03-14 01:02:03.123456");
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", 'yyyy-MM-dd HH:mm:ss')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03")})), "2018-03-14 01:02:03");
        String extractT1 = this.timestampLtz("2018-03-20 07:59:59");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(DAY FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extractT1})), "20");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(HOUR FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extractT1})), "7");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(MONTH FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extractT1})), "3");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(YEAR FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extractT1})), "2018");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi("EXTRACT(HOUR FROM TIME '01:02:03')", "1");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO MINUTE)", "12:44:00");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO HOUR)", "12:00:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO MINUTE)", "12:45:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO HOUR)", "13:00:00");
        this.testSqlApi("FLOOR( DATE '2021-02-27' TO WEEK)", "2021-02-21");
        this.testSqlApi("FLOOR( DATE '2021-03-01' TO WEEK)", "2021-02-28");
        this.testSqlApi("CEIL( DATE '2021-02-27' TO WEEK)", "2021-02-28");
        this.testSqlApi("CEIL( DATE '2021-03-01' TO WEEK)", "2021-03-07");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-03-20 06:44:31' TO HOUR)", "2018-03-20 06:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-03-20 06:44:31' TO DAY)", "2018-03-20 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-03-20 00:00:00' TO DAY)", "2018-03-20 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2021-02-27 00:00:00' TO WEEK)", "2021-02-21 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2021-03-01 00:00:00' TO WEEK)", "2021-02-28 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-04-01 06:44:31' TO MONTH)", "2018-04-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-01-01 06:44:31' TO MONTH)", "2018-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-20 06:44:31' TO HOUR)", "2018-03-20 07:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-20 06:00:00' TO HOUR)", "2018-03-20 06:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-20 06:44:31' TO DAY)", "2018-03-21 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-01 00:00:00' TO DAY)", "2018-03-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-31 00:00:01' TO DAY)", "2018-04-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2021-02-27 00:00:00' TO WEEK)", "2021-02-28 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2021-03-01 00:00:00' TO WEEK)", "2021-03-07 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-01 21:00:01' TO MONTH)", "2018-03-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-01 00:00:00' TO MONTH)", "2018-03-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-12-02 00:00:00' TO MONTH)", "2019-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-01 21:00:01' TO YEAR)", "2018-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-02 21:00:01' TO YEAR)", "2019-01-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-20 06:44:31")})), "2018-03-20 06:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-20 06:44:31")})), "2018-03-20 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-20 00:00:00")})), "2018-03-20 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO WEEK)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2021-02-27 00:00:00")})), "2021-02-21 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO WEEK)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2021-03-01 00:00:00")})), "2021-02-28 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO MONTH)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-04-01 06:44:31")})), "2018-04-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO MONTH)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-01-01 06:44:31")})), "2018-01-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-20 06:44:31")})), "2018-03-20 07:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-20 06:00:00")})), "2018-03-20 06:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-20 06:44:31")})), "2018-03-21 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-1 00:00:00")})), "2018-03-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO DAY)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-31 00:00:01")})), "2018-04-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO WEEK)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2021-02-27 00:00:00")})), "2021-02-28 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO WEEK)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2021-03-01 00:00:00")})), "2021-03-07 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO MONTH)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-01 21:00:01")})), "2018-03-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO MONTH)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-01 00:00:00")})), "2018-03-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO MONTH)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-12-02 00:00:00")})), "2019-01-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO YEAR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-01-01 21:00:01")})), "2018-01-01 00:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO YEAR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-01-02 21:00:01")})), "2019-01-01 00:00:00");
        this.testSqlApi("QUARTER(DATE '2016-04-12')", "2");
        this.testSqlApi("(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "true");
        this.testSqlApi("CEIL(f17 TO HOUR)", "1990-10-14 08:00:00.000");
        this.testSqlApi("FLOOR(f17 TO DAY)", "1990-10-14 00:00:00.000");
        this.testSqlApi("TIMESTAMPADD(HOUR, +8, TIMESTAMP '2017-11-29 10:58:58.998')", "2017-11-29 18:58:58.998");
    }

    @Test
    public void testDaylightSavingTimeZone() {
        this.config().setLocalTimeZone(ZoneId.of("MET"));
        this.testSqlApi("UNIX_TIMESTAMP('2005-03-27 03:00:00')", "1111885200");
        this.testSqlApi("UNIX_TIMESTAMP('2005-03-27 02:00:00')", "1111885200");
        this.testSqlApi("FROM_UNIXTIME(1111885200)", "2005-03-27 03:00:00");
    }

    @Test
    public void testHourUnitRangoonTimeZone() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Rangoon"));
        String t1 = this.timestampLtz("2018-03-20 06:10:31");
        String t2 = this.timestampLtz("2018-03-20 06:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(HOUR FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t1})), "6");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t1})), "2018-03-20 06:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FLOOR(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t2})), "2018-03-20 06:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t2})), "2018-03-20 06:00:00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CEIL(", " TO HOUR)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t1})), "2018-03-20 07:00:00");
    }

    @Test
    public void testNullableCases() {
        this.testSqlApi("CONVERT_TZ(cast(NULL as varchar), 'UTC', 'Asia/Shanghai')", this.nullable());
        this.testSqlApi("DATE_FORMAT(cast(NULL as varchar), 'yyyy/MM/dd HH:mm:ss')", this.nullable());
        this.testSqlApi("FROM_UNIXTIME(cast(NULL as bigInt))", this.nullable());
        this.testSqlApi("TO_DATE(cast(NULL as varchar))", this.nullable());
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.nullOf(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(cast(NULL as BIGINT), 0)", this.nullable());
    }

    @Test
    public void testInvalidInputCase() {
        String invalidStr = "invalid value";
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT('", "', 'yyyy/MM/dd HH:mm:ss')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), this.nullable());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP('", "', 'yyyy-mm-dd')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), this.nullable());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_DATE('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), this.nullable());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONVERT_TZ('", "', 'UTC', 'Asia/Shanghai')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), this.nullable());
    }

    @Test
    public void testTypeInferenceWithInvalidInput() {
        String invalidStr = "invalid value";
        Seq cases = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT('", "', 'yyyy/MM/dd HH:mm:ss')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP('", "', 'yyyy-mm-dd')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_DATE('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONVERT_TZ('", "', 'UTC', 'Asia/Shanghai')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidStr}))}));
        cases.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TemporalTypesTest $outer;

            public final void apply(String caseExpr) {
                this.$outer.testSqlApi(caseExpr, "null");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testConvertTZ() {
        this.testSqlApi("CONVERT_TZ('2018-03-14 11:00:00', 'UTC', 'Asia/Shanghai')", "2018-03-14 19:00:00");
    }

    @Test
    public void testFromUnixTime() {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String fmt2 = "yyyy-MM-dd HH:mm:ss.SSS";
        SimpleDateFormat sdf2 = new SimpleDateFormat(fmt2, Locale.US);
        String fmt3 = "yy-MM-dd HH-mm-ss";
        SimpleDateFormat sdf3 = new SimpleDateFormat(fmt3, Locale.US);
        this.testSqlApi("from_unixtime(f21)", sdf1.format(new Timestamp(44000L)));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f21, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt2})), sdf2.format(new Timestamp(44000L)));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f21, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt3})), sdf3.format(new Timestamp(44000L)));
        this.testSqlApi("from_unixtime(f22)", sdf1.format(new Timestamp(3000L)));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f22, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt2})), sdf2.format(new Timestamp(3000L)));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f22, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt3})), sdf3.format(new Timestamp(3000L)));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f26, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt2})), sdf2.format(new Timestamp(124000L)));
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f26, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt3})), sdf3.format(new Timestamp(124000L)));
        this.testSqlApi("from_unixtime(cast(null as int))", "null");
    }

    @Test
    public void testFromUnixTimeInTokyo() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Tokyo"));
        String fmt = "yy-MM-dd HH-mm-ss";
        this.testSqlApi("from_unixtime(f21)", "1970-01-01 09:00:44");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f21, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt})), "70-01-01 09-00-44");
        this.testSqlApi("from_unixtime(f22)", "1970-01-01 09:00:03");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(f22, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt})), "70-01-01 09-00-03");
    }

    @Test
    public void testUnixTimestamp() {
        Timestamp ts1 = Timestamp.valueOf("2015-07-24 10:00:00.3");
        Timestamp ts2 = Timestamp.valueOf("2015-07-25 02:02:02.2");
        String s1 = "2015/07/24 10:00:00.5";
        String s2 = "2015/07/25 02:02:02.6";
        String ss1 = "2015-07-24 10:00:00";
        String ss2 = "2015-07-25 02:02:02";
        String fmt = "yyyy/MM/dd HH:mm:ss.S";
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UNIX_TIMESTAMP('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ss1})), ((Object)BoxesRunTime.boxToLong((long)(ts1.getTime() / 1000L))).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UNIX_TIMESTAMP('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ss2})), ((Object)BoxesRunTime.boxToLong((long)(ts2.getTime() / 1000L))).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UNIX_TIMESTAMP('", "', '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s1, fmt})), ((Object)BoxesRunTime.boxToLong((long)(ts1.getTime() / 1000L))).toString());
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UNIX_TIMESTAMP('", "', '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s2, fmt})), ((Object)BoxesRunTime.boxToLong((long)(ts2.getTime() / 1000L))).toString());
    }

    @Test
    public void testUnixTimestampInTokyo() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Tokyo"));
        this.testSqlApi("UNIX_TIMESTAMP('2015-07-24 10:00:00')", "1437699600");
        this.testSqlApi("UNIX_TIMESTAMP('2015/07/24 10:00:00.5', 'yyyy/MM/dd HH:mm:ss.S')", "1437699600");
    }

    @Test
    public void testHighPrecisionTimestamp() {
        this.testSqlApi("EXTRACT(MILLISECOND FROM TIMESTAMP '1970-01-01 00:00:00.123456789')", "123");
        this.testSqlApi("EXTRACT(MICROSECOND FROM TIMESTAMP '1970-01-01 00:00:00.123456789')", "123456");
        this.testSqlApi("EXTRACT(NANOSECOND FROM TIMESTAMP '1970-01-01 00:00:00.123456789')", "123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(MILLISECOND FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789", 9)})), "123");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(MICROSECOND FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789", 9)})), "123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXTRACT(NANOSECOND FROM ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789", 9)})), "123456789");
        this.testSqlApi("TO_TIMESTAMP('1970-01-01 00:00:00.123456789')", "1970-01-01 00:00:00.123456789");
        this.testSqlApi("TO_TIMESTAMP('1970-01-01 00:00:00.12345', 'yyyy-MM-dd HH:mm:ss.SSSSS')", "1970-01-01 00:00:00.12345");
        this.testSqlApi("TO_TIMESTAMP('abc')", "null");
        this.testSqlApi("TO_TIMESTAMP('2000020210', 'yyyyMMddHH')", "2000-02-02 10:00:00.000");
        this.testSqlApi("TO_TIMESTAMP('20000202 59:59.1234567', 'yyyyMMdd mm:ss.SSSSSSS')", "2000-02-02 00:59:59.1234567");
        this.testSqlApi("TO_TIMESTAMP('1234567', 'SSSSSSS')", "1970-01-01 00:00:00.1234567");
        this.testSqlApi("CAST(TIMESTAMP '1970-01-01 00:00:00.123456789' AS TIMESTAMP(6))", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(TIMESTAMP '1970-01-01 00:00:00.123456789' AS TIMESTAMP(9))", "1970-01-01 00:00:00.123456789");
        this.testSqlApi("CAST(TIMESTAMP '1970-01-01 00:00:00.123456789' AS TIMESTAMP)", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(TO_TIMESTAMP('1970-01-01 00:00:00.123456789') AS TIMESTAMP(0))", "1970-01-01 00:00:00");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789", 9)}))).append((Object)"AS TIMESTAMP(6) WITH LOCAL TIME ZONE)").toString(), "1970-01-01 00:00:00.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(f23 AS TIMESTAMP(6))"})).s((Seq)Nil$.MODULE$), "1970-01-01 00:00:00.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(f23 AS TIMESTAMP(6) WITH LOCAL TIME ZONE)"})).s((Seq)Nil$.MODULE$), "1970-01-01 00:00:00.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(f24 AS TIMESTAMP(6))"})).s((Seq)Nil$.MODULE$), "1970-01-01 00:00:00.123456");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(f24 AS TIMESTAMP(6) WITH LOCAL TIME ZONE)"})).s((Seq)Nil$.MODULE$), "1970-01-01 00:00:00.123456");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' - INTERVAL '1' MONTH", "1970-01-01 00:00:00.123456789");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' + INTERVAL '1' MONTH", "1970-03-01 00:00:00.123456789");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' - INTERVAL '1' SECOND", "1970-01-31 23:59:59.123456789");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' + INTERVAL '1' SECOND", "1970-02-01 00:00:01.123456789");
        this.testSqlApi("TIMESTAMP '1970-01-01 00:00:00.123456789' > TIMESTAMP '1970-01-01 00:00:00.123456788'", "true");
        this.testSqlApi("TIMESTAMP '1970-01-01 00:00:00.123456788' < TIMESTAMP '1970-01-01 00:00:00.123456789'", "true");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789", 9)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456788", 9)}))).toString(), "true");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456788", 9)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789", 9)}))).toString(), "true");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '1970-01-01 00:00:00.123456789', 'yyyy/MM/dd HH:mm:ss.SSSSSSSSS')", "1970/01/01 00:00:00.123456789");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_FORMAT(", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("2018-03-14 01:02:03.123456789", 9)}))).append((Object)"'yyyy-MM-dd HH:mm:ss.SSSSSSSSS')").toString(), "2018-03-14 01:02:03.123456789");
    }

    @Test
    public void testToTimestampLtzShanghai() {
        this.config().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(100).cast(DataTypes.TINYINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100 AS TINYINT), 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(100).cast(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100 AS BIGINT), 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(100.01).cast(DataTypes.FLOAT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100.01 AS FLOAT), 0)", "1970-01-01 08:01:40.010");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(100.123).cast(DataTypes.DOUBLE()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100.123 AS DOUBLE), 0)", "1970-01-01 08:01:40.123");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(100).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(-100).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(-100, 0)", "1970-01-01 07:58:20.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(1234), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(1234, 3)", "1970-01-01 08:00:01.234");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.double2Literal(0.01), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(0.01, 3)", "1970-01-01 08:00:00.000");
    }

    @Test
    public void testToTimestampLtzUTC() {
        this.config().setLocalTimeZone(ZoneId.of("UTC"));
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 00:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 00:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(1234), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(1234, 3)", "1970-01-01 00:00:01.234");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(-100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(-100, 0)", "1969-12-31 23:58:20.000");
    }

    @Test
    public void testBoundaryForToTimestampLtz() {
        this.config().setLocalTimeZone(ZoneId.of("UTC"));
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(Integer.MIN_VALUE).cast(DataTypes.INT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(", " AS INTEGER), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)})), "1901-12-13 20:45:52.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(Integer.MAX_VALUE).cast(DataTypes.INT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(", " AS INTEGER), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)})), "2038-01-19 03:14:07.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(-128).cast(DataTypes.TINYINT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(-128 AS TINYINT), 0)"})).s((Seq)Nil$.MODULE$), "1969-12-31 23:57:52.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(127).cast(DataTypes.TINYINT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(127 AS TINYINT), 0)"})).s((Seq)Nil$.MODULE$), "1970-01-01 00:02:07.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralLongExpression(Long.MIN_VALUE).cast(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(", " AS BIGINT), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralLongExpression(Long.MAX_VALUE).cast(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(", " AS BIGINT), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralFloatExpression(-Float.MAX_VALUE).cast(DataTypes.FLOAT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(-", " AS FLOAT), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralFloatExpression(Float.MAX_VALUE).cast(DataTypes.FLOAT()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(", " AS FLOAT), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(-Double.MAX_VALUE).cast(DataTypes.DOUBLE()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(-", " AS DOUBLE), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(Double.MAX_VALUE).cast(DataTypes.DOUBLE()), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(CAST(", " AS DOUBLE), 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(-Double.MAX_VALUE).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(-", ", 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(Double.MAX_VALUE).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(", ", 0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)})), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(-62167219200000L), package$.MODULE$.int2Literal(3)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(-62167219200000, 3)"})).s((Seq)Nil$.MODULE$), "0000-01-01 00:00:00.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(253402300799999L), package$.MODULE$.int2Literal(3)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(253402300799999, 3)"})).s((Seq)Nil$.MODULE$), "9999-12-31 23:59:59.999");
    }

    @Test
    public void testInvalidToTimestampLtz() {
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(-62167219200001L), package$.MODULE$.int2Literal(3)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(-62167219200001, 3)"})).s((Seq)Nil$.MODULE$), "null");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(253402300800000L), package$.MODULE$.int2Literal(3)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TO_TIMESTAMP_LTZ(253402300800000, 3)"})).s((Seq)Nil$.MODULE$), "null");
        this.testExpectedSqlException("TO_TIMESTAMP_LTZ(123)", "Invalid number of arguments to function 'TO_TIMESTAMP_LTZ'. Was expecting 2 arguments", this.testExpectedSqlException$default$3());
        this.testExpectedAllApisException(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(12), package$.MODULE$.int2Literal(1)), "TO_TIMESTAMP_LTZ(12, 1)", "The precision value '1' for function TO_TIMESTAMP_LTZ(numeric, precision) is unsupported, the supported value is '0' for second or '3' for millisecond.", TableException.class);
        this.testExpectedAllApisException(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(1000000000), package$.MODULE$.int2Literal(9)), "TO_TIMESTAMP_LTZ(1000000000, 9)", "The precision value '9' for function TO_TIMESTAMP_LTZ(numeric, precision) is unsupported, the supported value is '0' for second or '3' for millisecond.", TableException.class);
        this.testExpectedSqlException("TO_TIMESTAMP_LTZ('test_string_type', 0)", "Cannot apply 'TO_TIMESTAMP_LTZ' to arguments of type 'TO_TIMESTAMP_LTZ(<CHAR(16)>, <INTEGER>)'. Supported form(s): 'TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>)'", ValidationException.class);
        this.testExpectedTableApiException(package$.MODULE$.toTimestampLtz(package$.MODULE$.string2Literal("test_string_type"), package$.MODULE$.int2Literal(0)), "toTimestampLtz(test_string_type, 0) requires numeric type for the first input, but the actual type 'String'.", this.testExpectedTableApiException$default$3());
        this.testExpectedSqlException("TO_TIMESTAMP_LTZ(123, 'test_string_type')", "Cannot apply 'TO_TIMESTAMP_LTZ' to arguments of type 'TO_TIMESTAMP_LTZ(<INTEGER>, <CHAR(16)>)'. Supported form(s): 'TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>)'", this.testExpectedSqlException$default$3());
        this.testExpectedTableApiException(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(123), package$.MODULE$.string2Literal("test_string_type")), "toTimestampLtz(123, test_string_type) requires numeric type for the second input, but the actual type 'String'.", this.testExpectedTableApiException$default$3());
    }

    @Test
    public void testTimestampDiff() {
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2019-09-01 00:00:00', TIMESTAMP '2020-03-01 00:00:00')", "6");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2019-09-01 00:00:00', TIMESTAMP '2016-08-01 00:00:00')", "-37");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2019-09-01', DATE '2020-03-01')", "6");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2019-09-01', DATE '2016-08-01')", "-37");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2021-01-04 00:00:00', DATE '2021-02-04')", "1");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2020-01-04', TIMESTAMP '2021-02-04 12:00:00')", "13");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2021-01-04 00:00:00', TIME '00:00:00')", "-612");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIME '00:00:00', TIMESTAMP '2021-02-04 12:00:00')", "613");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2021-01-04', TIME '00:00:00')", "-612");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIME '00:00:00', DATE '2021-02-04')", "613");
    }

    @Test
    public void testTimestampLtzArithmetic() {
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " + INTERVAL '1' YEAR"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-02-01 00:00:00.123456789")})), "1971-02-01 00:00:00.123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - INTERVAL '1' MONTH"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-02-01 00:00:00.123456789")})), "1970-01-01 00:00:00.123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " + INTERVAL '1' DAY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-02-01 00:00:00.123456789")})), "1970-02-02 00:00:00.123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - INTERVAL '1' HOUR"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-02-01 00:00:00.123456789")})), "1970-01-31 23:00:00.123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " + INTERVAL '1' MINUTE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-02-01 00:00:00.123456789")})), "1970-02-01 00:01:00.123456789");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - INTERVAL '1' SECOND"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-02-01 00:00:00.123456789")})), "1970-01-31 23:59:59.123456789");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(YEAR, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1971-01-02 01:02:03.123456789")}))).toString(), "1");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(MONTH, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123456789")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1971-01-02 01:02:03.123456789")}))).toString(), "12");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(DAY, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1971-01-02 01:02:03.123")}))).toString(), "366");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(HOUR, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 01:02:03.123")}))).toString(), "1");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(MINUTE, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 01:02:03.123")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00")}))).toString(), "-62");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(SECOND, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:02:03.234")}))).toString(), "123");
        this.testSqlApi(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(SECOND, CAST(null AS TIMESTAMP_LTZ),"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:02:03.234")}))).toString(), "null");
    }

    @Test
    public void testInvalidTimestampLtzArithmetic() {
        String exceptionMsg = "TIMESTAMP_LTZ only supports diff between the same type.";
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(MONTH, ", ", TIME '00:00:01')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")})), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(MONTH, ", ", DATE '1970-01-01')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")})), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(MONTH, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" TIMESTAMP '1970-01-01 00:00:00.123')"})).s((Seq)Nil$.MODULE$)).toString(), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(SECOND, ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" TIME '00:00:00.123')"})).s((Seq)Nil$.MODULE$)).toString(), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(SECOND, ", ", 'test_string_type')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampLtz("1970-01-01 00:00:00.123")})), "Cannot apply 'TIMESTAMPDIFF' to arguments of type 'TIMESTAMPDIFF(<SYMBOL>, <TIMESTAMP_WITH_LOCAL_TIME_ZONE(3)>, <CHAR(16)>)'. Supported form(s): 'TIMESTAMPDIFF(<ANY>, <DATETIME>, <DATETIME>)'", this.testExpectedSqlException$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row testData() {
        void var1_1;
        Row testData = new Row(27);
        testData.setField(0, (Object)DateTimeTestUtil$.MODULE$.localDate("1990-10-14"));
        testData.setField(1, (Object)DateTimeTestUtil$.MODULE$.localTime("10:20:45"));
        testData.setField(2, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 10:20:45.123"));
        testData.setField(3, (Object)DateTimeTestUtil$.MODULE$.localDate("1990-10-13"));
        testData.setField(4, (Object)DateTimeTestUtil$.MODULE$.localDate("1990-10-15"));
        testData.setField(5, (Object)DateTimeTestUtil$.MODULE$.localTime("00:00:00"));
        testData.setField(6, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 00:00:00.0"));
        testData.setField(7, (Object)BoxesRunTime.boxToInteger((int)12000));
        testData.setField(8, (Object)BoxesRunTime.boxToLong((long)1467012213000L));
        testData.setField(9, (Object)BoxesRunTime.boxToInteger((int)24));
        testData.setField(10, (Object)BoxesRunTime.boxToLong((long)12000L));
        testData.setField(11, null);
        testData.setField(12, null);
        testData.setField(13, null);
        testData.setField(14, null);
        testData.setField(15, (Object)BoxesRunTime.boxToLong((long)1467012213L));
        testData.setField(16, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 10:20:45.123").atZone(ZoneId.of("UTC")).toInstant());
        testData.setField(17, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 00:00:00.0").atZone(ZoneId.of("UTC")).toInstant());
        testData.setField(18, (Object)Instant.ofEpochMilli(1521025200000L));
        testData.setField(19, (Object)Instant.ofEpochMilli(1520960523000L));
        testData.setField(20, (Object)Instant.ofEpochMilli(1520827201000L));
        testData.setField(21, (Object)BoxesRunTime.boxToLong((long)44L));
        testData.setField(22, (Object)BoxesRunTime.boxToInteger((int)3));
        testData.setField(23, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456789").atZone(this.config().getLocalTimeZone()).toInstant());
        testData.setField(24, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456789").atZone(this.config().getLocalTimeZone()).toInstant());
        testData.setField(25, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456789").toInstant(ZoneOffset.UTC));
        testData.setField(26, (Object)BoxesRunTime.boxToByte((byte)new Integer(124).byteValue()));
        return var1_1;
    }

    public DataType testDataType() {
        return DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"f2", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f4", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f5", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"f6", (DataType)DataTypes.TIMESTAMP((int)9)), DataTypes.FIELD((String)"f7", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f8", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f9", (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Integer.class))), DataTypes.FIELD((String)"f10", (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).bridgedTo(Long.class))), DataTypes.FIELD((String)"f11", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f12", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"f13", (DataType)DataTypes.TIMESTAMP((int)9)), DataTypes.FIELD((String)"f14", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f15", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f16", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f17", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)), DataTypes.FIELD((String)"f18", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f19", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f20", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f21", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f22", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f23", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f24", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f25", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f26", (DataType)DataTypes.TINYINT())});
    }

    @Override
    public boolean containsLegacyTypes() {
        return false;
    }
}

