/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.MapTypeTestBase;
import org.junit.Test;
import scala.Symbol;
import scala.Symbol$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001#\t)R*\u00199UsB,g+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011!B;uS2\u001c\u0018BA\f\u0015\u0005=i\u0015\r\u001d+za\u0016$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u0003A!Xm\u001d;Xe>twmS3z)f\u0004X\rF\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;)\tu9SF\f\t\u0003Q-j\u0011!\u000b\u0006\u0003U9\tQA[;oSRL!\u0001L\u0015\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\nq\u0006\u0005\u00021g5\t\u0011G\u0003\u00023\u0011\u0005\u0019\u0011\r]5\n\u0005Q\n$a\u0005,bY&$\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007\"\u0002\u001c\u0001\t\u0003y\u0012A\b;fgRLenY8se\u0016\u001cG/T1q)f\u0004XmQ8na\u0006\u0014\u0018n]8oQ\u0011)t%\f\u0018\t\u000be\u0002A\u0011A\u0010\u0002;Q,7\u000f^+ogV\u0004\bo\u001c:uK\u0012\u001cu.\u001c9be&\u001cxN\u001c+za\u0016DC\u0001O\u0014.]!)A\b\u0001C\u0001?\u0005aA/Z:u\u000b6\u0004H/_'ba\"\"1hJ\u0017/\u0011\u0015y\u0004\u0001\"\u0001 \u0003\u0015\"Xm\u001d;V]N,\b\u000f]8si\u0016$W*\u00199J[Bd\u0017nY5u)f\u0004XmQ1tiN\u000bH\u000e\u000b\u0003?O5r\u0003")
public class MapTypeValidationTest
extends MapTypeTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("f2");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("f1");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("f3");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("f6");

    @Test(expected=ValidationException.class)
    public void testWrongKeyType() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$1).at((Object)package$.MODULE$.int2Literal(12)), "f2.at(12)", "f2[12]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testIncorrectMapTypeComparison() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$3)), "f1 === f3", "f1 = f3", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedComparisonType() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$4).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$1)), "f6 !== f2", "f6 != f2", "FAIL");
        this.testSqlApi("f6 <> f2", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testEmptyMap() {
        this.testAllApis(package$.MODULE$.string2Literal("FAIL"), "map()", "MAP[]", "FAIL");
        this.testSqlApi("MAP[]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedMapImplicitTypeCastSql() {
        this.testSqlApi("MAP['k1', 'string', 'k2', 12]", "FAIL");
    }
}

