/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.match;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.plan.logical.MatchRecognize;
import org.apache.flink.table.planner.plan.nodes.exec.spec.MatchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMatch;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMatch;
import org.apache.flink.table.planner.plan.utils.MatchUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u0001\u0003\u0003\u0003y!!\u0007)biR,'O\u001c+sC:\u001cH.\u0019;peR+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\u000b5\fGo\u00195\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\u0011\u0005!Q\u000f^5m\u0013\t)\"C\u0001\u0006UKN$Hj\\4hKJDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000fq\u0001!\u0019!C\u0005;\u0005\tR\r\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\u0016\u0003y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u000bI,H.Z:\u000b\u0005\rb\u0011!\u00026v]&$\u0018BA\u0013!\u0005E)\u0005\u0010]3di\u0016$W\t_2faRLwN\u001c\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0010\u0002%\u0015D\b/Z2uK\u0012,\u0005pY3qi&|g\u000e\t\u0005\u0006S\u0001!\t!H\u0001\u0007i\"\u0014xn\u001e8)\u0005!Z\u0003C\u0001\u0017.\u001b\u0005\u0011\u0013B\u0001\u0018#\u0005\u0011\u0011V\u000f\\3\t\u000fA\u0002!\u0019!C\u0005c\u0005\tB/Z:u)\u0006\u0014G.\u001a+za\u0016LeNZ8\u0016\u0003I\u0002\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0013QL\b/Z;uS2\u001c(BA\u001c9\u0003\u0011Q\u0017M^1\u000b\u0005eB\u0011aA1qS&\u00111\b\u000e\u0002\f%><H+\u001f9f\u0013:4w\u000e\u0003\u0004>\u0001\u0001\u0006IAM\u0001\u0013i\u0016\u001cH\u000fV1cY\u0016$\u0016\u0010]3J]\u001a|\u0007\u0005C\u0004@\u0001\t\u0007I\u0011\u0002!\u0002!Q,7\u000f\u001e+bE2,'k\\<UsB,W#A!\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\r\u001a\tQ\u0001^=qKNL!\u0001S\"\u0003\u000fI{w\u000fV=qK\"1!\n\u0001Q\u0001\n\u0005\u000b\u0011\u0003^3tiR\u000b'\r\\3S_^$\u0016\u0010]3!\u0011\u001da\u0005A1A\u0005\n5\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u00039\u0003\"aT*\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002o%\u0011A\u000b\u0015\u0002\u0007'R\u0014\u0018N\\4\t\rY\u0003\u0001\u0015!\u0003O\u0003)!\u0018M\u00197f\u001d\u0006lW\r\t\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0003\u001d\u0019wN\u001c;fqR,\u0012A\u0017\t\u00067z\u0003\u0007N\\\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n1A+\u001e9mKN\u0002\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u000bQ|w\u000e\\:\u000b\u0005\u0015T\u0011aB2bY\u000eLG/Z\u0005\u0003O\n\u0014!BU3m\u0005VLG\u000eZ3s!\tIG.D\u0001k\u0015\tYG!\u0001\u0006eK2,w-\u0019;j_:L!!\u001c6\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003;FT!!\u000f:\u000b\u0005MD\u0011!C:ue\u0016\fW.\u001b8h\u0013\t)\bO\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000f\u0003\u0004x\u0001\u0001\u0006IAW\u0001\tG>tG/\u001a=uA!9\u0011\u0010\u0001b\u0001\n\u0013Q\u0018AD2bY\u000eLG/\u001a)mC:tWM]\u000b\u0002wB\u0011AP`\u0007\u0002{*\u0011Q\rB\u0005\u0003\u007fv\u0014\u0001C\u00127j].\u0004F.\u00198oKJLU\u000e\u001d7\t\u000f\u0005\r\u0001\u0001)A\u0005w\u0006y1-\u00197dSR,\u0007\u000b\\1o]\u0016\u0014\b\u0005C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n\u00051\u0001/\u0019:tKJ,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0005\u0003\u0015\u0001\u0018M]:f\u0013\u0011\t)\"a\u0004\u0003\u001b\r\u000bGnY5uKB\u000b'o]3s\u0011!\tI\u0002\u0001Q\u0001\n\u0005-\u0011a\u00029beN,'\u000f\t\u0005\b\u0003;\u0001A\u0011BA\u0010\u00039\u0001(/\u001a9be\u0016\u001cuN\u001c;fqR$2AWA\u0011\u0011!\t\u0019#a\u0007A\u0002\u0005\u0015\u0012\u0001\u0003;za\u0016LeNZ8\u0011\r\u0005\u001d\u0012\u0011GA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u0003;za\u0016LgNZ8\u000b\u0007\u0005=\u0002(\u0001\u0004d_6lwN\\\u0005\u0005\u0003g\tICA\bUsB,\u0017J\u001c4pe6\fG/[8o!\u0011\t9$a\u000f\u000e\u0005\u0005e\"B\u0001$\t\u0013\u0011\ti$!\u000f\u0003\u0007I{w\u000fC\u0004\u0002B\u0001!\t!a\u0011\u0002\u001bY,'/\u001b4z!\u0006$H/\u001a:o)\u0019\t)%a\u0013\u0002\\A\u00191,a\u0012\n\u0007\u0005%CL\u0001\u0003V]&$\b\u0002CA'\u0003\u007f\u0001\r!a\u0014\u0002\u001d5\fGo\u00195SK\u000e|wM\\5{KB!\u0011\u0011KA,\u001d\rY\u00161K\u0005\u0004\u0003+b\u0016A\u0002)sK\u0012,g-C\u0002U\u00033R1!!\u0016]\u0011!\ti&a\u0010A\u0002\u0005}\u0013\u0001C3ya\u0016\u001cG/\u001a31\t\u0005\u0005\u0014\u0011\u0011\t\t\u0003G\ni'!\u001d\u0002~5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0004qCR$XM\u001d8\u000b\u0007\u0005-\u0004\"A\u0002dKBLA!a\u001c\u0002f\t9\u0001+\u0019;uKJt\u0007\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]d!\u0001\u0003eCR\f\u0017\u0002BA>\u0003k\u0012qAU8x\t\u0006$\u0018\r\u0005\u0003\u0002\u0000\u0005\u0005E\u0002\u0001\u0003\r\u0003\u0007\u000bY&!A\u0001\u0002\u000b\u0005\u0011Q\u0011\u0002\u0004?\u0012\n\u0014\u0003BAD\u0003c\u00022aWAE\u0013\r\tY\t\u0018\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\ty\t\u0001C\u0005\u0003#\u000bqaY8na\u0006\u0014X\r\u0006\u0004\u0002F\u0005M\u0015q\u0014\u0005\t\u0003;\ni\t1\u0001\u0002\u0016B\"\u0011qSAN!!\t\u0019'!\u001c\u0002r\u0005e\u0005\u0003BA@\u00037#A\"!(\u0002\u0014\u0006\u0005\t\u0011!B\u0001\u0003\u000b\u00131a\u0018\u00133\u0011!\t\t+!$A\u0002\u0005\r\u0016AB1diV\fG\u000e\r\u0003\u0002&\u0006%\u0006\u0003CA2\u0003[\n\t(a*\u0011\t\u0005}\u0014\u0011\u0016\u0003\r\u0003W\u000by*!A\u0001\u0002\u000b\u0005\u0011Q\u0011\u0002\u0004?\u0012\u001a\u0004")
public abstract class PatternTranslatorTestBase
extends TestLogger {
    private final ExpectedException expectedException = ExpectedException.none();
    private final RowTypeInfo testTableTypeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO});
    private final RowType testTableRowType = RowType.of((LogicalType[])new LogicalType[]{new IntType()});
    private final String tableName;
    private final Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> context = this.prepareContext((TypeInformation<Row>)this.testTableTypeInfo());
    private final FlinkPlannerImpl calcitePlanner = ((PlannerBase)this.context()._2()).createFlinkPlanner();
    private final CalciteParser parser = ((PlannerBase)this.context()._2()).plannerContext().createCalciteParser();
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("f0");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("proctime");

    private ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private RowTypeInfo testTableTypeInfo() {
        return this.testTableTypeInfo;
    }

    private RowType testTableRowType() {
        return this.testTableRowType;
    }

    private String tableName() {
        return this.tableName;
    }

    private Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> context() {
        return this.context;
    }

    private FlinkPlannerImpl calcitePlanner() {
        return this.calcitePlanner;
    }

    private CalciteParser parser() {
        return this.parser;
    }

    private Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> prepareContext(TypeInformation<Row> typeInfo) {
        org.apache.flink.streaming.api.scala.DataStream dataStreamMock = (org.apache.flink.streaming.api.scala.DataStream)Mockito.mock(org.apache.flink.streaming.api.scala.DataStream.class);
        DataStream jDataStreamMock = (DataStream)Mockito.mock(DataStream.class);
        Mockito.when((Object)dataStreamMock.javaStream()).thenReturn((Object)jDataStreamMock);
        Mockito.when((Object)jDataStreamMock.getType()).thenReturn(typeInfo);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)jDataStreamMock.getId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        TableTestUtil$.MODULE$.createTemporaryView((TableEnvironment)tEnv, this.tableName(), dataStreamMock.javaStream(), (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).proctime()}), TableTestUtil$.MODULE$.createTemporaryView$default$5(), TableTestUtil$.MODULE$.createTemporaryView$default$6());
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        FlinkRelBuilder relBuilder = planner.getRelBuilder();
        relBuilder.scan(new String[]{this.tableName()});
        return new Tuple3((Object)relBuilder, (Object)planner, (Object)env);
    }

    public void verifyPattern(String matchRecognize, Pattern<RowData, ? extends RowData> expected) {
        SqlNode parsed = this.parser().parse(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT *\n         |FROM ", "\n         |", "\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), matchRecognize})))).stripMargin());
        SqlNode validated = this.calcitePlanner().validate(parsed);
        RelNode converted = this.calcitePlanner().rel((SqlNode)validated).rel;
        PlannerBase plannerBase = (PlannerBase)this.context()._2();
        RelNode optimized = (RelNode)plannerBase.optimize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{converted}))).head();
        if (!(optimized.getInput(0).getInput(0) instanceof StreamPhysicalDataStreamScan)) {
            Assert.fail((String)"Expression is converted into more than a Match operation. Use a different test method.");
        }
        StreamPhysicalMatch dataMatch = (StreamPhysicalMatch)optimized;
        Pattern p = (Pattern)StreamExecMatch.translatePattern((MatchSpec)MatchUtil$.MODULE$.createMatchSpec((MatchRecognize)dataMatch.logicalMatch()), (TableConfig)new TableConfig(), (RelBuilder)((RelBuilder)this.context()._1()), (RowType)this.testTableRowType()).f0;
        this.compare(expected, (Pattern<RowData, ? extends RowData>)p);
    }

    private void compare(Pattern<RowData, ? extends RowData> expected, Pattern<RowData, ? extends RowData> actual) {
        block2: {
            Pattern currentLeft = expected;
            Pattern currentRight = actual;
            do {
                boolean sameSkipStrategy;
                String string = currentLeft.getName();
                String string2 = currentRight.getName();
                boolean sameName = !(string != null ? !string.equals(string2) : string2 != null);
                Quantifier quantifier = currentLeft.getQuantifier();
                Quantifier quantifier2 = currentRight.getQuantifier();
                boolean sameQuantifier = !(quantifier != null ? !quantifier.equals(quantifier2) : quantifier2 != null);
                Quantifier.Times times = currentLeft.getTimes();
                Quantifier.Times times2 = currentRight.getTimes();
                boolean sameTimes = !(times != null ? !times.equals(times2) : times2 != null);
                AfterMatchSkipStrategy afterMatchSkipStrategy = currentLeft.getAfterMatchSkipStrategy();
                AfterMatchSkipStrategy afterMatchSkipStrategy2 = currentRight.getAfterMatchSkipStrategy();
                boolean bl = !(afterMatchSkipStrategy != null ? !afterMatchSkipStrategy.equals(afterMatchSkipStrategy2) : afterMatchSkipStrategy2 != null) ? true : (sameSkipStrategy = false);
                boolean sameTimeWindow = currentLeft.getWindowTime() == null || currentRight == null ? currentLeft.getWindowTime() == null && currentRight.getWindowTime() == null : currentLeft.getWindowTime().toMilliseconds() == currentRight.getWindowTime().toMilliseconds();
                currentLeft = currentLeft.getPrevious();
                currentRight = currentRight.getPrevious();
                if (!sameName || !sameQuantifier || !sameTimes || !sameSkipStrategy || !sameTimeWindow) break block2;
            } while (currentLeft != null);
            if (currentRight == null) {
                return;
            }
            throw new ComparisonFailure("Compiled different pattern.", expected.toString(), actual.toString());
        }
        throw new ComparisonFailure("Compiled different pattern.", expected.toString(), actual.toString());
    }

    public PatternTranslatorTestBase() {
        this.tableName = "testTable";
    }
}

